


## SAREF4GRID


### General Overview


An overview of the SAREF4GRID ontology is provided in Figures 1, 2, 3 and 4. For all the entities described in the present document, it is indicated whether they are defined in the SAREF4GRID extension or elsewhere by the prefix included before their identifier, i.e. if the element is defined in SAREF4GRID, the prefix is _s4grid_, while if the element is reused from another ontology it is indicated by a prefix according to Table 1.


Arrows are used to represent properties between classes and to represent some RDF, RDF-S and OWL constructs, more precisely:

* Plain arrows with white triangles represent the _rdfs:subClassOf_ relation between two classes. The origin of the arrow is the class to be declared as subclass of the class at the destination of the arrow. 
* Dashed arrows between two classes indicate a local restriction in the origin class, i.e. that the object property can be instantiated between the classes in the origin and the destination of the arrow. The identifier of the object property is indicated within the arrow.
* Dashed arrows with no identifier are used to represent the _rdf:type_ relation, indicating that the element in the origin of the arrow is an instance of the class in the destination of the arrow.

Datatype properties are denoted by rectangles attached to the classes, in an UML-oriented way. Dashed boxes represent local restrictions in the class, i.e. datatype properties that can be applied to the class they are attached to.


Individuals are denoted by rectangles in which the identifier is underlined.


Note that Figures 1, 2, 3 and 4 aim at showing a global overview of the main classes of SAREF4GRID and their mutual relations. More details on the different parts of the figures are provided from clause 4.2.2 to clause 4.2.14.

<figure>
    <img data-docx-width="14.49cm" src="diagrams/SAREF4GRID_Overview_1.png" alt="SAREF4GRID overview: Meter information"/>
    <figcaption>Figure 1: SAREF4GRID overview: Meter information</figcaption>
</figure>

<figure>
    <img data-docx-width="15.77cm" src="diagrams/SAREF4GRID_Overview_2.png" alt="SAREF4GRID overview: Observations and profiles"/>
    <figcaption>Figure 2: SAREF4GRID overview: Observations and profiles</figcaption>
</figure>

<figure>
    <img data-docx-width="13.72cm" src="diagrams/SAREF4GRID_Overview_3.png" alt="SAREF4GRID overview: Activity calendar and scripts "/>
    <figcaption>Figure 3: SAREF4GRID overview: Activity calendar and scripts </figcaption>
</figure>

<figure>
    <img data-docx-width="15.79cm" src="diagrams/SAREF4GRID_Overview_4.png" alt="SAREF4GRID overview: Services"/>
    <figcaption>Figure 4: SAREF4GRID overview: Services</figcaption>
</figure>


### Meter


Figure 5 provides an overview of how to represent an electric grid meter using the _s4grid:GridMeter_ class. The representation of electric grid meters and their properties has been extracted from the DLMS/COSEM standard (IEC 62056-1-0:2014 [i.2]).


Unlike in other SAREF extensions, meter-specific information is not defined using properties from SAREF. This is because the DLMS/COSEM standard defines the data structures to model meters from simple up to very complex functionality (IEC 62056-6-2:2017 [i.4]). Moreover, each piece of information within the metering equipment has a unique identifier called OBIS (OBject Identification System) which identifies the instance of a COSEM object (IEC 62056-6-1:2017 [i.3]). This data includes not only observation values, but also abstract values used for configuration or for obtaining information about the behaviour of the metering equipment.


For this reason, the characteristics of the meter are represented as properties that are not observable by the meter (_s4grid:MeterProperty_, fully represented in Figure 6), i.e. they are not observations (_saref:Observation_). The properties of a meter are defined by a value (_saref:PropertyValue_) and some are complemented with a unit of measurement (_saref:UnitOfMeasure_).

<figure>
    <img data-docx-width="11.22cm" src="diagrams/SAREF4GRID_Electric_grid_meter.png" alt="Meter model"/>
    <figcaption>Figure 5: Meter model</figcaption>
</figure>


Meters store internal configuration parameters. The DLMS/COSEM standard (IEC 62056-1-0:2014 [i.2]) defines properties related to the configuration of a meter that are necessary to ensure its correct operation. SAREF4GRID categorizes the main properties related to the configuration of a meter (_s4grid:MeterProperty_): screen display configuration (_s4grid:ScreenDisplay_), electric threshold values (_s4grid:Threshold_), time from which a measure has to be outside the threshold before to be considered a quality issue (_s4grid:TimeThreshold_), number of voltage sags (_s4grid:VoltageSagNumber_), number of voltage swells (_s4grid:VoltageSwellNumber_), number of long power failures (_s4grid:LongPowerFailuresNumber_), information provided by the manufacturer (_s4grid:Manufacturer_), turn ratio of the transformer (_s4grid:TransformerRatio_), communication configuration (_s4grid:Network_), status of meter profiles (_s4grid:ProfileStatus_), client power limits (_s4grid:PowerLimit_), reference values for power quality (_s4grid:PowerQuality_), client billing periods (_s4grid:BillingPeriod_), information about the electric grid phase (_s4grid:Phase_), information about the electric grid phase angle (_s4grid:PhaseAngle_), and electric quadrant (_s4grid:Quadrant_). It should be noted that in SAREF4GRID only the general properties are being defined. In order to use a more specific property it is advisable to indicate the general property it comes from (if it exists). The properties which are defined in SAREF4GRID are depicted in Figure 6.

<figure>
    <img data-docx-width="10.40cm" src="diagrams/SAREF4GRID_Meter_properties.png" alt="Meter property model"/>
    <figcaption>Figure 6: Meter property model</figcaption>
</figure>


Table 2 summarizes the property that characterizes the _s4grid:MeterProperty_ class.

<table data-docx-preferred-width="2.99cm 13.99cm">
  <caption>Table 2: Property of the s4grid:MeterProperty class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasObis</td>
    <td>It identifies the instance (COSEM object) of a class. The value of this property conforms to OBIS. OBject Identification System (OBIS) provides a unique identifier for all data within the metering equipment, including not only observation values, but also abstract values used for configuration or obtaining information about the behaviour of the metering equipment.</td>
  </tr>
</table>




### Firmware


SAREF4GRID allows describing the identification information related to administration and maintenance of meters by means of the _s4grid:Firmware_ class, as presented in Figure 7. They are not communication parameters but support device management. The representation of the firmware of a meter has been extracted from IEC 62056-6-2:2017 [i.4].


A meter firmware may be described by its: version (_s4grid:hasFirmwareVersion_), unique vendor identifier (_s4grid:hasVendorId_), and unique product identifier as assigned by the vendor (_s4grid:hasProductId_). Besides, a firmware can be related to an electric grid meter by means of the _s4grid:hasFirmware_ property.

<figure>
    <img data-docx-width="12.48cm" src="diagrams/SAREF4GRID_Firmware.png" alt="Firmware model"/>
    <figcaption>Figure 7: Firmware model</figcaption>
</figure>


Table 3 describes one of the properties that characterize the _s4grid:GridMeter_ class.

<table data-docx-preferred-width="3.12cm 13.99cm">
  <caption>Table 3: Property of the s4grid:GridMeter class related to firmware</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasFirmware</td>
    <td>Holds identification information related to administration and maintenance of meters. They are not communication parameters but allow the device management.</td>
  </tr>
</table>




Table 4 summarizes the properties that characterize the _s4grid:Firmware_ class.

<table data-docx-preferred-width="5.71cm 11.28cm">
  <caption>Table 4: Properties of the s4grid:Firmware class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasFirmwareVersion exactly 1</td>
    <td>Textual description of the firmware version running on the device.</td>
  </tr>
  <tr>
    <td>s4grid:hasObis</td>
    <td>It identifies the instance (COSEM object) of a class.</td>
  </tr>
  <tr>
    <td>s4grid:hasProductId exactly 1</td>
    <td>Vendor-assigned unique identifier for the specific product.</td>
  </tr>
  <tr>
    <td>s4grid:hasVendorId exactly 1</td>
    <td>Unique vendor identifier assigned by the PRIME Alliance.</td>
  </tr>
</table>




### Network interface


SAREF4GRID allows describing the MAC address of the physical device (or, more generally, of a device or software) by means of the _s4grid:NetworkInterface_ class, as presented in Figure 8. There shall be an instance of this class for each network interface of a meter. The representation of the network interface of a meter has been extracted from IEC 62056-6-2:2017 [i.4].

<figure>
    <img data-docx-width="13.51cm" src="diagrams/SAREF4GRID_Network_interface.png" alt="Network interface model"/>
    <figcaption>Figure 8: Network interface model</figcaption>
</figure>


Table 5 describes one of the properties that characterize the _s4grid:GridMeter_ class.

<table data-docx-preferred-width="4.32cm 12.66cm">
  <caption>Table 5: Property of the s4grid:GridMeter class related to network interface</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasNetworkInterface</td>
    <td>This class holds the MAC address of the physical device (or, more generally, of a device or software).</td>
  </tr>
</table>




Table 6 summarizes the properties that characterize the _s4grid:NetworkInterface_ class.

<table data-docx-preferred-width="5.49cm 11.49cm">
  <caption>Table 6: Properties of the s4grid:NetworkInterface class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasMACAddress exactly 1</td>
    <td>Holds the MAC address.</td>
  </tr>
  <tr>
    <td>s4grid:hasObis</td>
    <td>It identifies the instance (COSEM object) of a class.</td>
  </tr>
</table>




### Clock


SAREF4GRID allows describing the clock of a meter by means of the _s4grid:Clock_ class, as presented in Figure 9. This clock manages all information related to date and time including deviations of the local time to a generalized time reference (UTC) due to time zones and daylight-saving time schemes. The representation of the meter clock has been extracted from IEC 62056-6-2:2017 [i.4].


A meter clock may be described by its: time (_s4grid:hasTime_), time zone where the meter is located (_s4grid:hasTimeZone_), clock status maintained by the meter (_s4grid:hasStatus_), date at which the local time starts to deviate from the normal time (_s4grid:hasDaylightSavingsBegin_), date at which the local time ends to deviate from the normal time (_s4grid:hasDaylightSavingsEnd_), deviation in generalized time (_s4grid:hasDaylightSavingsDeviation_), if the daylight savings time feature is enabled (_s4grid:hasDaylightSavingsEnabled_), and where the basic timing information comes from (_s4grid:hasClockBase_). Besides, a clock can be related to a meter by means of the _s4grid:hasClock_ property.

<figure>
    <img data-docx-width="13.03cm" src="diagrams/SAREF4GRID_Clock.png" alt="Clock model"/>
    <figcaption>Figure 9: Clock model</figcaption>
</figure>


Table 7 describes one of the properties that characterize the _s4grid:GridMeter_ class.

<table data-docx-preferred-width="2.61cm 14.50cm">
  <caption>Table 7: Property of the s4grid:GridMeter class related to clock</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasClock</td>
    <td>This class models the device clock, managing all information related to date and time including deviations of the local time to a generalized time reference (UTC) due to time zones and daylight-saving time schemes.</td>
  </tr>
</table>




Table 8 summarizes the properties that characterize the _s4grid:Clock_ class.

<table data-docx-preferred-width="6.98cm 10.01cm">
  <caption>Table 8: Properties of the s4grid:Clock class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasClockBase exactly 1</td>
    <td><p>Defines where the basic timing information comes from:</p>
<p>(0)	not defined;</p>
<p>(1)	internal crystal;</p>
<p>(2)	mains frequency 50 Hz;</p>
<p>(3)	mains frequency 60 Hz;</p>
<p>(4)	GPS (global positioning system);</p>
<p>(5)	radio controlled.</p></td>
  </tr>
  <tr>
    <td>s4grid:hasDaylightSavingsBegin exactly 1</td>
    <td>Defines the local switch date and time when the local time starts to deviate from the normal time.</td>
  </tr>
  <tr>
    <td>s4grid:hasDaylightSavingsDeviation exactly 1</td>
    <td>Contains the number of minutes by which the deviation in generalized time shall be corrected at daylight savings begin.</td>
  </tr>
  <tr>
    <td>s4grid:hasDaylightSavingsEnabled exactly 1</td>
    <td>Enable and disable the daylight savings time feature.</td>
  </tr>
  <tr>
    <td>s4grid:hasDaylightSavingsEnd exactly 1</td>
    <td>Defines the local switch date and time when the local time ends to deviate from the local normal time.</td>
  </tr>
  <tr>
    <td>s4grid:hasObis</td>
    <td>It identifies the instance (COSEM object) of a class.</td>
  </tr>
  <tr>
    <td>s4grid:hasStatus exactly 1</td>
    <td>Status of the clock.</td>
  </tr>
  <tr>
    <td>s4grid:hasTime exactly 1</td>
    <td>Meter's local date and time.</td>
  </tr>
  <tr>
    <td>s4grid:hasTimeZone exactly 1</td>
    <td>The deviation of local, normal time to UTC in minutes. The value depends on the geographical location of the meter.</td>
  </tr>
</table>




### Breaker state


As it can be observed in Figure 10, the modelling of states in the SAREF4GRID ontology mostly relies on the state model proposed in SAREF. In order to reduce duplication with SAREF documentation, the reader is referred to the SAREF specification ETSI TS 103 264 [1] for details about state modelling including here details only for the new concepts.


SAREF allows to define the state in which a device can be found. However, the SAREF4GRID extension also requires to be able to define the possible transitions between states and complex states. Therefore, the _s4grid:BreakerState_ class has been defined according to IEC 62056-6-2:2017 [i.4].


A meter breaker represents the internal or external disconnect unit of the meter (e.g. electricity breaker, gas valve) in order to connect or disconnect the premises of the consumer to/from the supply. A meter breaker state may be described by its: physical state (_s4grid:hasOutputState_), internal state (_s4grid:hasControlState_) and the possible transitions between states (_s4grid:hasControlMode_). For more information between the possible transitions see IEC 62056-6-2:2017 [i.4].

<figure>
    <img data-docx-width="10.60cm" src="diagrams/SAREF4GRID_Breaker_state.png" alt="Breaker state model"/>
    <figcaption>Figure 10: Breaker state model</figcaption>
</figure>


Table 9 summarizes the properties that characterize the _s4grid:BreakerState_ class.

<table data-docx-preferred-width="5.71cm 11.28cm">
  <caption>Table 9: Properties of the s4grid:BreakerState class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasControlMode exactly 1</td>
    <td>Configures the behaviour of the disconnect control object for all triggers, i.e. the possible state transitions.</td>
  </tr>
  <tr>
    <td>s4grid:hasControlState exactly 1</td>
    <td><p>Shows the internal state of the disconnect control object:</p>
<p>(0)	Disconnected;</p>
<p>(1)	Connected;</p>
<p>(2)	Ready for reconnection.</p></td>
  </tr>
  <tr>
    <td>s4grid:hasObis</td>
    <td>It identifies the instance (COSEM object) of a class.</td>
  </tr>
  <tr>
    <td>s4grid:hasOutputState exactly 1</td>
    <td>Shows the actual physical state of the device connection the supply: (True) Connected, (False) Disconnected.</td>
  </tr>
</table>




### Script table


As it can be observed in Figure 11, the modelling of scripts in the SAREF4GRID ontology mostly relies on the service model proposed in SAREF. In order to reduce duplication with SAREF documentation, the reader is referred to the SAREF specification [1] for details about service modelling including here details only for the new concepts.


SAREF allows to define the functions which accomplish the task for which a device is designed. However, the SAREF4GRID extension also requires to be able to define the triggering of a series of actions by executing scripts, and where those scripts are stored. Therefore, the _s4grid:ScriptTable_ class has been defined according to IEC 62056-6-2:2017 [i.4].


A script table represents a table of script entries. Moreover, the _s4grid:Script_ class defines a series of action specifications. An action specification activates a method or modifies an attribute of a COSEM object within the logical device. Besides, a script table can be related to an electric grid meter by means of the _s4grid:hasScriptTable_ property.

<figure>
    <img data-docx-width="9.94cm" src="diagrams/SAREF4GRID_Script_table.png" alt="Script table model"/>
    <figcaption>Figure 11: Script table model</figcaption>
</figure>


Table 10 describes one of the properties that characterize the _s4grid:GridMeter_ class.

<table data-docx-preferred-width="3.96cm 13.02cm">
  <caption>Table 10: Property of the s4grid:GridMeter class related to script table</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasScriptTable</td>
    <td>The triggering of a series of actions by executing scripts.</td>
  </tr>
</table>




Table 11 summarizes the properties that characterize the _s4grid:ScriptTable_ class.

<table data-docx-preferred-width="5.71cm 11.28cm">
  <caption>Table 11: Properties of the s4grid:ScriptTable class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:storesScript</td>
    <td>Specifies the different scripts which are stored in a script table.</td>
  </tr>
  <tr>
    <td>s4grid:hasObis</td>
    <td>It identifies the instance (COSEM object) of a class.</td>
  </tr>
</table>




### Scheduled action


SAREF4GRID allows the execution of periodic actions within a meter by means of the _s4grid:SingleScheduledAction_ class, as presented in Figure 12; such actions are not necessarily linked to tariffication. A scheduled action describes the script, which is stored in a script table, that is going to be executed at a determined date. The representation of the meter scheduled action has been extracted from IEC 62056-6-2:2017 [i.4].


A meter single scheduled action may be described by its: execution time (_s4grid:hasExecutionTime_) and what script is going to be executed (_s4grid:executesScript_). Besides, a single schedule action can be related to a meter by means of the _s4grid:hasSingleScheduledAction_ property.

<figure>
    <img data-docx-width="16.68cm" src="diagrams/SAREF4GRID_Scheduled_action.png" alt="Scheduled action model"/>
    <figcaption>Figure 12: Scheduled action model</figcaption>
</figure>


Table 12 describes one of the properties that characterize the _s4grid:GridMeter_ class.

<table data-docx-preferred-width="4.99cm 12.00cm">
  <caption>Table 12: Property of the s4grid:GridMeter class related to scheduled action</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasSingleScheduledAction</td>
    <td>The execution of periodic actions within a meter; such actions are not necessarily linked to tariffication.</td>
  </tr>
</table>




Table 13 summarizes the properties that characterize the _s4grid:SingleScheduledAction_ class.

<table data-docx-preferred-width="5.71cm 11.28cm">
  <caption>Table 13: Properties of the s4grid:SingleScheduledAction class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:executesScript exactly 1</td>
    <td>Defines the script to be executed.</td>
  </tr>
  <tr>
    <td>s4grid:hasExecutionTime</td>
    <td>Specifies the time and the date when the script is executed.</td>
  </tr>
  <tr>
    <td>s4grid:hasObis</td>
    <td>It identifies the instance (COSEM object) of a class.</td>
  </tr>
</table>




### Activity calendar


SAREF4GRID allows modelling the handling of various tariff structures in the meter by means of the _s4grid:ActivityCalendar_ class, as presented in Figure 13. An activity calendar provides a list of scheduled actions, following the classical way of calendar-based schedules by defining seasons, weeks, etc. The representation of the meter activity calendar has been extracted from IEC 62056-6-2:2017 [i.4].


An activity calendar is active (_s4grid:hasCalendarNameActive_) if it is currently used for billing. Each active calendar has an associated passive calendar (_s4grid:hasCalendarNamePassive_) and its function is to allow to modify the parameters of the active calendar on a date prior to its activation date (_s4grid:hasActivatePassiveCalendarTime_). Activation date is the date from which the meter will use the passive calendar parameters and, therefore, they become active calendar parameters. An active calendar is compound by active seasons (_s4grid:hasActiveSeasonProfile_) and a passive calendar is compound by passive seasons (_s4grid:hasPassiveSeasonProfile_). Notice that there is no distinction between an active calendar and a passive calendar because together they represent an activity calendar and they share the same OBIS code.


A season profile (_s4grid:SeasonProfile_) represents periods of time during the year when billing conditions are always the same. A season profile is characterized by a start date (_s4grid:hasSeasonStart_) and seven day profiles (_s4grid:hasDayProfile_) to apply, which together represent a week (there is one day profile for each day of the week). A season profile finishes when the next season profile begins.


A day profile (_s4grid:DayProfile_) represents the discrimination of time along the day. Moreover, the seven day profiles together represent a period during the week when billing conditions are always the same. There are two day profiles: regular days (_s4grid:RegularDayProfile_), which represent not festive days, and special days (_s4grid:SpecialDayProfile_), which represent at which date there is a festivity, i.e. normal day behaves as a special day (_s4grid:hasScpecialDayDate_). A day profile is characterized by a day schedule (_s4grid:hasDaySchedule_).


A day schedule (_s4grid:DaySchedule_) defines the activation of certain scripts during the day, which can perform different activities inside the meter. For each day schedule, a list of scheduled actions is defined by a script to be executed (_s4grid:executesScript_) with the corresponding activation time (_s4grid:hasStartTime_).

<figure>
    <img data-docx-width="16.73cm" src="diagrams/SAREF4GRID_Activity_calendar.png" alt="Activity calendar model"/>
    <figcaption>Figure 13: Activity calendar model</figcaption>
</figure>


Table 14 describes one of the properties that characterize the _s4grid:GridMeter_ class.

<table data-docx-preferred-width="4.26cm 12.72cm">
  <caption>Table 14: Property of the s4grid:GridMeter class related to activity calendar</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasActivityCalendar</td>
    <td>Allows handling various tariff structures in the meter. This class provides a list of scheduled actions, following the classical way of calendar-based schedules by defining seasons, weeks, etc.</td>
  </tr>
</table>




Table 15 summarizes the properties that characterize the _s4grid:ActivityCalendar_ class.

<table data-docx-preferred-width="6.50cm 10.48cm">
  <caption>Table 15: Properties of the s4grid:ActivityCalendar class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasActiveSeasonProfile</td>
    <td>Contains a list of active season profiles. These season profiles form an active calendar.</td>
  </tr>
  <tr>
    <td>s4grid:hasPassiveSeasonProfile</td>
    <td>Contains a list of passive season profiles. These season profiles form a passive calendar.</td>
  </tr>
  <tr>
    <td>s4grid:hasActivatePassiveCalendarTime max 1</td>
    <td>Defines the time when the passive calendar will be activated.</td>
  </tr>
  <tr>
    <td>s4grid:hasCalendarNameActive exactly 1</td>
    <td>User defined name identifying the passive calendar. Typically contains an identifier of the active calendar (currently active), which is descriptive to the set of scripts activated by the object.</td>
  </tr>
  <tr>
    <td>s4grid:hasCalendarNamePassive exactly 1</td>
    <td>User defined name identifying the passive calendar. Typically contains an identifier of the passive calendar (will be activated), which is descriptive to the set of scripts activated by the object.</td>
  </tr>
  <tr>
    <td>s4grid:hasObis</td>
    <td>It identifies the instance (COSEM object) of a class.</td>
  </tr>
</table>




Table 16 summarizes the properties that characterize the _s4grid:SeasonProfile_ class.

<table data-docx-preferred-width="6.35cm 10.63cm">
  <caption>Table 16: Properties of the s4grid:SeasonProfile class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasDayProfile</td>
    <td>List of scheduled actions which are defined by a script to be executed and the corresponding activation time.</td>
  </tr>
  <tr>
    <td>s4grid:hasSeasonStart exactly 1</td>
    <td>Starting time of the season profile. The current season profile is terminated by the starting time of the next season profile.</td>
  </tr>
  <tr>
    <td>s4grid:hasSeasonProfileName exactly 1</td>
    <td>User defined name identifying the current season profile.</td>
  </tr>
  <tr>
    <td>s4grid:hasSpecialDayProfile</td>
    <td>It defines when there is a festivity and therefore a normal day behaves as a special date.</td>
  </tr>
  <tr>
    <td>s4grid:hasMondayProfile exactly 1</td>
    <td>It defines the day profile valid each Monday of the season.</td>
  </tr>
  <tr>
    <td>s4grid:hasTuesdayProfile exactly 1</td>
    <td>It defines the day profile valid each Tuesday of the season.</td>
  </tr>
  <tr>
    <td>s4grid:hasWednesdayProfile exactly 1</td>
    <td>It defines the day profile valid each Wednesday of the season.</td>
  </tr>
  <tr>
    <td>s4grid:hasThursdayProfile exactly 1</td>
    <td>It defines the day profile valid each Thursday of the season.</td>
  </tr>
  <tr>
    <td>s4grid:hasFridayProfile exactly 1</td>
    <td>It defines the day profile valid each Friday of the season.</td>
  </tr>
  <tr>
    <td>s4grid:hasSaturdayProfile exactly 1</td>
    <td>It defines the day profile valid each Saturday of the season.</td>
  </tr>
  <tr>
    <td>s4grid:hasSundayProfile exactly 1</td>
    <td>It defines the day profile valid each Sunday of the season.</td>
  </tr>
</table>




Table 17 summarizes the properties that characterize the _s4grid:SpecialDayProfile_ class.

<table data-docx-preferred-width="5.55cm 11.44cm">
  <caption>Table 17: Property of the s4grid:SpecialDayProfile class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasSpecialDayDate exactly 1</td>
    <td>Dates at which a normal day is considered a special date (i.e. Christmas).</td>
  </tr>
</table>




Table 18 summarizes the properties that characterize the _s4grid:DayProfile_ class.

<table data-docx-preferred-width="5.55cm 11.44cm">
  <caption>Table 18: Property of the s4grid:DayProfile class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasDaySchedule</td>
    <td>Scheduled actions to be executed at a given time for a day profile.</td>
  </tr>
</table>




Table 19 summarizes the properties that characterize the _s4grid:DaySchedule_ class.

<table data-docx-preferred-width="6.50cm 10.48cm">
  <caption>Table 19: Properties of the s4grid:DaySchedule class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:executesScript exactly 1</td>
    <td>Defines the script to be executed.</td>
  </tr>
  <tr>
    <td>s4grid:hasStartTime exactly 1</td>
    <td>Time when the script is going to be executed.</td>
  </tr>
</table>




### Power line properties


As it can be observed in Figure 14 and Figure 15, the modelling of observations in the SAREF4GRID ontology mostly relies on the observation model proposed in SAREF. In order to reduce duplication with SAREF documentation, the reader is referred to the SAREF specification [1] for details about observation modelling including here details only for the new concepts.


The DLMS/COSEM standard (IEC 62056-1-0 [i.2]) defines the observations that a meter shall take from a power line. It should be noted that in SAREF4GRID only the general properties are being defined. In order to use a more specific property it is necessary to indicate the general property from which it comes from. The properties that are defined in SAREF4GRID, which are measured from a power line (_s4grid:PowerLine_), are depicted in Figure 14 and Figure 15.


SAREF4GRID categorizes the main properties related to the energy and power observations of a power line (_s4grid:EnergyPowerProperty_): active energy observations (_s4grid:ActiveEnergy_), reactive energy measurements observations (_s4grid:ReactiveEnergy_), apparent power observations (_s4grid:ApparentPower_), demand register observations (_s4grid:DemandRegister_), active power observations (_s4grid:ActivePower_), reactive power observations (_s4grid:ReactivePower_), current observations (_s4grid:Current_), voltage observations (_s4grid:Voltage_), and power factor related observations (_s4grid:PowerFactor_).

<figure>
    <img data-docx-width="16.74cm" src="diagrams/SAREF4GRID_Energy_and_power_properties.png" alt="Energy and power property model"/>
    <figcaption>Figure 14: Energy and power property model</figcaption>
</figure>


Table 20 summarizes the properties that characterize the _s4grid:EnergyPowerProperty_ class.

<table data-docx-preferred-width="3.96cm 13.02cm">
  <caption>Table 20: Property of the s4grid:EnergyPowerProperty class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasObis</td>
    <td>It identifies the instance (COSEM object) of a class.</td>
  </tr>
</table>




SAREF4GRID also categorises the main properties related to the quality observations of a power line (_s4grid:QualityProperty_): duration of voltage sags (_s4grid:DurationVoltageSag_), duration of voltage swells (_s4grid:DurationVoltageSwell_), and duration of long power failures (_s4grid:DurationLongPowerFailure_).

<figure>
    <img data-docx-width="17.00cm" src="diagrams/SAREF4GRID_Quality_properties.png" alt="Quality property model"/>
    <figcaption>Figure 15: Quality property model</figcaption>
</figure>


Table 21 summarizes the properties that characterize the _s4grid:QualityProperty_ class.

<table data-docx-preferred-width="3.99cm 12.99cm">
  <caption>Table 21: Property of the s4grid:QualityProperty class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasObis</td>
    <td>It identifies the instance (COSEM object) of a class.</td>
  </tr>
</table>




### Profile generic


SAREF4GRID allows modelling the storing, sorting and accessing of data groups or data series (i.e. capture objects in COSEM) in the meter by means of the _s4grid:ProfileGeneric_ class, as presented in Figure 16. Capture objects are specific attributes or elements of (an) attribute(s) of COSEM objects. The capture objects are collected periodically or occasionally. The representation of the profile generic of a meter has been extracted from IEC 62056-6-2:2017 [i.4].


A profile generic is represented by the objects that it captures (_s4grid:Clock, saref:PropertyValues_ and _saref:Observations_). These objects are collected in each period defined in the _s4grid:hasCapturePeriod_ property.

<figure>
    <img data-docx-width="13.76cm" src="diagrams/SAREF4GRID_Profile_generic.png" alt="Profile generic model"/>
    <figcaption>Figure 16: Profile generic model</figcaption>
</figure>


Table 22 describes one of the properties that characterize the _s4grid:GridMeter_ class.

<table data-docx-preferred-width="3.96cm 13.02cm">
  <caption>Table 22: Property of the s4grid:GridMeter class related to profile generic</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasProfileGeneric</td>
    <td>The class that provides a generalized concept allowing to store, sort and access data groups or data series, called capture objects. Capture objects are appropriate attributes or elements of (an) attribute(s) of COSEM objects. The capture objects are collected periodically or occasionally.</td>
  </tr>
</table>




Table 23 summarizes the properties that characterize the _s4grid:ProfileGeneric_ class.

<table data-docx-preferred-width="5.39cm 11.60cm">
  <caption>Table 23: Property of the s4grid:ProfileGeneric class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:relatedClock</td>
    <td>The clock that is captured by a profile generic.</td>
  </tr>
  <tr>
    <td>s4grid:relatedObservation</td>
    <td>The observation that is captured by a profile generic.</td>
  </tr>
  <tr>
    <td>s4grid:relatedPropertyValue</td>
    <td>The property value that is captured by a profile generic.</td>
  </tr>
  <tr>
    <td>s4grid:hasCapturePeriod exactly 1</td>
    <td>The capturing period of a profile generic in seconds. If its value is 0, then there is no automatic capturing; capturing is triggered externally or through capture events that occur asynchronously. If its value is greater than 0, then automatic capturing is assumed.</td>
  </tr>
  <tr>
    <td>s4grid:hasObis</td>
    <td>It identifies the instance (COSEM object) of a class.</td>
  </tr>
</table>




### Get service


Figure 17 provides an overview of the modelling of get services (_s4grid:GetService_). A get service is performed through get operations (_s4grid:GetOperation_). The get operation modelling involves two main concepts, namely _s4grid:CosemOperationInput_ and _s4grid:GetOperationOutput_. As can be seen in the figure, the modelling of get services totally relies on the service model proposed in ETSI TS 118 112 [2]. In order to reduce duplication with the oneM2M documentation, the reader is referred to the oneM2M specification for details about service modelling. The representation of the inputs and outputs of a get service has been extracted from IEC 62056-6-2:2017 [i.4].


A get operation needs one input which represents what is going to be retrieved (the whole instance or just a property of the instance). Therefore, the input of a get operation can be either a class, the range of a datatype property, or the range of an object property. The _s4grid:CosemOperationInput_ class specifies the instance from which data is going to be retrieved by indicating the OBIS code (_s4grid:obtainInputFromObis_). If only the OBIS code is specified, it is understood that the whole instance is going to be retrieved. Moreover, the _s4grid:GetOperationPropertyInput_ class specifies the object/datatype property of an instance from which data is going to be retrieved by indicating the OBIS code and the name of the object/datatype property (_s4grid:obtaintInputForProperty_). If the OBIS code and the property name are specified, it is understood that just the range of a property of the instance is going to be retrieved.


A get operation is going to generate one output which represents the type of what is going to be retrieved. The output of a get operation (_s4grid:GetOperationOutput_) can be either a class or a datatype. The _s4grid:GetOperationDataOutput_ class specifies that the output is going to be a datatype. In this case the type of the output is defined using the _s4grid:hasOutputDataType_ property, indicating the type of the datatype. The _s4grid:GetOperationObjectOutput_ class specifies that the output is going to be a class. In this case the type of the output is defined using the _s4grid:hasOutputObjectType_ property, indicating the name of the class.


Additionally, in the case of a get service of a _s4grid:ProfileGeneric_ class, a selective access (_s4grid:SelectiveAccess_) can be specified. This indicates the range of entries to be retrieved (_s4grid:EntryDescriptor_) or the range of values (_s4grid:RangeDescriptor_) to be retrieved from a _s4grid:ProfileGeneric_ class.

<figure>
    <img data-docx-width="18.53cm" src="diagrams/SAREF4GRID_Get_service.png" alt="Get service model"/>
    <figcaption>Figure 17: Get service model</figcaption>
</figure>


Table 24 summarizes the properties that characterize the _s4grid:GetOperation_ class.

<table data-docx-preferred-width="4.24cm 12.74cm">
  <caption>Table 24: Property of the s4grid:GetOperation class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasSelectiveAccess</td>
    <td>The selective access of a profile generic get service. The get operations property-related services typically reference the entire property. However, in the case of certain properties, selective access to only part of the property may be provided.</td>
  </tr>
</table>




Table 25 summarizes the properties that characterize the _s4grid:CosemOperationInput_ class.

<table data-docx-preferred-width="5.53cm 11.60cm">
  <caption>Table 25: Property of the s4grid:CosemOperationInput class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:obtainInputFromObis exactly 1</td>
    <td>It identifies the instance (COSEM object) of a class from which the data is going to be obtained. The value of this property conforms to OBIS.</td>
  </tr>
</table>




Table 26 summarizes the properties that characterize the _s4grid:GetOperationPropertyInput_ class.

<table data-docx-preferred-width="5.99cm 10.99cm">
  <caption>Table 26: Property of the s4grid:GetOperationPropertyInput class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:obtainInputForProperty exactly 1</td>
    <td>It identifies the attribute of an instance (COSEM object) of a class from which the data is going to be obtained. The value of this property conforms to an object property or datatype property of SAREF4GRID.</td>
  </tr>
</table>




Table 27 summarizes the properties that characterize the _s4grid:EntryDescriptor_ class.

<table data-docx-preferred-width="3.97cm 13.02cm">
  <caption>Table 27: Properties of the s4grid:EntryDescriptor class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:obtainFromEntry</td>
    <td>It defines the first entry to be retrieved from a profile generic.</td>
  </tr>
  <tr>
    <td>s4grid:obtainToEntry</td>
    <td>It defines the last entry to be retrieved from a profile generic.</td>
  </tr>
</table>




Table 28 summarizes the properties that characterize the _s4grid:RangeDescriptor_ class.

<table data-docx-preferred-width="3.97cm 13.02cm">
  <caption>Table 28: Properties of the s4grid:RangeDescriptor class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:obtainFromValue</td>
    <td>It restricts the range of entries to be retrieved from a profile generic defining the oldest or smallest entry to retrieve.</td>
  </tr>
  <tr>
    <td>s4grid:obtainToValue</td>
    <td>It restricts the range of entries to be retrieved from a profile generic defining the newest or largest entry to retrieve.</td>
  </tr>
</table>




Table 29 summarizes the properties that characterize the _s4grid:GetOperationDataOutput_ class.

<table data-docx-preferred-width="5.07cm 11.91cm">
  <caption>Table 29: Property of the s4grid:GetOperationDataOutput class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasOutputDataType exactly 1</td>
    <td>It identifies the type of the attribute of an instance (COSEM object) of a class from which the data is going to be obtained. The value of this property conforms to the range of a datatype property of SAREF4GRID.</td>
  </tr>
</table>




Table 30 summarizes the properties that characterize the _s4grid:GetOperationObjectOutput_ class.

<table data-docx-preferred-width="5.66cm 11.60cm">
  <caption>Table 30: Property of the s4grid:GetOperationObjectOutput class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasOutputObjectType exactly 1</td>
    <td>It identifies the type of the attribute of an instance (COSEM object) of a class from which the data is going to be obtained. The value of this property conforms to the range of an object property of SAREF4GRID.</td>
  </tr>
</table>




### Set service


Figure 18 provides an overview of the modelling of set services (_s4grid:SetService_). A set service is performed through set operations (_s4grid:SetOperation_). The set operation modelling involves one main concept, namely _s4grid:CosemOperationInput_. As can be seen in the figure, the modelling of set services totally relies on the service model proposed in ETSI TS 118 112 [2]. In order to reduce duplication with the oneM2M documentation, the reader is referred to the oneM2M specification for details about service modelling. The representation of the inputs and outputs of a set service has been extracted from IEC 62056-6-2:2017 [i.4].


A set operation needs two inputs: the element that is going to be modified and the new data that is going to replace the old data. The element that is going to be modified is represented by a class meanwhile the new data is represented either by a class, the range of a datatype property, or the range of an object property (depending on if the whole instance is going to be modified or just a property). Therefore, the _s4grid:CosemOperationInput_ class specifies the instance from which data is going to be modified by indicating the OBIS code (_s4grid:obtaintInputFromObis_) and the new data is represented either by the _s4grid:SetOperationObisInput_, _s4grid:SetOperationObjectInput_, or _s4grid:SetOperationDataInput_ classes.


The _s4grid:SetOperationObisInput_ class indicates that the whole instance is going to be modified. In this case the type of the input is defined using the _s4grid:hasInputObjectType_ property, indicating the name of the class expected to modify the instance. The _s4grid:SetOperationObjectInput_ class indicates that just the range of an object property of the instance is going to be modified. In this case the type of the input is defined using the _s4grid:obtainInputForProperty_, which indicates the name of the object property whose range is going to be modified, and the _s4grid:hasInputObjectType_ property, indicating the name of the class expected to modify the range of the object property. The _s4grid:SetOperationDataInput_ class indicates that just the range of a datatype property of the instance is going to be modified. In this case the type of the input is defined using the _s4grid:obtainInputForProperty_, which indicates the name of the datatype property whose range is going to be modified, and the _s4grid:hasInputDataType_ property, which indicates the type of the datatype expected to modify the range of the datatype property_.

<figure>
    <img data-docx-width="18.05cm" src="diagrams/SAREF4GRID_Set_service.png" alt="Set service model"/>
    <figcaption>Figure 18: Set service model</figcaption>
</figure>


Table 31 summarizes the properties that characterize the _s4grid:CosemOperationInput_ class.

<table data-docx-preferred-width="5.66cm 11.60cm">
  <caption>Table 31: Property of the s4grid:CosemOperationInput class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:obtainInputFromObis exactly 1</td>
    <td>It identifies the instance (COSEM object) of a class from which the data is going to be obtained. The value of this property conforms to OBIS.</td>
  </tr>
</table>




Table 32 summarizes the properties that characterize the _s4grid:SetOperationObisInput_ class.

<table data-docx-preferred-width="5.71cm 11.28cm">
  <caption>Table 32: Property of the s4grid:SetOperationObisInput class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasInputObjectType exactly 1</td>
    <td>It identifies the type of the attribute of an instance (COSEM object) of a class from which the data is going to be obtained. The value of this property conforms to the range of an object property of SAREF4GRID.</td>
  </tr>
</table>




Table 33 summarizes the properties that characterize the _s4grid:SetOperationObjectInput_ class.

<table data-docx-preferred-width="5.81cm 11.28cm">
  <caption>Table 33: Properties of the s4grid:SetOperationObjectInput class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:obtainInputForProperty exactly 1</td>
    <td>It identifies the attribute of an instance (COSEM object) of a class from which the data is going to be obtained. The value of this property conforms to and object property or datatype property of SAREF4GRID.</td>
  </tr>
  <tr>
    <td>s4grid:hasInputObjectType exactly 1</td>
    <td>It identifies the type of the attribute of an instance (COSEM object) of a class from which the data is going to be obtained. The value of this property conforms to the range of an object property of SAREF4GRID.</td>
  </tr>
</table>




Table 34 summarizes the properties that characterize the _s4grid:SetOperationDataInput_ class.

<table data-docx-preferred-width="5.81cm 11.28cm">
  <caption>Table 34: Properties of the s4grid:SetOperationDataInput class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:obtainInputForProperty exactly 1</td>
    <td>It identifies the attribute of an instance (COSEM object) of a class from which the data is going to be obtained. The value of this property conforms to and object property or datatype property of SAREF4GRID.</td>
  </tr>
  <tr>
    <td>s4grid:hasInputDataType exactly 1</td>
    <td>It identifies the type of the attribute of an instance (COSEM object) of a class from which the data is going to be obtained. The value of this property conforms to the range of a datatype property of SAREF4GRID.</td>
  </tr>
</table>




### Action service


Figure 19 provides an overview of the modelling of action services (_s4grid:ActionService_). An action service is performed through action operations (_s4grid:ActionOperation_). The action operation modelling involves one main concept, namely _s4grid:CosemOperationInput_. As can be seen in the figure, the modelling of action services totally relies on the service model proposed in ETSI TS 118 112 [2]. In order to reduce duplication with the oneM2M documentation, the reader is referred to the oneM2M specification for details about service modelling. The representation of the inputs and outputs of an action service has been extracted from IEC 62056-6-2:2017 [i.4].


An action operation needs two inputs: the element that is going to be affected by an action and the parameters necessary for the action to be executed. The element that is going to be affected by an action is represented by a class and the parameters are either represented by a class or a value. Therefore, the _s4grid:CosemOperationInput_ class specifies the instance from which data is going to be modified by indicating the OBIS code (_s4grid:obtainInputFromObis_) and the parameters are represented either by the _s4grid:SimpleActionOperationInput_ or the _s4grid:ComplexActionOperationInput_ classes. The _s4grid:CosemOperationInput_ class specifies the instance that is going to be affected by the action by indicating the OBIS code (_s4grid:obtainInputFromObis_). The _s4grid:SimpleActionOperationInput_ class indicates that the parameter needed by the action to operate is simple (i.e. integer, string, etc.). In this case the value of the parameter is defined using the _s4grid:hasActionValue_ property. The _s4grid:ComplexActionOperationInput_ class indicates that the parameter needed by the action to operate is complex (i.e. structure). There are two cases of complex parameters: _s4grid:PresetAdjustingTime_ class, which is needed by a _s4grid:Clock_ to modify the time, and _s4grid:SpecialDayEntry_ class, which is needed by an _s4grid:ActivityCalendar_ to adding a new special day.

<figure>
    <img data-docx-width="16.84cm" src="diagrams/SAREF4GRID_Action_service.png" alt="Action service model"/>
    <figcaption>Figure 19: Action service model</figcaption>
</figure>


Table 35 summarizes the properties that characterize the _s4grid:CosemOperationInput_ class.

<table data-docx-preferred-width="5.66cm 11.60cm">
  <caption>Table 35: Property of the s4grid:CosemOperationInput class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:obtainInputFromObis exactly 1</td>
    <td>It identifies the instance (COSEM object) of a class from which the data is going to be obtained. The value of this property conforms to OBIS.</td>
  </tr>
</table>




Table 36 summarizes the properties that characterize the _s4grid:SimpleOperationInput_ class.

<table data-docx-preferred-width="4.91cm 12.07cm">
  <caption>Table 36: Property of the s4grid:SimpleOperationInput class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasActionValue exactly 1</td>
    <td>It specifies the input of a method from the instance (COSEM object) of a class. The value of this property conforms to a simple type (not a structure).</td>
  </tr>
</table>




Table 37 summarizes the properties that characterize the _s4grid:PresetAdjustingTime_ class.

<table data-docx-preferred-width="6.18cm 10.80cm">
  <caption>Table 37: Properties of the s4grid:PresetAdjustingTime class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasPresetTime exactly 1</td>
    <td>It pre-sets the clock time to a new value.</td>
  </tr>
  <tr>
    <td>s4grid:hasValidityIntervalEnd exactly 1</td>
    <td>It defines the end of a validity interval within which the new time can be activated.</td>
  </tr>
  <tr>
    <td>s4grid:hasValidityIntervalStart exactly 1</td>
    <td>It defines the start of a validity interval within which the new time can be activated.</td>
  </tr>
</table>




Table 38 summarizes the properties that characterize the _s4grid:SpecialDayEntry_ class.

<table data-docx-preferred-width="6.18cm 10.80cm">
  <caption>Table 38: Properties of the s4grid:SpecialDayEntry class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4grid:hasDayId exactly 1</td>
    <td>It defines the unique identifier of a day.</td>
  </tr>
  <tr>
    <td>s4grid:hasSpecialDate exactly 1</td>
    <td>It defines the date at which a normal day is considered a special date.</td>
  </tr>
  <tr>
    <td>s4grid:hasIndex exactly 1</td>
    <td>It defines the index of the special day.</td>
  </tr>
</table>


