The present document is the technical specification of SAREF4ENVI, an extension of SAREF [[1]](#[1]) for the environment domain. The extension was created in collaboration with domain experts in the field of light pollution currently working in the STARS4ALL European H2020 project ([http://www.stars4all.eu/index.php/lpi/](http://www.stars4all.eu/index.php/lpi/)). The STARS4ALL project is composed by partners such as Universidad Politécnica de Madrid, Universidad Complutense de Madrid, ESCP Europe, Leibniz Institute of Freshwater Ecology and Inland Fisheries, Instituto de Astrofísica de Canarias, University of Southampton, Europan Crowdfunding Network, and CEFRIEL (Società Consortile a Responsabilita Limitata).

SAREF4ENVI has two main aims: on the one hand, to be the basis for enabling the use of SAREF in the environment domain and, on the other hand, to exemplify how to enable interoperability between environmental devices in cooperation.

SAREF4ENVI is an OWL-DL ontology that extends SAREF with 32 classes (24 defined in SAREF4ENVI and 7 reused from the time, SAREF and geo ontologies), 24 object properties (22 defined in SAREF4ENVI and 2 reused from the SAREF and geo ontologies), 13 data type properties (9 defined in SAREF4ENVI and 4 reused from the SAREF ontology), and 24 individuals (9 defined in SAREF4ENVI and 12 reused from the OM ontology). SAREF4ENVI focuses on extending SAREF for photometers to solve the lack of interoperability between sensors that can measure and share information about light pollution. Such extension involves the following use cases (more details can be found in ETSI TR 103 411 [[i.1]](#[i.1])):

- Use case 1: Monitor light pollution in a city, through the data collected by photometers about the magnitude of the light emitted in a given area.
- Use case 2: Adjust lampposts light intensity due to high pollution, after identifying the most contaminating lampposts and therefore the areas where more energy is being thrown away.
- Use case 3: Register a photometer, in which a new collection of photometers is incorporated into an existing sensor network.
