<div class="alert-warning">NOTE: The text in this section is extracted from ETSI TS 103 410-1 (V2.1.1) <a href="#[0]">[0]</a>, and therefore falls inside the <a href="https://www.etsi.org/intellectual-property-rights">ETSI IPR Policy</a></div>


### <a id="4.2.1"></a>General Overview

The main addition that SAREF4ENER provides on top of SAREF Core is a set of [saref:Profiles](https://saref.etsi.org/core/Profiles) that describe the energy flexibility capabilities of a device (see clause 4.2.3). These profiles are defined according to the SPINE/SPINE IoT [[6]](#[6]) and the S2 [[8]](#[8]) data models, with some profiles occurring in both [[6]](#[6]) and [[8]](#[8]), while some other profiles occurring either in [[6]](#[6]) or [[8]](#[8]). For example, the Power Profile flexibility type is described in both S2 and SPINE/IoT, thus is merged into a single representation in SAREF4ENER (see clause 4.2.3.1). The Power Envelope defined in S2 and Power Limits defined in SPINE also present similarities which are therefore specified in SAREF4ENER using several shared concepts (see clause 4.2.3.6). The remaining types of flexibility are unique to either S2 or SPINE, namely, Incentive Tables are defined only in SPINE, whereas Operation Mode, Fill Rate Based, and Demand Driven energy flexibility are control types defined only in S2 [[i.5]](#[i.5]).

The SAREF4ENER extension additionally describes flexibility instructions (see clause 4.2.5) separately from the flexibility profiles. These instructions describe the communication taking place between a device and the EMS to decide on the energy flexibility plan, such as offers from the device and requests from an EMS. A real-time check on the monitoring of power consumption is facilitated via the reuse of the main SAREF module and the load control use case (see clause 4.2.4). Finally, the SAREF4ENER extension provides a modelling approach for data points and time series (see clause 4.2.6), which is necessary for modelling the various forecasts and data elements involved.

An overview of the SAREF4ENER (V2.1.1) ontology is provided in [Figure 1](#Figure_1). In the image, classes are represented as rectangles. Relationships (object properties) between entities are represented as arrows. Arrows are additionally used to represent some RDF, RDF-S and OWL constructs, more precisely: plain arrows with white triangles represent the [rdfs:subClassOf](http://www.w3.org/2000/01/rdf-schema#subClassOf) relation between two classes. The origin of the arrow shall be considered as the subclass of the entity at the destination of the arrow. Dashed arrows accompanied by the expression [rdf:type](http://www.w3.org/1999/02/22-rdf-syntax-ns#type) are used to indicate that the individual at the origin of the arrow is an instance of the class placed at the end of the arrow. Datatype properties and class restrictions are presented as plain text and positioned within the boxes of the rectangles. The green colour is used to distinguish SAREF core entities. The blue colour is used for highlighting the classes and properties already existing in the previous version of SAREF4ENER (V1.1.2). The white colour is used to denote the classes and properties that have been added in the SAREF4ENER version specified in [the technical specification ETSI TS 103 410-1](#[0]) (V2.1.1). Note that [Figure 1](#Figure_1) aims at showing a global overview of the main classes of SAREF4ENER and their mutual relations. More details on the different parts of [Figure 1](#Figure_1) are provided in the rest of [the technical specification ETSI TS 103 410-1](#[0]) .


<figure>
    <img src="diagrams/image2.png" alt="SAREF4ENER overview"/>
    <figcaption id="Figure_1">Figure 1: SAREF4ENER overview</figcaption>
</figure>


### <a id="4.2.2"></a>Device

This extension adds several properties to the existing [saref:Device](https://saref.etsi.org/core/Device) which may be used to describe additional device details to the basic properties already defined in SAREF core. 




### <a id="4.2.3"></a>Flexibility Profile


#### <a id="4.2.3.0"></a>Foreword

The SAREF4ENER extension defines different energy flexibility profiles that can be offered by a [saref:Device](https://saref.etsi.org/core/Device). They are: [s4ener:PowerProfile](#s4ener:PowerProfile), [s4ener:PowerLimitProfile](#s4ener:PowerLimitProfile), [s4ener:DemandDrivenProfile](#s4ener:DemandDrivenProfile), [s4ener:OperationModeProfile](#s4ener:OperationModeProfile), [s4ener:FillRateBasedProfile](#s4ener:FillRateBasedProfile), [s4ener:IncentiveTableBasedProfile](#s4ener:IncentiveTableBasedProfile), and [s4ener:PowerEnvelopeProfile](#s4ener:PowerEnvelopeProfile). They are all subclasses of [s4ener:FlexibilityProfile](#s4ener:FlexibilityProfile) which is in turn a subclass of [saref:Profile](https://saref.etsi.org/core/Profile). 


<figure>
    <img src="diagrams/image3.png" alt="SAREF4ENER Flexibility Profiles"/>
    <figcaption id="Figure_2">Figure 2: SAREF4ENER Flexibility Profiles</figcaption>
</figure>


#### <a id="4.2.3.1"></a>Power Profile 

A [s4ener:PowerProfile](#s4ener:PowerProfile) describes the power usage of a particular task of a device that can be known or predicted beforehand, such as in the case of white goods like a washing machine. The [s4ener:PowerProfile](#s4ener:PowerProfile) is used by a [saref:Device](https://saref.etsi.org/core/Device) to expose the power sequences that are potentially relevant for the energy manager. A [saref:Device](https://saref.etsi.org/core/Device) can expose a [s4ener:PowerProfile](#s4ener:PowerProfile), which consists of one or more alternative plans ([s4ener:AlternativesGroup](#s4ener:AlternativesGroup) class). A [s4ener:AlternativesGroup](#s4ener:AlternativesGroup) consists of one or more power sequences ([s4ener:PowerSequence](#s4ener:PowerSequence) class), and a [s4ener:PowerSequence](#s4ener:PowerSequence) consists of one or more slots ([s4ener:Slot](#s4ener:Slot) class). Inversely, a [s4ener:Slot](#s4ener:Slot) belongs to only and exactly one [s4ener:PowerSequence](#s4ener:PowerSequence), which, in turn, belongs to only and exactly one [s4ener:AlternativesGroup](#s4ener:AlternativesGroup), which, in turn, belongs to only and exactly one [s4ener:PowerProfile](#s4ener:PowerProfile). A [s4ener:PowerProfile](#s4ener:PowerProfile) belongs to only and exactly one [saref:Device](https://saref.etsi.org/core/Device). 

The [s4ener:AlternativesGroup](#s4ener:AlternativesGroup) consists of one or more power sequences ([s4ener:PowerSequence](#s4ener:PowerSequence)) and, inversely, a [s4ener:PowerSequence](#s4ener:PowerSequence) belongs to only and exactly one [s4ener:AlternativesGroup](#s4ener:AlternativesGroup). The [s4ener:PowerSequence](#s4ener:PowerSequence) consists of one or more slots ([s4ener:Slot](#s4ener:Slot)) and, inversely, a [s4ener:Slot](#s4ener:Slot) belongs to only and exactly one [s4ener:PowerSequence](#s4ener:PowerSequence). 


<figure>
    <img src="diagrams/image4.png" alt="Power Profile Overview"/>
    <figcaption id="Figure_3">Figure 3: Power Profile Overview</figcaption>
</figure>


<figure>
    <img src="diagrams/image5.png" alt="Power Profile and Power Sequence"/>
    <figcaption id="Figure_4">Figure 4: Power Profile and Power Sequence</figcaption>
</figure>








#### <a id="4.2.3.2"></a>Demand Driven Profile

The [s4ener:DemandDrivenProfile](#s4ener:DemandDrivenProfile) can be used for devices that can consume different types of energy resources such as electricity or natural gas, but that lack a way of buffering that energy. This may for example be a hybrid heat pump that is powered using either electricity of gas. The power demand is determined by the device, but the customer energy manager can choose how to generate that power.

The profile contains a set of [saref:Actuators](https://saref.etsi.org/core/Actuators) that describe the various ways that the demanded energy can be provided. These actuators may be (part of) the actual [saref:Device](https://saref.etsi.org/core/Device) that offers this profile. The forecast of the average demand rate (i.e. the amount of energy, heat, and any other resource that needs to be produced by a device in the near future) can be expressed by defining time series ([s4ener:TimeSeries](#s4ener:TimeSeries)). 

 

<figure>
    <img src="diagrams/image6.png" alt="Demand Driven Profile"/>
    <figcaption id="Figure_5">Figure 5: Demand Driven Profile</figcaption>
</figure>








#### <a id="4.2.3.3"></a>Fill Rate Based Profile

The [s4ener:FillRateBasedProfile](#s4ener:FillRateBasedProfile) can be used for devices that can store energy ([s4ener:Storage](#s4ener:Storage)), such as heat pumps with a buffer, EVs, batteries, and even fridges and freezers. The [saref:Actuators](https://saref.etsi.org/core/Actuators) associated with this fill rate based profile can consume energy to fill the buffer. The information regarding the leakage behaviour of the storage and its fill level (i.e. a measure expressing how full the storage is) can respectively be defined through the classes [s4ener:LeakageBehaviour](#s4ener:LeakageBehaviour) and [saref:Observation](https://saref.etsi.org/core/Observation) via the properties [s4ener:hasLeakageBehaviour](#s4ener:hasLeakageBehaviour) and [s4ener:presentFillLevel](#s4ener:presentFillLevel), respectively. The [s4ener:LeakageBehaviour](#s4ener:LeakageBehaviour) is always associated with an element detailing the leakage behaviour of the storage ([s4ener:LeakageBehaviourElement](#s4ener:LeakageBehaviourElement)). Ultimately, certain storage devices might have a fill-level target profile ([s4ener:FillLevelTargetProfile](#s4ener:FillLevelTargetProfile)) with its associated [s4ener:FillLevelTargetProfileElement](#s4ener:FillLevelTargetProfileElement). 


<figure>
    <img src="diagrams/image7.png" alt="Fill Rate Based Profile"/>
    <figcaption id="Figure_6">Figure 6: Fill Rate Based Profile</figcaption>
</figure>


#### <a id="4.2.3.4"></a>Incentive Table Based Profile

The [s4ener:IncentiveTableBasedProfile](#s4ener:IncentiveTableBasedProfile) can be used to describe an incentive table, compiled of incentive table slots ([s4ener:IncentiveTableSlot](#s4ener:IncentiveTableSlot)) as well as a power plan ([s4ener:PowerPlan](#s4ener:PowerPlan)). Both are used to negotiate the allocation of upcoming energy usage of a device between the energy manager and the device. The incentive table is used by the energy manager to express the availability of energy via real and/or artificial incentives or costs over time. The device itself uses the table to negotiate the own demand and request the allocation by sending the resulting power plan to the energy manager.

Incentive types can be expressed in the form of relative costs ([s4ener:RelativeCost](#s4ener:RelativeCost)), absolute costs ([s4ener:AbsoluteCost](#s4ener:AbsoluteCost)), CO2 emissions ([s4ener:CO2Emission](#s4ener:CO2Emission)), and renewable energy percentage ([s4ener:RenewableEnergyPercentage](#s4ener:RenewableEnergyPercentage)). An incentive table also defines a scope type ([s4ener:ScopeType](#s4ener:ScopeType)) to indicate whether it is a preliminary ([s4ener:Preliminary](#s4ener:Preliminary)) or committed version ([s4ener:Committed](#s4ener:Committed)).

An incentive table consists of a number of slots ([s4ener:IncentiveTableSlot](#s4ener:IncentiveTableSlot)) where each slot may contain a series of incentives ([s4ener:Incentive](#s4ener:Incentive)) representing various tiers ([s4ener:Tier](#s4ener:Tier)). Each tier may be linked to a particular energy source, such as the grid, solar panels, or surplus power. Each incentive describes the cost, expressed as a unit applicable to the [s4ener:IncentiveType](#s4ener:IncentiveType), for that power source in the particular (time) slot. The lower and optional upper boundary ([s4ener:DataPoint](#s4ener:DataPoint)) describe for each incentive at which level of power consumption it becomes applicable.

The power plan of a device is defined by a series of sets of data points ([s4ener:TimeSeries](#s4ener:TimeSeries)). Each set of data points contains a time interval (time:Interval), a relation to a property ([s4ener:Power](#s4ener:Power)), a binding to a minimum ([s4ener:Minimum](#s4ener:Minimum)), average ([s4ener:Average](#s4ener:Average)) or maximum ([s4ener:Maximum](#s4ener:Maximum)) value and the value itself ([saref:Observation](https://saref.etsi.org/core/Observation)). Finally, it also contains a scope type ([s4ener:ScopeType](#s4ener:ScopeType)) to indicate whether it is a preliminary ([s4ener:Preliminary](#s4ener:Preliminary)) or committed value ([s4ener:Committed](#s4ener:Committed)).

An incentive table based profile can be used with any type of device. 


<figure>
    <img src="diagrams/image8.png" alt="Incentive Table Based Profile"/>
    <figcaption id="Figure_7">Figure 7: Incentive Table Based Profile</figcaption>
</figure>


<figure>
    <img src="diagrams/image9.png" alt="Power Plan associated with an Incentive Table"/>
    <figcaption id="Figure_8">Figure 8: Power Plan associated with an Incentive Table</figcaption>
</figure>










#### <a id="4.2.3.5"></a>Operation Mode Profile

Devices that offer the [s4ener:operationModeProfile](#s4ener:operationModeProfile) can control the amount of power that they generate and/or consume, such as diesel generators and variable electrical resistors. The states in which devices fall in, such as "running at reduced power" or "running at full power", can be described as operation modes ([s4ener:OperationMode](#s4ener:OperationMode)). These operation modes have therefore been modelled as subclasses of [saref:State](https://saref.etsi.org/core/State). Transitions between operation modes can be defined as [s4ener:Transition](#s4ener:Transition) with associated timers ([s4ener:Timer](#s4ener:Timer)) that specify the minimum duration of a particular operation model. 


<figure>
    <img src="diagrams/image10.png" alt="Operation Mode Profile"/>
    <figcaption id="Figure_9">Figure 9: Operation Mode Profile</figcaption>
</figure>










#### <a id="4.2.3.6"></a>Power Limitation 


##### <a id="4.2.3.6.1"></a>Power Envelope Profile

A [saref:Device](https://saref.etsi.org/core/Device) offers a [s4ener:PowerEnvelopeBasedProfile](#s4ener:PowerEnvelopeBasedProfile) when the device is operating within a minimum and maximum amount of power for energy production and/or consumption per time block, but the production or consumption cannot be directly regulated by the energy manager. A PV panels inverter is a typical example, because the energy produced is dependent on the amount of sunshine. The EMS may constrain the power production of the PV panels below its potential to lower a peak. 

The minimum and maximum amount of power that can be generated and/or spent by a device in a certain timespan can be set by instantiating the [s4ener:PowerEnvelope](#s4ener:PowerEnvelope) and its corresponding [s4ener:PowerConstraint](#s4ener:PowerConstraint). Power constraints are always bound to the allowed power limit ranges of a device ([s4ener:AllowedLimitRange](#s4ener:AllowedLimitRange)). The energy level of the [s4ener:PowerEnvelope](#s4ener:PowerEnvelope) can be defined by using [s4ener:TimeSeries](#s4ener:TimeSeries). The type of the allowed limit ranges of a device (i.e. upper limit or lower limit) can be defined through the class [s4ener:PowerEnvelopeLimitType](#s4ener:PowerEnvelopeLimitType). Commodity quantities relating to [s4ener:PowerEnvelope](#s4ener:PowerEnvelope) can be described through the class [s4ener:CommodityQuantity](#s4ener:CommodityQuantity). 


<figure>
    <img src="diagrams/image11.png" alt="Power Envelope Profile"/>
    <figcaption id="Figure_10">Figure 10: Power Envelope Profile</figcaption>
</figure>












##### <a id="4.2.3.6.2"></a>Power Limit Profile

SAREF4ENER further specifies allowed limit ranges through the classes [s4ener:ContractualPowerLimit](#s4ener:ContractualPowerLimit), [s4ener:NominalPowerLimit](#s4ener:NominalPowerLimit), and [s4ener:FailsafePowerLimit](#s4ener:FailsafePowerLimit). They are all subclasses of [s4ener:PowerLimit](#s4ener:PowerLimit) which is the general upper-class of power limits. Power limits can be toggled active or inactive via the [s4ener:isActive](#s4ener:isActive) property. A device has nominal power consumption and/or production values ([s4ener:NominalPowerLimit](#s4ener:NominalPowerLimit)) when the manufacturers define quantifiable and measurable limits that has not to be exceeded. The failsafe values provided by the manufacturers has to be given as instances of [saref:Observation](https://saref.etsi.org/core/Observation). In case the communication between a device and the energy manager is interrupted, the device enters a fail-safe state ([s4ener:FailsafeState](#s4ener:FailsafeState)). Fail-safe values ([s4ener:FailsafePowerLimit](#s4ener:FailsafePowerLimit)) apply until the communication is reestablished, with an optional minimal duration of the fail-safe state given in the [s4ener:hasFailsafeDuration](#s4ener:hasFailsafeDuration). Ultimately, a [saref:Device](https://saref.etsi.org/core/Device) is always bound to a [s4ener:ContractualPowerLimit](#s4ener:ContractualPowerLimit) (which is defined in a specification by the manufacturers) and limited by a [s4ener:FailsafePowerLimit](#s4ener:FailsafePowerLimit). 


<figure>
    <img src="diagrams/image12.png" alt="Power Limit Profile"/>
    <figcaption id="Figure_11">Figure 11: Power Limit Profile</figcaption>
</figure>



### <a id="4.2.4"></a>Load control 

This clause presents the part of SAREF4ENER that defines how to model events used in, for example, a direct load management or power curtailing scenario (e.g. use case 3 in clause 4.1). The classes of interest are [s4ener:LoadControlEventData](#s4ener:LoadControlEventData), [s4ener:LoadControlEventAction](#s4ener:LoadControlEventAction), [s4ener:LoadControlStateData](#s4ener:LoadControlStateData) and [s4ener:LoadControlState](#s4ener:LoadControlState). 


<figure>
    <img src="diagrams/image13.png" alt="Load Control "/>
    <figcaption id="Figure_12">Figure 12: Load Control </figcaption>
</figure>

The [s4ener:LoadControlEventData](#s4ener:LoadControlEventData) class is used to represent overload warning severity level and related load control commands to a device. It is characterized by an event ID and a timestamp that represents the time the event information instance was created or received, and the time period that denotes the period of validity of the event. For example, 5 minutes ago an event was received which says that it shall take effect tomorrow from 14:00 to 15:30. In this event the timestamp is "5 minutes ago" and time period is "tomorrow from 14:00 to 15:30".

The [s4ener:LoadControlEventAction](#s4ener:LoadControlEventAction) class expresses the type of actions to be performed as a consequence of a load control event. A [s4ener:LoadControlEventAction](#s4ener:LoadControlEventAction) can be of type "consume" or "produce" to denote consumption or production of energy or power. Values for both consume and produce actions can be [s4ener:emergency](#s4ener:emergency), [s4ener:increase](#s4ener:increase), [s4ener:normal](#s4ener:normal), [s4ener:pause](#s4ener:pause), [s4ener:reduce](#s4ener:reduce), [s4ener:resume](#s4ener:resume). 

The [s4ener:LoadControlStateData](#s4ener:LoadControlStateData) class expresses the data about the state of an event and is characterized by the same event ID used in the [s4ener:LoadControlEventData](#s4ener:LoadControlEventData) class, as well as a timestamp, and it is associated to the class [s4ener:LoadControlState](#s4ener:LoadControlState), which can be of type "consume" or "produce" - analogously to a load control event action - and expresses the possible states of a load control event. Values for both consume and produce load control states can be [s4ener:eventAccepted](#s4ener:eventAccepted), [s4ener:eventStarted](#s4ener:eventStarted), [s4ener:eventStopped](#s4ener:eventStopped), [s4ener:eventRejected](#s4ener:eventRejected), [s4ener:eventCancelled](#s4ener:eventCancelled), or [s4ener:eventError](#s4ener:eventError).


### <a id="4.2.5"></a>Flexibility Communication


#### <a id="4.2.5.1"></a>Flexibility Request 

This clause presents how flexibility requests can be modelled in SAREF4ENER (e.g. use case 7 in clause 4.1). This message can be sent by an EMS to a device to inquire for the flexibility it can offer. A flexibility requests can be defined by using the [s4ener:FlexRequest](#s4ener:FlexRequest) class. Flexibility requests can include a [s4ener:IncentiveTable](#s4ener:IncentiveTable), [s4ener:FlexibilityProfile](#s4ener:FlexibilityProfile), [s4ener:TimeSeries](#s4ener:TimeSeries) and [s4ener:Datapoint](#s4ener:Datapoint). An [s4ener:FlexRequest](#s4ener:FlexRequest) can be produced by an agent ([foaf:Agent](http://xmlns.com/foaf/spec/#Agent)) or device ([saref:Device](https://saref.etsi.org/core/Device)) and be sent to either an agent or device. An [s4ener:FlexRequest](#s4ener:FlexRequest) always has an effective period and a creation time expressed through the Time ontology. 


<figure>
    <img src="diagrams/image14.png" alt="Flexibility Request"/>
    <figcaption id="Figure_13">Figure 13: Flexibility Request</figcaption>
</figure>




#### <a id="4.2.5.2"></a>Flexibility Offer

This clause presents how flexibility offers can be modelled in SAREF4ENER (e.g. use case 7 in clause 4.1). This message can be sent by a device to the EMS as a response to a Flexibility Request, indicating the device's flexibility potential. Flexibility offers can be defined by using [s4ener:FlexOffer](#s4ener:FlexOffer). Flexibility offers can include a [s4ener:IncentiveTable](#s4ener:IncentiveTable), [s4ener:FlexibilityProfile](#s4ener:FlexibilityProfile), [s4ener:TimeSeries](#s4ener:TimeSeries) and [s4ener:Datapoint](#s4ener:Datapoint). A [s4ener:FlexOffer](#s4ener:FlexOffer) can be produced by an agent ([foaf:Agent](http://xmlns.com/foaf/spec/#Agent)) or device ([saref:Device](https://saref.etsi.org/core/Device)) and it can be sent to either an agent or device. Flexibility offers relate to flexibility requests ([s4ener:FlexRequest](#s4ener:FlexRequest)). A [s4ener:FlexOffer](#s4ener:FlexOffer) always has an effective period and a creation time expressed through the Time ontology.


<figure>
    <img src="diagrams/image15.png" alt="Flexibility Offer"/>
    <figcaption id="Figure_14">Figure 14: Flexibility Offer</figcaption>
</figure>




#### <a id="4.2.5.3"></a>Flexibility Instruction

This clause presents how a flexibility instruction can be modelled in SAREF4ENER (e.g. use case 7 in clause 4.1). This class describes the instruction that an EMS sends to a device about how it should operate according to the EMS optimization plan. Flexibility instruction can be defined by using [s4ener:FlexibilityInstruction](#s4ener:FlexibilityInstruction). Flexibility instructions have an activation plan expressed in time-series ([s4ener:TimeSeries](#s4ener:TimeSeries)) and a cost defined as a datapoint ([s4ener:DataPoint](#s4ener:DataPoint)). A [s4ener:FlexInstruction](#s4ener:FlexInstruction) can have an execution time, period of validity, instructionID defined as datatype values. The operation mode factor and the presence of abnormal condition can be specified through the datatype properties [s4ener:abnormalConditionOnly](#s4ener:abnormalConditionOnly) and [s4ener:operationModeFactor](#s4ener:operationModeFactor). Flexibility instructions relate to flexibility requests ([s4ener:FlexRequest](#s4ener:FlexRequest)). An [s4ener:Flexinstruction](#s4ener:Flexinstruction) can be produced by an agent ([foaf:Agent](http://xmlns.com/foaf/spec/#Agent)) or device ([saref:Device](https://saref.etsi.org/core/Device)) and be sent to either an agent or device. An [s4ener:FlexInstruction](#s4ener:FlexInstruction) always has an effective period and a creation time expressed through the Time ontology. 


<figure>
    <img src="diagrams/image16.png" alt="Flexibility Instruction"/>
    <figcaption id="Figure_15">Figure 15: Flexibility Instruction</figcaption>
</figure>




### <a id="4.2.6"></a>Data Points and Time Series

The [s4ener:DataPoint](#s4ener:DataPoint) is an atomic piece of information about a certain observable quantity in nature that can contain a numerical value and a corresponding unit of measure [[i.7]](#[i.7]). An [s4ener:TimeSeries](#s4ener:TimeSeries) is related to the [s4ener:Datapoint](#s4ener:Datapoint) class via the [s4ener:hasDataPoint](#s4ener:hasDataPoint) property and is defined as an ordered sequence of data-points of a quantity that is observed at spaced (not necessarily equally spaced) time intervals.

The [s4ener:DataPoint](#s4ener:DataPoint) is defined as a subclass of [saref:Observation](https://saref.etsi.org/core/Observation) and, as such, inherits the [saref:hasResult](https://saref.etsi.org/core/hasResult) and [saref:hasTimestamp](https://saref.etsi.org/core/hasTimestamp) properties. Therefore, if the combination of a result and timestamp is sufficient to represent a datapoint, then the SAREF concepts for observation can be directly reused. However, it can be noticed that often, especially when representing timeseries of datapoints in a forecast, a number of additional properties are needed.


<figure>
    <img src="diagrams/image17.png" alt="Time Series and Data Point"/>
    <figcaption id="Figure_16">Figure 16: Time Series and Data Point</figcaption>
</figure>






