<div class="alert-warning">NOTE: The text in this section is extracted from ETSI TS 103 410-1 (V2.1.1) <a href="#[0]">[0]</a>, and therefore falls inside the <a href="https://www.etsi.org/intellectual-property-rights">ETSI IPR Policy</a></div>


[The technical specification ETSI TS 103 410-1](#[0]) is a technical specification of SAREF4ENER, an OWL-DL ontology that extends SAREF [[1]](#[1]) for the energy domain. 

[The technical specification ETSI TS 103 410-1](#[0]) was created based on the CENELEC standards EN 50631:2023, parts 1 [[4]](#[4]), 2 [[5]](#[5]), 3-1 [[6]](#[6]) and 41 [[7]](#[7]), and EN 50491122 [[8]](#[8]), in collaboration with the Horizon 2020 project Interconnect [[i.8]](#[i.8]), and with industry associations such as EEBUS(<a href="http://www.eebus.org/">http://www.eebus.org/</a>), Energy@Home and the S2 consortium (<a href="https://s2standard.org/">https://s2standard.org/#consortium</a>), which includes KNX (<a href="https://www.knx.org/">https://www.knx.org/</a>) and the Flexible power Alliance Network (FAN, <a href="https://flexible-energy.eu/">https://flexible-energy.eu/</a>). 

The EN 50631  "Household appliances network and grid connectivity" series, produced by the CENELEC/Technical Committee (CLC/TC) 59X on "Performance of household and similar electrical appliances", defines the information exchange between smart appliances and management systems in homes and buildings including energy management. Part 1 of the standard (EN 50631-1 [[4]](#[4])) defines the data models for interoperable connected household appliances that are derived from a logical decomposition of use cases into functional blocks. Part 2 (EN 50631-2 [[5]](#[5])) maps the generic use cases, use case functions, and generic data definitions to categories of appliances (e.g. washer, dishwasher, water heater, HVAC devices). Part 3-1 (EN 50631-3-1 [[6]](#[6])) maps the generic use case functions and data models defined in Part 1 to specific languages such as SPINE and SPINE-IoT. Part 4-1 (EN 50631-4-1 [[7]](#[7])) defines the Communication Protocol Specific Aspects in terms of SPINE, SPINE-IoT and Smart Home IP (SHIP). 

<div class="alert-info">NOTE 1: SPINE and SPINE-IoT are used by manufacturers from the EEBUS association.</div>

<div class="alert-info">NOTE 2: Since it is based on mappings to the SPINE language and protocol, EN 50631:2023, parts 3-1 <a href="#[6]">[6]</a> and 41  <a href="#[7]">[7]</a>, is often referred to directly as "SPINE". The EEBUS SPINE specification used in EN 50631 is available free of charge at <a href="https://www.eebus.org/media-downloads/">https://www.eebus.org/media-downloads/</a>. </div>


The EN 50491 "General requirements for Home and Building Electronic Systems (HBES) and Building Automation and Control Systems (BACS)" standard is produced by the CLC/TC 205 on HBES. EN 50491122 [[8]](#[8]) specifies the fundamental aspects of interoperability for the S2 interface and the related data exchange between a CEM and the Resource Managers within the home and building premises. It defines a communication standard for energy flexibility and energy management, which helps to optimize the use of energy of smart devices in homes and buildings. Energy flexibility, which can be offered by (a combination of), for example, PV systems, EV chargers, batteries, and (hybrid) heat pumps, is the ability to alter the use of energy without a significant impact on the user's comfort. Energy flexibility plays an important role in the digital energy transition. 

<div class="alert-info">NOTE 3: S2 is the customer interface between the CEM in the home/building premises and the Resource Manager(s), as defined in the European Smart Grid Architecture developed in Mandate 490 of the European Commission <a href="#[i.2]">[i.2]</a>. Therefore, EN 50491-12-2 <a href="#[8]">[8]</a>, which defines the S2 interface, is often called the "S2 standard". </div>

<div class="alert-info">NOTE 4: The S2 standard is endorsed by the KNX and FAN industry associations. Concerning its usage, the S2 standard has been recently published (2022) and it is gaining momentum in the industry among heat pump manufactures. </div>

<div class="alert-info">NOTE 5: Additional information about the S2 standard is available at <a href="https://s2standard.org/">https://s2standard.org/</a>, including a white paper <a href="#[i.5]">[i.5]</a> and an S2 implementation in JSON <a href="#[i.6]">[i.6]</a>. </div>


The SAREF4ENER extension should be used to annotate (or generate) a neutral (protocol-independent) set of messages, for example by energy smart appliances manufacturers, to exchange information at the home/buildings premises among smart appliances, their Resource Manager (RM) and a Customer Energy Manager (CEM) to efficiently optimize energy consumption and production within the constraints set by the user. 

<div class="alert-info">NOTE 6: An alternative term used for CEM is Energy Management System (EMS).</div>

<div class="alert-info">NOTE 7: SAREF4ENER, together with SAREF core, have been adopted as common semantic model in the Code of Conduct (CoC) for Energy Smart Appliances (ESA) manufactures <a href="#[i.9]">[i.9]</a> promoted by the European Commission <a href="#[i.8]">[i.8]</a> (EC). The CoC has the goal to increase the number of interoperable ESA that are placed on the European Union market. The current CoC V1.0 has been officially launched by the EC in April 2024 and 10 manufacturers producing appliances have signed this first version, namely Arçelik, Clivet, Daikin, Electrolux, Miele, Mitsubishi Electric, Panasonic, Vaillant Group, Vestel and Viessmann. The manufacturers have committed to develop interoperable connected products within a year. In addition, a Home Energy Management System manufacturer, GEO, has committed to support compliant ESA through their products. This first CoC version includes examples of mappings from EN 50631 (SPINE) to SAREF4ENER V1.2.1. Future releases of the CoC intend to include also examples of mappings from EN 50491-12-2 <a href="#[8]">[8]</a> (S2) to SAREF4ENER. SAREF4ENER V1.1.1 was primarily based on the power profiles as defined in EN 50631:2023 parts 1 <a href="#[4]">[4]</a>, 2 <a href="#[5]">[5]</a>, 3-1 <a href="#[6]">[6]</a> and 4-1 <a href="#[7]">[7]</a> (SPINE). The subsequent version, SAREF4ENER V1.2.1, added new SPINE concepts not previously covered and introduced the most important concepts from EN 50491122 <a href="#[8]">[8]</a> (S2), with the explicit goal of harmonizing and providing interoperability between the SPINE and S2 standards. In the meantime, a new version of SAREF core, V4.1.1, was released. Therefore, <a href="#[0]">the technical specification ETSI TS 103 410-1</a>, SAREF4ENER V2.1.1, aligns to the latest SAREF core release 4.1.1, yet preserving the important changes made in SAREF4ENER V1.2.1. The history of the main changes in SAREF4ENER can be found in Annex D. </div>

The application of SAREF4ENER focuses on demand response scenarios, in which customers can offer energy flexibility to the Smart Home and Smart Grid. Energy smart devices and energy managers communicate with each other to achieve the best possible result. Energy smart devices can express their demand/production and flexibility, energy managers are responsible to find the most optimal measure between energy consumption and energy production of energy smart devices based on the customer's chosen configuration and the characteristics of the devices. Next to selfconsumption optimization, the Smart Grid can influence the quantity or patterns of use of the energy consumed by customers when grid-energy-supply systems are constrained, e.g. during peak hours.

This can be realized by connecting a smart home device with an Energy Management System (EMS) (see EN 50631:2023, parts 1 [[4]](#[4]), 2 [[5]](#[5]), 3-1 [[6]](#[6]) and 4-1 [[7]](#[7])) or by means of a Resource Manager (RM) (see EN 50491122 [[8]](#[8])).These scenarios involve (but are not limited to) the following use cases. The SAREF4ENER parts applicable per use case are primarily decided by the types of devices that are involved:

* **Use case 1**: flexible start of smart appliances. Smart energy management should be able to (re-)schedule appliances in certain modes and preferred times using power profiles to optimize energy efficiency and accommodate the customer's preferences. The user should be able to decide on a preferred interval within which the energy manager computes the starting time that optimizes the energy usage. Interruption options, such as pausing a task, can further optimize the energy usage. 
* **Use case 2**: monitoring and control of the start, status, and power consumption of the appliances. It is essential for an energy manager to be aware of the power consumption of all devices it optimizes for, including devices that are not smart.
* **Use case 3**: reaction to special requests from the Smart Grid, for example, incentives to consume more or less depending on current energy availability, or emergency situations that require temporary reduction of the power consumption.
* **Use case 4**: limitation of power consumption. This use case covers power limits that are sent by the energy manager, as well as power limits set by the manufacturer in the case of a lost connection (fail-safe limits), as well as contractual and nominal power limits.
* **Use case 5**: incentive table. This use case aims to influence the energy usage via a set of incentives that the energy consumer and energy manager negotiate about.
* **Use case 6**: description of the energy flexibility capabilities of any type of device in a (smart) home/building in the information exchange of such devices with resource and energy managers. Energy flexibility, which can be offered by (a combination of), for example, PV systems, EV chargers, batteries, and (hybrid) heat pumps, is the ability to alter the use of energy without a significant impact on the user's comfort [[i.5]](#[i.5]). 
* **Use case 7**: Interoperable data exchange between a Distribution System Operator (DSO) and other market parties, such as services providers and flexibility aggregators to support: 
    1. network flexibility that can be used by network operators to manage the electricity grids more efficiently and to provide a potential additional revenue stream to the consumers without limiting their consumer behaviour patterns [[i.12]](#[i.12]); and 
    2. increased grid observability for home appliances that are mostly passive and not actively monitored, enabling a faster identification of potential outages and electricity quality issues [[i.12]](#[i.12]).

These use cases are associated with the user stories described in [[i.3]](#[i.3]), which include, among others, the following examples:

* User wants to do basic settings of his/her devices;
* User wants to know when the washing machine has finished working;
* User wants the washing done by 5:00 p.m. with least electrical power costs;
* User likes to limit his/her own energy consumption up to a defined limit;
* User allows the EMS to reduce the energy consumption of his/her freezer in a defined range for a specific time, if the grid recognizes (severe) stability issues;
* Grid related emergency situations (blackout prevention).

The prefixes and namespaces used in SAREF4ENER and in [the technical specification ETSI TS 103 410-1](#[0]) are listed in [the Namespace Declarations section](#namespacedeclarations).


