
## SAREF4BLDG


### General overview


Figure 1 presents an overview of the classes (only the top levels of the hierarchy) and the properties included in the SAREF4BLDG extension. As it can be observed the classes `s4bldg:Building`, `s4bldg:BuildingSpace` and `s4bldg:PhysicalObject` have been declared as subclasses of the class `geo:SpatialThing` in order to reuse the conceptualization for locations already proposed by the geo ontology. The modelling of building objects and building spaces has been adapted from the SAREF ontology; in this sense, the new classes deprecate the `saref:BuildingObject` and `saref:BuildingSpace` classes. In addition, a new class has been created, the `s4bldg:Building` class, to represent buildings.


The concepts `s4bldg:Building` and `s4bldg:BuildingSpace` are related to each other by means of the properties `s4bldg:hasSpace` and `s4bldg:isSpaceOf`; such properties are defined as inverse properties among them. These properties might also be used to declare that a `s4bldg:BuildingSpace` has other spaces belonging to the class `s4bldg:BuildingSpace`.


The relationship between building spaces and devices and building objects has also been transferred and generalized from the SAREF ontology. In this regard, a `s4bldg:BuildingSpace` can contain (represented by the property `s4bldg:contains`) individuals belonging to the class `s4bldg:PhysicalObject`. This generalization has been implemented in order to support building spaces to contain both building objects and devices. Accordingly, the classes `s4bldg:BuildingObject` and `saref:Device` are declared as subclasses of `s4bldg:PhysicalObject`.


Finally, the class representing building devices, namely `s4bldg:BuildingDevice`, is defined as a subclass of both `saref:Device` and `s4bldg:BuildingObject`. This class is a candidate for replacing the `saref:BuildingRelated` class.

<figure>
    <img data-docx-width="11.77cm" src="diagrams/Overview.png" alt="General overview of the top levels of the SAREF4BLDG extension"/>
    <figcaption>Figure 1: General overview of the top levels of the SAREF4BLDG extension</figcaption>
</figure>


Table 2 summarizes the restrictions that characterize a `s4bldg:BuildingSpace`. 

<table data-docx-preferred-width="7.69cm 8.48cm">
  <caption>Table 2: Restrictions of the s4bldg:BuildingSpace class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4bldg:contains <strong>only</strong> s4bldg:PhysicalObject</td>
    <td>A building space contains entities represented only by instances of s4bldg:PhysicalObject.</td>
  </tr>
  <tr>
    <td>s4bldg:hasSpace <strong>only</strong> s4bldg:BuildingSpace</td>
    <td>A building has spaces represented only by instances of s4bldg:BuildingSpace.</td>
  </tr>
  <tr>
    <td>s4bldg:isSpaceOf <strong>only</strong> (s4bldg:Building or s4bldg:BuildingSpace)</td>
    <td>A building is spaces of entities represented only by instances of the classes s4bldg:Building or s4bldg:BuildingSpace.</td>
  </tr>
</table>




Table 3 summarizes the restrictions that characterize a `s4bldg:PhysicalObject`. 

<table data-docx-preferred-width="7.69cm 8.48cm">
  <caption>Table 3: Restrictions of the s4bldg:PhysicalObject class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4bldg:contains <strong>only</strong> s4bldg:PhysicalObject</td>
    <td>A physical object contains entities represented only by instances of s4bldg:PhysicalObject.</td>
  </tr>
  <tr>
    <td>s4bldg:isContained <strong>only</strong> (s4bldg:Building or s4bldg:BuildingSpace)</td>
    <td>A physical object is contained in entities represented only by instances of the classes s4bldg:Building or s4bldg:BuildingSpace.</td>
  </tr>
</table>




### Device Taxonomy


The main contribution of this extension is the representation of the devices defined in the IFC standard and their connections to SAREF. In this sense, a hierarchy consisting in 62 classes has been created taking into account the subset of the IFC hierarchy related to devices, as defined in the buildingSMART documentation ([https://standards.buildingsmart.org/IFC/RELEASE/IFC4/ADD1/HTML/annex/annex-c/common-use-definitions/index.htm](https://standards.buildingsmart.org/IFC/RELEASE/IFC4/ADD1/HTML/annex/annex-c/common-use-definitions/index.htm)), and adding several classes to clarify its categorization. The device classes are organized into 6 hierarchical levels that, for the sake of clarity, will be displayed in Figure 2 and Figure 3. 


Figure 2 shows the first five levels of the hierarchy. Since transport elements (`s4bldg:TransportElement`) and vibration isolations (`s4bldg:VibrationIsolation`) are not classified under IFC elements, they belong directly to the class `s4bldg:Device`. The building elements are divided into `s4bldg:ShadingDevice` and `s4bldg:DistributionDevice`. In fact, most of the device types included in IFC belong to the distribution device category which contains the classes s`4bldg:DistributionControlDevice` and `s4bldg:DistributionFlowDevice`. The hierarchy under the `s4bldg:DistributionFlowDevice is` depicted in Figure 3.


As can be observed in Figure 2, some classes defined in SAREF4BLDG are also defined in the SAREF ontology. More precisely, this occurs in the classes `s4bldg:Actuator` and `s4bldg:Sensor` that extend the classes `saref:Actuator` and `saref:Sensor`, respectively. This decision has been taken because in the SAREF4BLDG extension these concepts refer to specific sensors and actuators that are placed in or related to buildings. 

<figure>
    <img data-docx-width="17.00cm" src="diagrams/Hierarchy1.png" alt="Device hierarchy in SAREF4BLDG (Part 1)"/>
    <figcaption>Figure 2: Device hierarchy in SAREF4BLDG (Part 1)</figcaption>
</figure>

<figure>
    <img data-docx-width="17.00cm" src="diagrams/Hierarchy2.png" alt="Device hierarchy in SAREF4BLDG (Part 2)"/>
    <figcaption>Figure 3: Device hierarchy in SAREF4BLDG (Part 2)</figcaption>
</figure>


For each class extracted from the IFC specification, `rdfs:label` and `rdfs:comment` annotations have been generated including the identifier and an excerpt of the definition provided in the IFC online documentation. In addition, provenance information has been included using the PROV-O ontology ([https://www.w3.org/TR/prov-o](https://www.w3.org/TR/prov-o/)/), which has been published by the W3C as recommendation. In our case, the property `prov:hadPrimarySource` is used to link each class with:


!!! indent-1 ""
    a)	the online document in IFC describing the concept; and 


!!! indent-1 ""
    b)	the online document in IFC describing the properties defined for such concept. 


It should be noted that properties are not specified in IFC for all the concepts but just for those representing particular devices. That is, there is no description of properties for the following general classes: 

<pre><code class="language-turtle">s4bldg:EnergyConversionDevice, s4bldg:FlowController, s4bldg:FlowMovingDevice, s4bldg:FlowStorageDevice, s4bldg:FlowTerminal, and s4bldg:FlowTreatmentDevice.</code></pre>

In addition, the classes created in this extension have been related to the ifcOWL ontology ([https://w3id.org/ifc/IFC4_ADD1](https://w3id.org/ifc/IFC4_ADD1)) when possible. This relation has been declared by means of the annotation property `rdfs:seeAlso` from the SAREF4BLDG classes to the ifcOWL ones. Listing 1 includes an excerpt of the ontology in the Turtle syntax that shows an example of a class including the annotations from the IFC specification, provenance references to the IFC class and property definition, and the mapping to the corresponding ifcOWL concept.

<figure>
    <pre><code class="language-turtle">### Class definition 
s4bldg:Compressor rdf:type owl:Class ;
	rdfs:label "Compressor"@en ;
	rdfs:subClassOf s4bldg:FlowMovingDevice ;
	rdfs:comment "A compressor is a device that compresses a fluid typically used in a refrigeration circuit."@en ; 
### Provenance information for class definition
	prov:hadPrimarySource &lt;http://www.buildingsmart-tech.org/ifc/IFC4/Add1/html/ schema/ifchvacdomain/lexical/ifccompressor.htm> ;
### Provenance information for class properties       
	prov:hadPrimarySource &lt;http://www.buildingsmart-tech.org/ifc/IFC4/Add1/html/ schema/ifchvacdomain/pset/pset_compressortypecommon.htm> ;
### Mapping to ifcOWL classes       
  rdfs:seeAlso &lt;https://w3id.org/ifc/IFC4_ADD1#IfcCompressor> .</code></pre>
    <figcaption>Listing 1: Class definition example including documentation, mappings and provenance information</figcaption>
</figure>


### Device Properties


In the SAREF4BLDG extension 177 instance of the class `saref:Property` and 77 datatype properties (82 defined in SAREF4EBLDG and 1 reused from the SAREF ontology) have been included. 172 out the 177 properties and 75 out of the 83 datatype properties have been created according to the IFC specification of properties for devices.


For each of the created object and datatype properties, their documentation from IFC has been attached as documentation, including information about their use, such as the expected units of measurement.


The naming of the created object and datatype properties is consistent with the naming used in IFC. More precisely, the names of the properties in the ontology are the names assigned in IFC transformed into Camel Case starting with lowercase. For example, the property "IdealShaftPower" (extracted from [https://standards.buildingsmart.org/IFC/RELEASE/IFC4/ADD1/HTML/schema/ifchvacdomain/pset/pset_compressortypecommon.htm](https://standards.buildingsmart.org/IFC/RELEASE/IFC4/ADD1/HTML/schema/ifchvacdomain/pset/pset_compressortypecommon.htm)) has been transformed into the object property `s4bldg:idealShaftPower`. 


Listing 2 includes an excerpt of the ontology in the Turtle syntax that shows an example of an object property and a datatype property including the annotations from the IFC specification.

<figure>
    <pre><code class="language-turtle">### Object property definition example
s4bldg:idealShaftPower rdf:type owl:ObjectProperty ;
  rdfs:comment "Compressor shaft power under ideal conditions. Usually measured in Watts (W, J/s)."@en ;
  rdfs:label "ideal shaft power"@en . 
### Datatype property definition example
s4bldg:hasHotGasBypass rdf:type owl:DatatypeProperty ;
  rdfs:range xsd:boolean ;
  rdfs:comment "Whether or not hot gas bypass is provided for the compressor. TRUE = Yes, FALSE = No."@en ;
  rdfs:label "has hot gas bypass"@en .</code></pre>
    <figcaption>Listing 2: Property definition example including documentation</figcaption>
</figure>


Table 5 shows the list of datatype properties extracted from IFC and the classes for which each property might be applied.

<table data-docx-preferred-width="8.16cm 6.16cm">
  <caption>Table 5: List of datatype properties extracted from IFC and 
the classes for which the properties are defined</caption>
  <tr>
    <th>Datatype properties</th>
    <th>Class(es)</th>
  </tr>
  <tr>
    <td>s4bldg:accessType</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:application</td>
    <td>s4bldg:Humidifier</td>
  </tr>
  <tr>
    <td>s4bldg:arrangement</td>
    <td>s4bldg:HeatExchanger</td>
  </tr>
  <tr>
    <td>s4bldg:bladeAction</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:bladeEdge</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:bladeShape</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:capacityControl</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:capacityControlType</td>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td>s4bldg:capacityPeople</td>
    <td>s4bldg:TransportElement</td>
  </tr>
  <tr>
    <td>s4bldg:circuitType</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:colorAppearance</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:colorRenderingIndex</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:controlStrategy</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:endShapeType</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td rowspan="4">s4bldg:energySource</td>
    <td>s4bldg:Burner</td>
  </tr>
  <tr>
    <td>s4bldg:Engine</td>
  </tr>
  <tr>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:evaporationCoolant</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:evaporationMediumType</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:failPosition</td>
    <td>s4bldg:Actuator</td>
  </tr>
  <tr>
    <td>s4bldg:finishColor</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:fireExit</td>
    <td>s4bldg:TransportElement</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:flowArrangement</td>
    <td>s4bldg:EvaporativeCooler</td>
  </tr>
  <tr>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:frameSize</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:frameType</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:hasDefrost</td>
    <td>s4bldg:AirToAirHeatRecovery</td>
  </tr>
  <tr>
    <td>s4bldg:hasExteriorInsulation</td>
    <td>s4bldg:DuctSilencer</td>
  </tr>
  <tr>
    <td>s4bldg:hasHotGasBypass</td>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:hasLock</td>
    <td>s4bldg:SwitchingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:hasPartWinding</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:hasTurbulator</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:heatTransferDimension</td>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:heatTransferMedium</td>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:heatTransferTypeEnum</td>
    <td>s4bldg:AirToAirHeatRecovery</td>
  </tr>
  <tr>
    <td>s4bldg:integratedLightingType</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:internalControl</td>
    <td>s4bldg:Humidifier</td>
  </tr>
  <tr>
    <td>s4bldg:isExternal</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:isFreeHanging</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:isGuarded</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:isIlluminated</td>
    <td>s4bldg:SwitchingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:isNeutralPrimaryTerminalAvailable</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:isNeutralSecondaryTerminalAvailable</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:isPluggableOutlet</td>
    <td>s4bldg:Outlet</td>
  </tr>
  <tr>
    <td>s4bldg:isWaterStorageHeater</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:lampBallastType</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:lampCompensationType</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:legend</td>
    <td>s4bldg:SwitchingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:manualOverride</td>
    <td>s4bldg:Actuator</td>
  </tr>
  <tr>
    <td>s4bldg:mechanicalOperated</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:mediaSource</td>
    <td>s4bldg:AudioVisualAppliance</td>
  </tr>
  <tr>
    <td>s4bldg:motorDriveType</td>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td>s4bldg:motorEnclosureType</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:operatingMode</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:operation</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:orientation</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:patternType</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:pipeConnectionEnum</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:placementType</td>
    <td>s4bldg:Coil</td>
  </tr>
  <tr>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:powerSource</td>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:readOutType</td>
    <td>s4bldg:FlowMeter</td>
  </tr>
  <tr>
    <td rowspan="3">s4bldg:refrigerantClass</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:Condenser</td>
  </tr>
  <tr>
    <td>s4bldg:remoteReading</td>
    <td>s4bldg:FlowMeter</td>
  </tr>
  <tr>
    <td>s4bldg:roughness</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:secondaryCurrentType</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:shadingDeviceType</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:shortCircuitVoltage</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:sprayType</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:standard</td>
    <td>s4bldg:ProtectiveDeviceTrippingUnit</td>
  </tr>
  <tr>
    <td>s4bldg:storageType</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:switchFunction</td>
    <td>s4bldg:SwitchingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:temperatureClassification</td>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:transformerVectorGroup</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:valveMechanism</td>
    <td>s4bldg:Valve</td>
  </tr>
  <tr>
    <td>s4bldg:valveOperation</td>
    <td>s4bldg:Valve</td>
  </tr>
  <tr>
    <td>s4bldg:valvePattern</td>
    <td>s4bldg:Valve</td>
  </tr>
  <tr>
    <td>s4bldg:waterFlowControlSystemType</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
</table>




As an example of a complete class definition including all its properties, Table 6 summarizes the restrictions that characterize a `s4bldg:Compressor`, using the properties extracted from IFC. The example contains different types of properties that are representative enough for the rest of the transformed classes. It should be noted that the full ontology documentation will be available online in HTML format, since including all the restrictions in the present document would make it unmanageable.

<table data-docx-preferred-width="7.69cm 8.48cm">
  <caption>Table 6: Restrictions of the s4bldg:Compressor class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4bldg:powerSource <strong>only</strong> xsd:string</td>
    <td>The power source of a compressor value is indicated only by xsd:string.</td>
  </tr>
  <tr>
    <td>s4bldg:refrigerantClass <strong>only</strong> xsd:string	</td>
    <td>The refrigeration class of a compressor value is indicated only by xsd:string.</td>
  </tr>
  <tr>
    <td>s4bldg:hasHotGasBypass <strong>only</strong> xsd:boolean</td>
    <td>Whether a compressor has a hot gas bypass is indicated only by values of xsd:boolean.</td>
  </tr>
</table>




## Discussions about SAREF4BLDG


In the following, several observations about potential uses of the SAREF4BLDG ontology are listed.


It should be mentioned that the range of the `s4bldg:shortCircuitVoltage` object property is open to different representations of complex numbers. In this sense, when reusing the ontology users should define the class to be used to represent complex numbers or reuse an existing one.


In addition, the list of building devices should not be considered exhaustive, the current classification represents those devices described in IFC. It might be needed to extend the hierarchy in the case of new devices related to buildings are described in new versions of IFC or are needed for a particular use case.


Furthermore, it is expected that concrete use cases will either reuse the existing classes to represent their devices or specialize some of these classes to cover specific device types (e.g. by creating a hierarchy of boiler devices under the `s4bldg:Boiler` class).
