
# SAREF4BLDG ontology and semantics


## Introduction


The present document is a technical specification of SAREF4BLDG, an extension of the SAREF ontology [1] that was created based on the Industry Foundation Classes (IFC) standard for building information. It should be noted that not the whole standard has been transformed since it exceeds the scope of this extension, which is limited to devices and appliances within the building domain. 


The present document is a major revision of SAREF4BLDG ontology extension, developed in the context of the STF 653 ([https://portal.etsi.org/xtfs/#/xTF/653](https://portal.etsi.org/xtfs/#/xTF/653/)/), using updated reference ontology patterns specified in ETSI TS 103 548 [2] to solve the harmonization needs identified in ETSI TR 103 781 [i.6], with updated development framework and tools defined in ETSI TS 103 673 [i.7].


ETSI TS 103 410-3 [i.5] has been developed in the context of the STF 513, an ETSI specialists task force that was established with the goal to deliver the SAREF Core V2 and to extend SAREF id for the domains of Environment, Buildings and Energy (see [https://portal.etsi.org/STF/STFs/STF-HomePages/STF513](https://portal.etsi.org/STF/STFs/STF-HomePages/STF513)). The IFC specification is developed and maintained by buildingSMART International as its "Data standard" and, since its version IFC4, it is published as ISO 16739 [i.2]. SAREF4BLDG is meant to enable the (currently missing) interoperability among various actors (architects, engineers, consultants, contractors, and product component manufacturers, among others) and applications managing building information involved in the different phases of the building life cycle (Planning and Design, Construction, Commissioning, Operation, Retrofitting/Refurbishment/Reconfiguration, and Demolition/Recycling). By using SAREF4BLDG, smart appliances from manufacturers that support the IFC data model will easily communicate with each other. Towards this aim, SAREF4BLDG should be used to annotate (or generate) neutral device descriptions to be shared among various stakeholders. 


SAREF4BLDG is an OWL-DL ontology that extends SAREF with 72 classes (67 defined in SAREF4EBLDG and 5 reused from the SAREF and geo ontologies), and 77 data type properties (76 defined in SAREF4EBLDG and 1 reused from the SAREF ontology). 


SAREF4BLDG focuses on extending the SAREF ontology to include those devices defined by the IFC version 4 - Addendum 1 [i.3] and to enable the representation of such devices and other physical objects in building spaces.


The prefixes and namespaces used in SAREF4BLDG and along the present document are listed in Table 1.

{{table_1}}

