

## SAREF4BLDG


### General overview


Figure 1 presents an overview of the classes (only the top levels of the hierarchy) and the properties included in the SAREF4BLDG extension. As it can be observed the classes `s4bldg:Building`, `s4bldg:BuildingSpace` and `s4bldg:PhysicalObject` have been declared as subclasses of the class `geo:SpatialThing` in order to reuse the conceptualization for locations already proposed by the geo ontology. The modelling of building objects and building spaces has been adapted from the SAREF ontology; in this sense, the new classes deprecate the `saref:BuildingObject` and `saref:BuildingSpace` classes. In addition, a new class has been created, the `s4bldg:Building` class, to represent buildings.


The concepts `s4bldg:Building` and `s4bldg:BuildingSpace` are related to each other by means of the properties `s4bldg:hasSpace` and `s4bldg:isSpaceOf`; such properties are defined as inverse properties among them. These properties might also be used to declare that a `s4bldg:BuildingSpace` has other spaces belonging to the class `s4bldg:BuildingSpace`.


The relationship between building spaces and devices and building objects has also been transferred and generalized from the SAREF ontology. In this regard, a `s4bldg:BuildingSpace` can contain (represented by the property `s4bldg:contains`) individuals belonging to the class `s4bldg:PhysicalObject`. This generalization has been implemented in order to support building spaces to contain both building objects and devices. Accordingly, the classes `s4bldg:BuildingObject` and `saref:Device` are declared as subclasses of `s4bldg:PhysicalObject`.


Finally, the class representing building devices, namely `s4bldg:BuildingDevice`, is defined as a subclass of both `saref:Device` and `s4bldg:BuildingObject`. This class is a candidate for replacing the `saref:BuildingRelated` class.

<figure>
    <img data-docx-width="15.90cm" src="diagrams/Overview.png" alt="General overview of the top levels of the SAREF4BLDG extension"/>
    <figcaption>Figure 1: General overview of the top levels of the SAREF4BLDG extension</figcaption>
</figure>


Table 2 summarizes the restrictions that characterize a `s4bldg:Building`. 

<table data-docx-preferred-width="7.69cm 8.48cm">
  <caption>Table 2: Restrictions of the s4bldg:Building class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>geo:location <strong>only</strong> geo:SpatialThing</td>
    <td>The location of a building is represented only by instances of geo:SpatialThing.</td>
  </tr>
  <tr>
    <td>s4bldg:hasSpace <strong>only</strong> s4bldg:BuildingSpace</td>
    <td>A building has spaces represented only by instances of s4bldg:BuildingSpace.</td>
  </tr>
</table>




Table 3 summarizes the restrictions that characterize a `s4bldg:BuildingSpace`. 

<table data-docx-preferred-width="7.69cm 8.48cm">
  <caption>Table 3: Restrictions of the s4bldg:BuildingSpace class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4bldg:contains <strong>only</strong> s4bldg:PhysicalObject</td>
    <td>A building space contains entities represented only by instances of s4bldg:PhysicalObject.</td>
  </tr>
  <tr>
    <td>s4bldg:hasSpace <strong>only</strong> s4bldg:BuildingSpace</td>
    <td>A building has spaces represented only by instances of s4bldg:BuildingSpace.</td>
  </tr>
  <tr>
    <td>s4bldg:isSpaceOf <strong>only</strong> (s4bldg:Building or s4bldg:BuildingSpace)</td>
    <td>A building is spaces of entities represented only by instances of the classes s4bldg:Building or s4bldg:BuildingSpace.</td>
  </tr>
</table>




Table 4 summarizes the restrictions that characterize a `s4bldg:PhysicalObject`. 

<table data-docx-preferred-width="7.69cm 8.48cm">
  <caption>Table 4: Restrictions of the s4bldg:PhysicalObject class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4bldg:contains <strong>only</strong> s4bldg:PhysicalObject</td>
    <td>A physical object contains entities represented only by instances of s4bldg:PhysicalObject.</td>
  </tr>
  <tr>
    <td>geo:location <strong>only</strong> geo:SpatialThing</td>
    <td>The location of a physical object is represented only by instances of geo:SpatialThing.</td>
  </tr>
  <tr>
    <td>s4bldg:isContained <strong>only</strong> (s4bldg:Building or s4bldg:BuildingSpace)</td>
    <td>A physical object is contained in entities represented only by instances of the classes s4bldg:Building or s4bldg:BuildingSpace.</td>
  </tr>
</table>




### Device Taxonomy


The main contribution of this extension is the representation of the devices defined in the IFC standard and their connections to SAREF. In this sense, a hierarchy consisting in 62 classes has been created taking into account the subset of the IFC hierarchy related to devices, as defined in the buildingSMART documentation ([https://standards.buildingsmart.org/IFC/RELEASE/IFC4/ADD1/HTML/annex/annex-c/common-use-definitions/index.htm](https://standards.buildingsmart.org/IFC/RELEASE/IFC4/ADD1/HTML/annex/annex-c/common-use-definitions/index.htm)), and adding several classes to clarify its categorization. The device classes are organized into 6 hierarchical levels that, for the sake of clarity, will be displayed in Figure 2 and Figure 3. 


Figure 2 shows the first five levels of the hierarchy. Since transport elements (`s4bldg:TransportElement`) and vibration isolations (`s4bldg:VibrationIsolation`) are not classified under IFC elements, they belong directly to the class `s4bldg:Device`. The building elements are divided into `s4bldg:ShadingDevice` and `s4bldg:DistributionDevice`. In fact, most of the device types included in IFC belong to the distribution device category which contains the classes s`4bldg:DistributionControlDevice` and `s4bldg:DistributionFlowDevice`. The hierarchy under the `s4bldg:DistributionFlowDevice is` depicted in Figure 3.


As can be observed in Figure 2, some classes defined in SAREF4BLDG are also defined in the SAREF ontology. More precisely, this occurs in the classes `s4bldg:Actuator` and `s4bldg:Sensor` that extend the classes `saref:Actuator` and `saref:Sensor`, respectively. This decision has been taken because in the SAREF4BLDG extension these concepts refer to specific sensors and actuators that are placed in or related to buildings. 

<figure>
    <img data-docx-width="11.18cm" src="diagrams/Hierarchy1.png" alt="Device hierarchy in SAREF4BLDG (Part 1)"/>
    <figcaption>Figure 2: Device hierarchy in SAREF4BLDG (Part 1)</figcaption>
</figure>

<figure>
    <img data-docx-width="15.74cm" src="diagrams/Hierarchy2.png" alt="Device hierarchy in SAREF4BLDG (Part 2)"/>
    <figcaption>Figure 3: Device hierarchy in SAREF4BLDG (Part 2)</figcaption>
</figure>


For each class extracted from the IFC specification, `rdfs:label` and `rdfs:comment` annotations have been generated including the identifier and an excerpt of the definition provided in the IFC online documentation. In addition, provenance information has been included using the PROV-O ontology ([https://www.w3.org/TR/prov-o](https://www.w3.org/TR/prov-o/)/), which has been published by the W3C as recommendation. In our case, the property `prov:hadPrimarySource` is used to link each class with:


!!! indent-1 ""
    (a)	the online document in IFC describing the concept; and 


!!! indent-1 ""
    (b)	the online document in IFC describing the properties defined for such concept. 


It should be noted that properties are not specified in IFC for all the concepts but just for those representing particular devices. That is, there is no description of properties for the following general classes: 

```
s4bldg:EnergyConversionDevice, s4bldg:FlowController, s4bldg:FlowMovingDevice, s4bldg:FlowStorageDevice, s4bldg:FlowTerminal, and s4bldg:FlowTreatmentDevice.
```

In addition, the classes created in this extension have been related to the ifcOWL ontology ([https://w3id.org/ifc/IFC4_ADD1](https://w3id.org/ifc/IFC4_ADD1)) when possible. This relation has been declared by means of the annotation property `rdfs:seeAlso` from the SAREF4BLDG classes to the ifcOWL ones. 


Listing 1 includes an excerpt of the ontology in the Turtle syntax that shows an example of a class including the annotations from the IFC specification, provenance references to the IFC class and property definition, and the mapping to the corresponding ifcOWL concept.

<figure>
<pre><code class="language-turtle">### Class definition 
s4bldg:Compressor rdf:type owl:Class ;
	rdfs:label "Compressor"@en ;
	rdfs:subClassOf s4bldg:FlowMovingDevice ;
	rdfs:comment "A compressor is a device that compresses a fluid typically used in a refrigeration circuit."@en ; 
### Provenance information for class definition
	prov:hadPrimarySource <http://www.buildingsmart-tech.org/ifc/IFC4/Add1/html/ schema/ifchvacdomain/lexical/ifccompressor.htm</code>> ;
### Provenance information for class properties       
	prov:hadPrimarySource <http://www.buildingsmart-tech.org/ifc/IFC4/Add1/html/ schema/ifchvacdomain/pset/pset_compressortypecommon.htm</code>> ;
### Mapping to ifcOWL classes       
  rdfs:seeAlso <https://w3id.org/ifc/IFC4_ADD1#IfcCompressor</code>> .
</code></pre>
<figcaption>Listing 1: Class definition example including documentation, mappings and provenance information</figcaption>
</figure>

### Measurements


Measurements are depicted in Figure 4. This model represents an n-ary pattern that allows users to relate measurements for different properties that are measured in different units. That is, the `saref:Measurement` class aims at describing a measurement of a physical quantity (using the `saref:hasValue` property) for a given `saref:Property` and according to a given `saref:UnitOfMeasure`. 


This pattern enables to differentiate between properties and the measurements made for such properties and to store measurements for a concrete property in different units of measurement.


Furthermore, it allows adding a timestamp (using the `saref:hasTimeStamp` property) to identify when the measurement applies to the property, which can be used either for single measurements or for series of measurements (e.g. measurement streams).


It is worth noting that this modelling was included in SAREF2.0 after the SAREF4BLDG extension was developed. This pattern was first included in the SAREF4ENVI and SAREF4BLDG extensions and then proposed to be extrapolated to SAREF 2.0; this explains why the prefix used for this part of the model refers to SAREF instead of to SAREF4BLDG. However, as its origin is the SAREF4ENVI and SAREF4BLDG extensions requirements and modellings, the explanations are kept in the present document.

<figure>
    <img data-docx-width="12.30cm" src="diagrams/Measurement.png" alt="Measurement model"/>
    <figcaption>Figure 4: Measurement model</figcaption>
</figure>


Table 5 summarizes the restrictions that characterize a `saref:Measurement`. 

<table data-docx-preferred-width="7.69cm 9.49cm">
  <caption>Table 5: Restrictions of the saref:Measurement class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>saref:hasTimestamp <strong>only</strong> xsd:dateTime</td>
    <td>The timestamp of a measurement is represented only by xsd:dateTime.</td>
  </tr>
  <tr>
    <td>saref:hasValue <strong>exactly</strong> 1 xsd:float</td>
    <td>A measurement should have exactly one value represented using xsd:float.</td>
  </tr>
  <tr>
    <td>saref:hasValue <strong>only</strong> xsd:float</td>
    <td>The value of a measurement is represented only by xsd:float.</td>
  </tr>
  <tr>
    <td>saref:isMeasuredIn <strong>exactly</strong> 1 saref:UnitOfMeasure</td>
    <td>A measurement should have exactly one unit of measurement which should be instance of saref:UnitOfMeasure.</td>
  </tr>
  <tr>
    <td>saref:isMeasuredIn <strong>only</strong> saref:UnitOfMeasure</td>
    <td>The unit of measurement of a measurement is represented only by instances of the class saref:UnitOfMeasure.</td>
  </tr>
  <tr>
    <td>saref:relatesToProperty <strong>exactly</strong> 1 saref:Property</td>
    <td>A measurement should be related exactly to one property which should be instance of saref:Property.</td>
  </tr>
  <tr>
    <td>saref:relatesToProperty <strong>only</strong> saref:Property</td>
    <td>The property to which a measurement is related to is represented only by instances of the class saref:Property.</td>
  </tr>
</table>




### Device Properties


In the SAREF4BLDG extension 179 object properties (177 defined in SAREF4EBLDG and 2 reused from the SAREF and geo ontologies) and 83 datatype properties (82 defined in SAREF4EBLDG and 1 reused from the SAREF ontology) have been included. 172 out the 179 object properties and 81 out of the 83 datatype properties have been created according to the IFC specification of properties for devices.


For each of the created object and datatype properties, their documentation from IFC has been attached as documentation, including information about their use, such as the expected units of measurement.


The naming of the created object and datatype properties is consistent with the naming used in IFC. More precisely, the names of the properties in the ontology are the names assigned in IFC transformed into Camel Case starting with lowercase. For example, the property "IdealShaftPower" (extracted from [https://standards.buildingsmart.org/IFC/RELEASE/IFC4/ADD1/HTML/schema/ifchvacdomain/pset/pset_compressortypecommon.htm](https://standards.buildingsmart.org/IFC/RELEASE/IFC4/ADD1/HTML/schema/ifchvacdomain/pset/pset_compressortypecommon.htm)) has been transformed into the object property `s4bldg:idealShaftPower`. 


Listing 2 includes an excerpt of the ontology in the Turtle syntax that shows an example of an object property and a datatype property including the annotations from the IFC specification.

<figure>
<pre><code code="language-turtle">### Object property definition example
s4bldg:idealShaftPower rdf:type owl:ObjectProperty ;
  rdfs:comment "Compressor shaft power under ideal conditions. Usually measured in Watts (W, J/s)."@en ;
  rdfs:label "ideal shaft power"@en . 
### Datatype property definition example
s4bldg:hasHotGasBypass rdf:type owl:DatatypeProperty ;
  rdfs:range xsd:boolean ;
  rdfs:comment "Whether or not hot gas bypass is provided for the compressor. TRUE = Yes, FALSE = No."@en ;
  rdfs:label "has hot gas bypass"@en .</code></pre>
<figcaption>Listing 2: Property definition example including documentation</figcaption>
</figure>

Table 6 shows the list of object properties extracted from IFC and the classes for which each property might be applied.

<table data-docx-preferred-width="8.00cm 6.32cm">
  <tr>
    <th>Object property</th>
    <th>Class(es)</th>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:airFlowRateRangeMax</td>
    <td>s4bldg:DuctSilencer</td>
  </tr>
  <tr>
    <td>s4bldg:Coil</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:airFlowRateRangeMin</td>
    <td>s4bldg:DuctSilencer</td>
  </tr>
  <tr>
    <td>s4bldg:Coil</td>
  </tr>
  <tr>
    <td>s4bldg:ambientDesignDryBulbTemperature</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:ambientDesignWetBulbTemperature</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:audioVolume</td>
    <td>s4bldg:AudioVisualAppliance</td>
  </tr>
  <tr>
    <td>s4bldg:basinReserveVolume</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:bladeThickness</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:bodyMass</td>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:capacityWeight</td>
    <td>s4bldg:TransportElement</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:closeOffRating</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:Valve</td>
  </tr>
  <tr>
    <td>s4bldg:coilLength</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:coilWidth</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:colorTempeature</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:compressorSpeed</td>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:connectionSize</td>
    <td>s4bldg:Pump</td>
  </tr>
  <tr>
    <td>s4bldg:contributedLuminousFlux</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:coverLength</td>
    <td>s4bldg:Interceptor</td>
  </tr>
  <tr>
    <td>s4bldg:coverWidth</td>
    <td>s4bldg:Interceptor</td>
  </tr>
  <tr>
    <td>s4bldg:effectiveCapacity</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:electricGeneratorEfficiency</td>
    <td>s4bldg:ElectricGenerator</td>
  </tr>
  <tr>
    <td>s4bldg:electricMotorEfficiency</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:externalSurfaceArea</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:Condenser</td>
  </tr>
  <tr>
    <td>s4bldg:faceArea</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:finalResistance</td>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td>s4bldg:firstCurvatureRadius</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:flowCoefficient</td>
    <td>s4bldg:Valve</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:flowRateRangeMax</td>
    <td>s4bldg:Pump</td>
  </tr>
  <tr>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:flowRateRangeMin</td>
    <td>s4bldg:Pump</td>
  </tr>
  <tr>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td>s4bldg:flowResistanceRangeMax</td>
    <td>s4bldg:Pump</td>
  </tr>
  <tr>
    <td>s4bldg:flowResistanceRangeMin</td>
    <td>s4bldg:Pump</td>
  </tr>
  <tr>
    <td>s4bldg:foulingFactor</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:frameDepth</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:frameThickness</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:heatExchangeArea</td>
    <td>s4bldg:EvaporativeCooler</td>
  </tr>
  <tr>
    <td>s4bldg:heatTransferSurfaceArea</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:height</td>
    <td>s4bldg:VibrationIsolator</td>
  </tr>
  <tr>
    <td>s4bldg:horizontalSpacing</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:hydraulicDiameter</td>
    <td>s4bldg:DuctSilencer</td>
  </tr>
  <tr>
    <td>s4bldg:idealCapacity</td>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:idealShaftPower</td>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:imaginaryImpedanceRatio</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:impellerDiameter</td>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:initialResistance</td>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td>s4bldg:inletConnectionSize</td>
    <td>s4bldg:Interceptor</td>
  </tr>
  <tr>
    <td>s4bldg:inLineRowSpacing</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:insideDiameter</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:internalRefrigerantVolume</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:Condenser</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:internalSurfaceArea</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:Condenser</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:internalWaterVolume</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:Condenser</td>
  </tr>
  <tr>
    <td>s4bldg:isolatorCompressibility</td>
    <td>s4bldg:VibrationIsolator</td>
  </tr>
  <tr>
    <td>s4bldg:isolatorStaticDeflection</td>
    <td>s4bldg:VibrationIsolator</td>
  </tr>
  <tr>
    <td>s4bldg:lampMaintenanceFactor</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:leakageFullyClosed</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:length</td>
    <td>s4bldg:DuctSilencer</td>
  </tr>
  <tr>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:liftElevationDifference</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:lightEmitterNominalPower</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:limitingTerminalSize</td>
    <td>s4bldg:ProtectiveDeviceTrippingUnit</td>
  </tr>
  <tr>
    <td>s4bldg:lockedRotorCurrent</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:maximumAirFlowRate</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:maximumApparentPower</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:maximumPartLoadRatio</td>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:maximumPowerOutput</td>
    <td>s4bldg:ElectricGenerator</td>
  </tr>
  <tr>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:maximumSupportedWeight</td>
    <td>s4bldg:VibrationIsolator</td>
  </tr>
  <tr>
    <td>s4bldg:maximumWorkingPressure</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:minimunPartLoadRatio</td>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:netPositiveSuctionHead</td>
    <td>s4bldg:Pump</td>
  </tr>
  <tr>
    <td rowspan="3">s4bldg:nominalAirFlowRate</td>
    <td>s4bldg:Humidifier</td>
  </tr>
  <tr>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:nominalBodyDepth</td>
    <td>s4bldg:Interceptor</td>
  </tr>
  <tr>
    <td>s4bldg:nominalBodyLength</td>
    <td>s4bldg:Interceptor</td>
  </tr>
  <tr>
    <td>s4bldg:nominalBodyWidth</td>
    <td>s4bldg:Interceptor</td>
  </tr>
  <tr>
    <td rowspan="4">s4bldg:nominalCapacity</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:Chiller</td>
  </tr>
  <tr>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:nominalCondensingTemperature</td>
    <td>s4bldg:Chiller</td>
  </tr>
  <tr>
    <td>s4bldg:nominalCoolingCapacity</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:nominalDepth</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:nominalDiameter</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:nominalEfficiency</td>
    <td>s4bldg:Chiller</td>
  </tr>
  <tr>
    <td>s4bldg:nominalEnergyConsumption</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:nominalEvaporatingTemmperature</td>
    <td>s4bldg:Chiller</td>
  </tr>
  <tr>
    <td>s4bldg:nominalFilterFaceVelocity</td>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td>s4bldg:nominalFlowRate</td>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td>s4bldg:nominalFrequency</td>
    <td>s4bldg:ElectricFlowStorageDevice</td>
  </tr>
  <tr>
    <td>s4bldg:nominalHeatingCapacity</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:nominalHeatRejectionRate</td>
    <td>s4bldg:Chiller</td>
  </tr>
  <tr>
    <td>s4bldg:nominalHeatTransferArea</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:nominalHeatTransferArea</td>
    <td>s4bldg:Condenser</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:nominalHeatTransferCoefficient</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:Condenser</td>
  </tr>
  <tr>
    <td>s4bldg:nominalLatentCapacity</td>
    <td>s4bldg:Coil</td>
  </tr>
  <tr>
    <td>s4bldg:nominalLengthOrDiameter</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:nominalMediaSurfaceVelocity</td>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td>s4bldg:nominalMoistureGain</td>
    <td>s4bldg:Humidifier</td>
  </tr>
  <tr>
    <td>s4bldg:nominalParticleGeometricMeanDiameter</td>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td>s4bldg:nominalParticleGeometricStandardDeviation</td>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td>s4bldg:nominalPartLoadRatio</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:nominalPowerConsumption</td>
    <td>s4bldg:Chiller</td>
  </tr>
  <tr>
    <td>s4bldg:nominalPowerRate</td>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td>s4bldg:nominalPressureDrop</td>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td>s4bldg:nominalReturnWaterTemperatureCooling</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:nominalReturnWaterTemperatureHeating</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:nominalRotationSpeed</td>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td>s4bldg:nominalSensibleCapacity</td>
    <td>s4bldg:Coil</td>
  </tr>
  <tr>
    <td>s4bldg:nominalSorroundingHumidityCooling</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:nominalSorroundingTemperatureCooling</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:nominalSorroundingTemperatureHeating</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:nominalStaticPressure</td>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td>s4bldg:nominalSupplyVoltage</td>
    <td>s4bldg:ElectricFlowStorageDevice</td>
  </tr>
  <tr>
    <td>s4bldg:nominalSupplyVoltageOffsetMax</td>
    <td>s4bldg:ElectricFlowStorageDevice</td>
  </tr>
  <tr>
    <td>s4bldg:nominalSupplyVoltageOffsetMin</td>
    <td>s4bldg:ElectricFlowStorageDevice</td>
  </tr>
  <tr>
    <td>s4bldg:nominalSupplyWaterTemperatureCooling</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:nominalSupplyWaterTemperatureHeating</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:nominalTotalPressure</td>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td>s4bldg:nominalUa</td>
    <td>s4bldg:Coil</td>
  </tr>
  <tr>
    <td>s4bldg:nominalWaterFlowCooling</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:nominalWaterFlowHeating</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:nominalWidthOrDiameter</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:nomminalRotationSpeed</td>
    <td>s4bldg:Pump</td>
  </tr>
  <tr>
    <td>s4bldg:openPressureDrop</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:operatingWight</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:operationalRiterial</td>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td rowspan="5">s4bldg:operationTemperatureRangeMax</td>
    <td>s4bldg:EvaporativeCooler</td>
  </tr>
  <tr>
    <td>s4bldg:AirToAirHeatRecovery</td>
  </tr>
  <tr>
    <td>s4bldg:Coil</td>
  </tr>
  <tr>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td rowspan="6">s4bldg:operationTemperatureRangeMin</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:EvaporativeCooler</td>
  </tr>
  <tr>
    <td>s4bldg:AirToAirHeatRecovery</td>
  </tr>
  <tr>
    <td>s4bldg:Coil</td>
  </tr>
  <tr>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td>s4bldg:outletConnectionSize</td>
    <td>s4bldg:Interceptor</td>
  </tr>
  <tr>
    <td>s4bldg:outletTemperatureRangeMax</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:outletTemperatureRangeMin</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:outputCapacity</td>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:outsideDiameter</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:pressureRating</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:primaryAirFlowRateRangeMax</td>
    <td>s4bldg:AirToAirHeatRecovery</td>
  </tr>
  <tr>
    <td>s4bldg:primaryAirFlowRateRangeMin</td>
    <td>s4bldg:AirToAirHeatRecovery</td>
  </tr>
  <tr>
    <td>s4bldg:primaryApparentPower</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:primaryCurrent</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:primaryFrequency</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:primaryVoltage</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:realImpedanceRatio</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:secondaryAirFlowRateRangeMax</td>
    <td>s4bldg:AirToAirHeatRecovery</td>
  </tr>
  <tr>
    <td>s4bldg:secondaryAirFlowRateRangeMin</td>
    <td>s4bldg:AirToAirHeatRecovery</td>
  </tr>
  <tr>
    <td>s4bldg:secondaryApparentPower</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:secondaryCurrent</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:secondaryFrequency</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:secondaryVoltage</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:secondCurvatureRadius</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:size</td>
    <td>s4bldg:Valve</td>
  </tr>
  <tr>
    <td>s4bldg:solarReflectance</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:solarTransmittance</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:spectrumMax</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:spectrumMin</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:staggeredRowSpacing</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:startCurrentFactor</td>
    <td>s4bldg:ElectricGenerator</td>
  </tr>
  <tr>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:startingTime</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td rowspan="3">s4bldg:temperatureRangeMax</td>
    <td>s4bldg:Pump</td>
  </tr>
  <tr>
    <td>s4bldg:DuctSilencer</td>
  </tr>
  <tr>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td rowspan="3">s4bldg:temperatureRangeMin</td>
    <td>s4bldg:Pump</td>
  </tr>
  <tr>
    <td>s4bldg:DuctSilencer</td>
  </tr>
  <tr>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:temperatureRating</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:testPressure</td>
    <td>s4bldg:Valve</td>
  </tr>
  <tr>
    <td>s4bldg:teTime</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:thermalConductivity</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:thermalEfficiency</td>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:thermalMassHeatCapacity</td>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:thermalTransmittance</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:ventilatingPipeSize</td>
    <td>s4bldg:Interceptor</td>
  </tr>
  <tr>
    <td>s4bldg:verticalSpacing</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:vibrationTransmissibility</td>
    <td>s4bldg:VibrationIsolator</td>
  </tr>
  <tr>
    <td>s4bldg:visibleLightReflectance</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:visibleLightTransmittance</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:volumen</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:waterInletTemperatureRangeMax</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:waterInletTemperatureRangeMin</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:waterPressureRangeMax</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:waterPressureRangeMin</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td rowspan="3">s4bldg:waterRequirement</td>
    <td>s4bldg:Humidifier</td>
  </tr>
  <tr>
    <td>s4bldg:EvaporativeCooler</td>
  </tr>
  <tr>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:waterStorageCapacity</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td rowspan="3">s4bldg:weight</td>
    <td>s4bldg:Humidifier</td>
  </tr>
  <tr>
    <td>s4bldg:DuctSilencer</td>
  </tr>
  <tr>
    <td>s4bldg:Filter</td>
  </tr>
  <tr>
    <td>s4bldg:workingPressure</td>
    <td>s4bldg:Valve</td>
  </tr>
  <tr>
    <td>s4bldg:workingPressureRangeMax</td>
    <td>s4bldg:DuctSilencer</td>
  </tr>
  <tr>
    <td>s4bldg:workingPressureRangeMin</td>
    <td>s4bldg:DuctSilencer</td>
  </tr>
</table>




Table 7 shows the list of datatype properties extracted from IFC and the classes for which each property might be applied.

<table data-docx-preferred-width="8.16cm 6.16cm">
  <tr>
    <th>Datatype properties</th>
    <th>Class(es)</th>
  </tr>
  <tr>
    <td>s4bldg:accessType</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:application</td>
    <td>s4bldg:Humidifier</td>
  </tr>
  <tr>
    <td>s4bldg:arrangement</td>
    <td>s4bldg:HeatExchanger</td>
  </tr>
  <tr>
    <td>s4bldg:bladeAction</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:bladeEdge</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:bladeShape</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:capacityControl</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:capacityControlType</td>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td>s4bldg:capacityPeople</td>
    <td>s4bldg:TransportElement</td>
  </tr>
  <tr>
    <td>s4bldg:circuitType</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:colorAppearance</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:colorRenderingIndex</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:controlStrategy</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:endShapeType</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td rowspan="4">s4bldg:energySource</td>
    <td>s4bldg:Burner</td>
  </tr>
  <tr>
    <td>s4bldg:Engine</td>
  </tr>
  <tr>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:evaporationCoolant</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:evaporationMediumType</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:failPosition</td>
    <td>s4bldg:Actuator</td>
  </tr>
  <tr>
    <td>s4bldg:finishColor</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:fireExit</td>
    <td>s4bldg:TransportElement</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:flowArrangement</td>
    <td>s4bldg:EvaporativeCooler</td>
  </tr>
  <tr>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:frameSize</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:frameType</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:hasDefrost</td>
    <td>s4bldg:AirToAirHeatRecovery</td>
  </tr>
  <tr>
    <td>s4bldg:hasExteriorInsulation</td>
    <td>s4bldg:DuctSilencer</td>
  </tr>
  <tr>
    <td>s4bldg:hasHotGasBypass</td>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:hasLock</td>
    <td>s4bldg:SwitchingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:hasPartWinding</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:hasTurbulator</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:heatTransferDimension</td>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:heatTransferMedium</td>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:heatTransferTypeEnum</td>
    <td>s4bldg:AirToAirHeatRecovery</td>
  </tr>
  <tr>
    <td>s4bldg:integratedLightingType</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:internalControl</td>
    <td>s4bldg:Humidifier</td>
  </tr>
  <tr>
    <td>s4bldg:isExternal</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:isFreeHanging</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td>s4bldg:isGuarded</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:isIlluminated</td>
    <td>s4bldg:SwitchingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:isNeutralPrimaryTerminalAvailable</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:isNeutralSecondaryTerminalAvailable</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:isPluggableOutlet</td>
    <td>s4bldg:Outlet</td>
  </tr>
  <tr>
    <td>s4bldg:isWaterStorageHeater</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:lampBallastType</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:lampCompensationType</td>
    <td>s4bldg:Lamp</td>
  </tr>
  <tr>
    <td>s4bldg:legend</td>
    <td>s4bldg:SwitchingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:manualOverride</td>
    <td>s4bldg:Actuator</td>
  </tr>
  <tr>
    <td>s4bldg:mechanicalOperated</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:mediaSource</td>
    <td>s4bldg:AudioVisualAppliance</td>
  </tr>
  <tr>
    <td>s4bldg:motorDriveType</td>
    <td>s4bldg:Fan</td>
  </tr>
  <tr>
    <td>s4bldg:motorEnclosureType</td>
    <td>s4bldg:ElectricMotor</td>
  </tr>
  <tr>
    <td>s4bldg:numberOfBlades</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:numberOfCells</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:numberOfCircuits</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td>s4bldg:numberOfGangs</td>
    <td>s4bldg:SwitchingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:numberOfPanels</td>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:numberOfRows</td>
    <td>s4bldg:TubeBundle</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:numberOfSections</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:numberOsSockets</td>
    <td>s4bldg:Outlet</td>
  </tr>
  <tr>
    <td>s4bldg:operatingMode</td>
    <td>s4bldg:Boiler</td>
  </tr>
  <tr>
    <td>s4bldg:operation</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:orientation</td>
    <td>s4bldg:Damper</td>
  </tr>
  <tr>
    <td>s4bldg:patternType</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:pipeConnectionEnum</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
  <tr>
    <td rowspan="2">s4bldg:placementType</td>
    <td>s4bldg:Coil</td>
  </tr>
  <tr>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:powerSource</td>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:readOutType</td>
    <td>s4bldg:FlowMeter</td>
  </tr>
  <tr>
    <td rowspan="3">s4bldg:refrigerantClass</td>
    <td>s4bldg:Evaporator</td>
  </tr>
  <tr>
    <td>s4bldg:Compressor</td>
  </tr>
  <tr>
    <td>s4bldg:Condenser</td>
  </tr>
  <tr>
    <td>s4bldg:remoteReading</td>
    <td>s4bldg:FlowMeter</td>
  </tr>
  <tr>
    <td>s4bldg:roughness</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:secondaryCurrentType</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:shadingDeviceType</td>
    <td>s4bldg:ShadingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:shortCircuitVoltage</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:sprayType</td>
    <td>s4bldg:CoolingTower</td>
  </tr>
  <tr>
    <td>s4bldg:standard</td>
    <td>s4bldg:ProtectiveDeviceTrippingUnit</td>
  </tr>
  <tr>
    <td>s4bldg:storageType</td>
    <td>s4bldg:Tank</td>
  </tr>
  <tr>
    <td>s4bldg:switchFunction</td>
    <td>s4bldg:SwitchingDevice</td>
  </tr>
  <tr>
    <td>s4bldg:temperatureClassification</td>
    <td>s4bldg:SpaceHeater</td>
  </tr>
  <tr>
    <td>s4bldg:transformerVectorGroup</td>
    <td>s4bldg:Transformer</td>
  </tr>
  <tr>
    <td>s4bldg:valveMechanism</td>
    <td>s4bldg:Valve</td>
  </tr>
  <tr>
    <td>s4bldg:valveOperation</td>
    <td>s4bldg:Valve</td>
  </tr>
  <tr>
    <td>s4bldg:valvePattern</td>
    <td>s4bldg:Valve</td>
  </tr>
  <tr>
    <td>s4bldg:waterFlowControlSystemType</td>
    <td>s4bldg:CooledBeam</td>
  </tr>
</table>




As an example of a complete class definition including all its properties, Table 8 summarizes the restrictions that characterize a `s4bldg:Compressor`, using the properties extracted from IFC. The example contains different types of properties that are representative enough for the rest of the transformed classes. It should be noted that the full ontology documentation will be available online in HTML format, since including all the restrictions in the present document would make it unmanageable.

<table data-docx-preferred-width="7.69cm 8.48cm">
  <caption>Table 8: Restrictions of the s4bldf:Compressor class</caption>
  <tr>
    <th>Property</th>
    <th>Definition</th>
  </tr>
  <tr>
    <td>s4bldg:compressorSpeed <strong>only</strong> saref:Measurement</td>
    <td>The speed of a compressor is represented only by instances of saref:Measurement.</td>
  </tr>
  <tr>
    <td>s4bldg:idealCapacity <strong>only</strong> saref:Measurement</td>
    <td>The ideal capacity of a compressor is represented only by instances of saref:Measurement.</td>
  </tr>
  <tr>
    <td>s4bldg:idealShaftPower <strong>only</strong> saref:Measurement</td>
    <td>The ideal shaft power of a compressor is represented only by instances of saref:Measurement.</td>
  </tr>
  <tr>
    <td>s4bldg:impellerDiameter <strong>only</strong> saref:Measurement</td>
    <td>The impeller diameter of a compressor is represented only by instances of saref:Measurement.</td>
  </tr>
  <tr>
    <td>s4bldg:nominalCapacity <strong>only</strong> saref:Measurement</td>
    <td>The nominal capacity of a compressor is represented only by instances of saref:Measurement.</td>
  </tr>
  <tr>
    <td>s4bldg:partLoadRatioMax <strong>only</strong> saref:Measurement</td>
    <td>The maximum value of the part load ratio range of a compressor is represented only by instances of saref:Measurement.</td>
  </tr>
  <tr>
    <td>s4bldg:partLoadRatioMin <strong>only</strong> saref:Measurement</td>
    <td>The minimum value of the part load ratio range of a compressor is represented only by instances of saref:Measurement.</td>
  </tr>
  <tr>
    <td>s4bldg:powerSource <strong>only</strong> xsd:string</td>
    <td>The power source of a compressor value is indicated only by xsd:string.</td>
  </tr>
  <tr>
    <td>s4bldg:refrigerantClass <strong>only</strong> xsd:string	</td>
    <td>The refrigeration class of a compressor value is indicated only by xsd:string.	</td>
  </tr>
  <tr>
    <td>s4bldg:hasHotGasBypass <strong>only</strong> xsd:boolean</td>
    <td>Whether a compressor has a hot gas bypass is indicated only by values of xsd:boolean.</td>
  </tr>
</table>




## Observations about S4BLDG


In the following, several observations about potential uses of the SAREF4BLDG ontology are listed.


It should be mentioned that the range of the `s4bldg:shortCircuitVoltage` object property is open to different representations of complex numbers. In this sense, when reusing the ontology users should define the class to be used to represent complex numbers or reuse an existing one.


In addition, the list of building devices should not be considered exhaustive, the current classification represents those devices described in IFC. It might be needed to extend the hierarchy in the case of new devices related to buildings are described in new versions of IFC or are needed for a particular use case.


Furthermore, it is expected that concrete use cases will either reuse the existing classes to represent their devices or specialize some of these classes to cover specific device types (e.g. by creating a hierarchy of boiler devices under the `s4bldg:Boiler` class).
