
# Approach


During the development of this extension, the ontological requirements were directly extracted from the IFC specification. The reason for this is that no domain experts providing real uses cases were available, even though some conversations with experts in order to clarify doubts have taken place. However, the requirements have been aligned with the uses cases in the building sector that have been defined in the "W3C Linked Building Data Community Group" ([https://www.w3.org/community/lbd](https://www.w3.org/community/lbd/)/) and are publicly accessible ([https://www.w3.org/community/lbd/wiki/Seed_Use_Cases](https://www.w3.org/community/lbd/wiki/Seed_Use_Cases)). 


The first step for developing this SAREF extension has been to extract ontological requirements taking the IFC specification [i.3] as a starting point. In order to select the subset of IFC that is relevant in the context of a SAREF extension, the boundaries of the concepts that have been included are delimited by the term "device", that is, every entity that can be classified as a device has been taken into account. The detailed process for extracting the requirements is provided in the technical report [i.1]. This step was crucial due to the fact that IFC is organized according to different architectural process views and it does not contain a clear classification of devices as they are distributed in different branches of a broader classification.


Once the concepts to be represented, their descriptions and their properties were extracted from IFC, a non-ontological resource reengineering process [i.4] was carried out. This process consisted in the transformation of the non-ontological resource, in this case the IFC documentation, into an ontological resource following a TBox transformation approach. That is, the original resource was transformed in the terminological box (TBox) of a knowledge base (i.e. the ontology).


IFC defines the concept "Element"; however, this concept is too broad to be reused since it refers to devices and any other element than can appear in a building. This issue also appears in other levels of the hierarchy; for example, IFC defines the concept "Distribution element" which contains devices but also many other elements that are not devices. In this case the class `s4bldg:DistributionDevice` has been created in order to restrict the use to devices. This decision has been taken for the following classes: `s4bldg:BuildingDevice`, `s4bldg:DistributionDevice`, `s4bldg:DistributionControlDevice`, and `s4bldg:DistributionFlowDevice`.


For each class, its associated properties described in IFC have been transformed into object or datatype properties. It is worth noting that not all the properties defined in the IFC standard have been transformed because, for example, in some cases the definition of the properties assigned to the classes included only the property identifier (which in RDF can be considered to be the URI of the given instance) and its status (which indicates whether the element previously existed or is a new item in a retrofitting project). An example can be seen in the concept "Controller" ([https://standards.buildingsmart.org/IFC/RELEASE/IFC4/ADD1/HTML/schema/ifcbuildingcontrolsdomain/pset/pset_controllertypecommon.htm](https://standards.buildingsmart.org/IFC/RELEASE/IFC4/ADD1/HTML/schema/ifcbuildingcontrolsdomain/pset/pset_controllertypecommon.htm)).


Furthermore, during the process, the datatypes associated in IFC to each property have been identified and analysed in order to transform them into OWL. That is, not all the properties defined in IFC have been transformed in the same way. Table A.1 details the decisions taken for each datatype appearing in IFC properties.

<table data-docx-preferred-width="6.33cm 9.89cm">
  <caption>Table A.1: Property transformations from IFC to OWL</caption>
  <tr>
    <th>IFC datatype </th>
    <th>Transformation to OWL</th>
  </tr>
  <tr>
    <td>logical</td>
    <td>Transform to datatype property with range xsd:boolean</td>
  </tr>
  <tr>
    <td>boolean</td>
    <td>Transform to datatype property with range xsd:boolean</td>
  </tr>
  <tr>
    <td>natural</td>
    <td>Transform to datatype property with range xsd:nonNegativeInteger</td>
  </tr>
  <tr>
    <td>integer</td>
    <td>Transform to datatype property with range xsd:integer</td>
  </tr>
  <tr>
    <td>string</td>
    <td>Transform to datatype property with range xsd:string</td>
  </tr>
  <tr>
    <td>{string}</td>
    <td>Transform to datatype property with range xsd:string</td>
  </tr>
  <tr>
    <td><p>Real</p>
<p>(associated to a P_SINGLEVALUE)</p></td>
    <td>Transform to object property that would be used to link to an instance of saref:Measurement</td>
  </tr>
  <tr>
    <td><p>real </p>
<p>(associated to a P_BOUNDEDVALUE)</p></td>
    <td>Transform to two object properties (one for maximum value and another for minimum value) that would be used to link to an instance of saref:Measurement</td>
  </tr>
  <tr>
    <td>ratio</td>
    <td>Transform to object property that would be used to link to an instance of saref:Measurement</td>
  </tr>
  <tr>
    <td>real ratio</td>
    <td>Transform to object property that would be used to link to an instance of saref:Measurement</td>
  </tr>
  <tr>
    <td>normalized ratio</td>
    <td>Transform to object property that would be used to link to an instance of saref:Measurement</td>
  </tr>
  <tr>
    <td>positive ratio</td>
    <td>Transform to object property that would be used to link to an instance of saref:Measurement</td>
  </tr>
  <tr>
    <td>complex</td>
    <td>Transform to object property with open range</td>
  </tr>
</table>




Finally, local restrictions for each class have been added indicating the expected use of each of the properties that can be applied to a class.


As mentioned, SAREF concepts have been extended when they needed to be specialized and properties from SAREF have been reused. In addition, other ontologies have been reused following the SAREF practices. More precisely the following classes have been extended:

* `saref:Device with s4bldg:BuildingDevice, s4bldg:TransportElement and s4bldg:VibrationIsolation`
* `saref:Actuator with s4bldg:Actuator`
* `saref:Sensor with s4bldg:Sensor`
* `geo:SpatialThing with s4bldg:PhysicalObject`

The following classes and properties have also been directly reused:

* `saref:UnitOfMeasure` 
* `saref:isMeasuredIn`
* `saref:hasValue`
* `geo:location`

As already commented some entities firstly defined in the SAREF4ENVI and SAREF4BLDG extensions have been included into SAREF2.0, and now are directly reused, namely:


* `saref:Measurement`
* `saref:makesMeasurement`
* `saref:measuresProperty`
* `saref:relatesToProperty`


# Bibliography

* ETSI TS 103 267: "SmartM2M; Smart Applications; Communication Framework".
* ETSI TS 102 689: "Machine-to-Machine communications (M2M); M2M Service Requirements".
* ETSI TS 118 101: "oneM2M, Functional Architecture (oneM2M TS-0001)".
* ETSI TS 118 102: "oneM2M; Requirements (oneM2M TS-0002)".
