
# SAREF4BLDG ontology and semantics


## Introduction


The present document is a technical specification of SAREF4BLDG, an extension of the SAREF ontology [1] that was created based on the Industry Foundation Classes (IFC) standard for building information. It should be noted that not the whole standard has been transformed since it exceeds the scope of this extension, which is limited to devices and appliances within the building domain. 


The IFC specification is developed and maintained by buildingSMART International as its "Data standard" and, since its version IFC4, it is published as the ISO 16739 [i.2] standard. SAREF4BLDG is meant to enable the (currently missing) interoperability among various actors (architects, engineers, consultants, contractors, and product component manufacturers, among others) and applications managing building information involved in the different phases of the building life cycle (Planning and Design, Construction, Commissioning, Operation, Retrofitting/Refurbishment/Reconfiguration, and Demolition/Recycling). By using SAREF4BLDG, smart appliances from manufacturers that support the IFC data model will easily communicate with each other. Towards this aim, SAREF4BLDG should be used to annotate (or generate) neutral device descriptions to be shared among various stakeholders. 


SAREF4BLDG is an OWL-DL ontology that extends SAREF with 72 classes (67 defined in SAREF4EBLDG and 5 reused from the SAREF and geo ontologies), 179 object properties (177 defined in SAREF4EBLDG and 2 reused from the SAREF and geo ontologies), and 83 data type properties (82 defined in SAREF4EBLDG and 1 reused from the SAREF ontology). 


SAREF4BLDG focuses on extending the SAREF ontology to include those devices defined by the IFC version 4 - Addendum 1 [i.3] and to enable the representation of such devices and other physical objects in building spaces.


The prefixes and namespaces used in SAREF4BLDG and along the present document are listed in Table 1.

{{table_1}}


