## Instantiating SAREF4AGRI

### Livestock farming


This clause shows an example of how to instantiate the SAREF4AGRI extension of SAREF for the livestock farming use case. The example describes a family company owned farm that grows certain crops and owns lactating cows. Various sensors are used in the farm to monitor animals and crops. 


The first part of the example is related to the organizational aspects of the farm and is shown in Figure 9. 


<figure>
        <img data-docx-width="25.10cm" src="diagrams/image10.png" alt="Farm example"/>
        <figcaption>Figure 9: Farm example</figcaption>
    </figure>


Figure 9 shows two instances of a farmer, namely _ex:H. Jansen_ and _ex:J. Jansen_, which are both members of the `s4agri:FarmHolding` _ex:Janse an Sons_. The organization manages the `s4agri:Farm` _ex:Farm Jansen and Son Eindhoven_.


Note that the `s4agri:Farm` is a subclass of `geosp:Feature` and consequently of `geo:SpatialObject`, which enables to describe the exact geometrical aspects of the area. Moreover, _ex:Farm Jansen and Son Eindhoven_ contains the following additional instances of type `geosp:Feature`:

* four `s4agri:Parcel` (ex:Parcel South, ex:Parcel West, ex:Parcel North, ex:Parcel East)
* two `s4agri:Building` (ex:Milk Cow Barn, ex:Heated Glass Greenhouse) 

Furthermore, the figure shows that _ex:Parcel East_ and _ex:Parcel West_ both contain some `s4agri:Crop` (_ex:Sweet Corn 1_ and _ex:Sweet Corn 2_, respectively). Additionally, _ex:Parcel North_ contains the `s4agri:AnimalGroup` _Cow Group A_, which consists of the `s4agri:Animals` _ex:Cow1_ and _ex:Cow2_. Finally, Figure 9 shows that _ex:Parcel South_ does not contain anything.


Figure 10 elaborates on _ex:Parcel North_ that contains the _ex:Cow Group A_ with two cows (i.e. _ex:Cow1_ and _ex:Cow2_) which are similarly taxonomically described using the `TAXRANK` taxonomy vocabulary. The _ex:Cow Group A_ generates `s4agri:MilkYield`, which is a type of `s4agri:Yield` and consequently a `s4agri:Property`. The example contains one instance of _Milk Yield_ that represents the outcome of the milking procedure of a certain cow. The _Milk Yield_ instance is measured in _om:Liter_ by the _ex:MilkYieldSensor_. The _ex:MilkYieldSensor_ is of type `s4agri:MilkingSensor`, which is a `saref:Sensor`, and thus a FunctionRelated `saref:Device`. Figure 10 further shows that the sensor is contained in an _ex:Milking Machine_, which is a `saref:Device`, and the _ex:Milking Machine_ has a sensor that measures the yield. The measurements are directly linked to the sensor, instead of to the milk machine itself, because a large machine can have multiple sensors. 


<figure>
        <img data-docx-width="25.49cm" src="diagrams/image11.png" alt="Cow, milking sensor and measurement example"/>
        <figcaption>Figure 10: Cow, milking sensor and measurement example</figcaption>
    </figure>


Figure 11 further shows an example of another `s4agri:AnimalGroup`, namely _ex:Cow Group B_. This `s4agri:AnimalGroup` only contains a single cow (i.e. _ex:Cow3_) whose eating activity is being monitored by _ex:Cow Eating Activity Sensor 33_. This `s4agri:EatingActivitySensor` made two measurements about the cow eating activity (i.e. the minutes a cow eats per hour).


<figure>
        <img data-docx-width="26.06cm" src="diagrams/image12.png" alt="Cow, eating activity sensor and measurement example"/>
        <figcaption>Figure 11: Cow, eating activity sensor and measurement example</figcaption>
    </figure>

### Smart Irrigation


This clause shows an example of how to instantiate the SAREF4AGRI extension of SAREF to represent the deployment of some sensors and an example of measurement for the smart irrigation use case. This example is shown in Figure 12.


<figure>
        <img data-docx-width="25.83cm" src="diagrams/image13.png" alt="Smart Irrigation example"/>
        <figcaption>Figure 12: Smart Irrigation example</figcaption>
    </figure>


The `ex:ArvalisDeployment20162017Land07` deployment is deployed in the `ex:PlatformArvalisLand07` platform and has a deployed system, namely the smart irrigation station `ex:ArvalisIrrinovStation01`. The deployment takes place in the time interval between January 2016 and the end of 2017, defined as `ex:TimeInterval2016-2017`.


The deployed system, `ex:ArvalisIrrinovStation01`, is composed of two sensors identified by the URIs `ex:ArvalisIrrinovStation01SoilSensor01` and `ex:ArvalisIrrinovStation01SoilSensor02` which are linked from the system by the property `ssn:hasSubSystem`. Both sensors are of the type `ex:SoilTensiometer`. Both sensors measure (`saref:measuresProperty`) the soil moisture property (`s4agri:SoilMoisture`). The sensors are located at different depths in the soil, as it is indicated by the `geo:alt` property, i.e. `ex:ArvalisIrrinovStation01SoilSensor01` is located at 30 cm depth and `ex:ArvalisIrrinovStation01SoilSensor02` is located at 60 cm, considering that the `geo:alt` property express the dimensions in decimal meters. 


A measurement taken by the `ex:ArvalisIrrinovStation01SoilSensor02` sensor is also depicted, namely the measurement `ex:ArvalisIrrinovStation01SoilSensor02ObservationAtPT24H2016-06-14T000000_0200`. This measurement is about (`saref:relatesToProperty`) the soil moisture property (`s4agri:SoilMoisture`). This measurement has a value of 1 490,0 expressed in millibars (`om:millibar`).



