## SAREF4AGRI

### General Overview


An overview of the SAREF4AGRI ontology is provided in Figure 1. For all the entities described in the present document, it is indicated whether they are defined in the SAREF4AGRI extension or elsewhere by the prefix included before their identifier, i.e. if the element is defined in SAREF4AGRI, the prefix is `s4agri`, while if the element is reused from another ontology it is indicated by a prefix according to Table 1.


Arrows are used to represent properties between classes and to represent some RDF, RDF-S and OWL constructs, more precisely:

* Plain arrows with white triangles represent the `rdfs:subClassOf` relation between two classes. The origin of the arrow is the class to be declared as subclass of the class at the destination of the arrow.
* Dashed arrows between two classes indicate a local restriction in the origin class, i.e. that the object property can be instantiated between the classes in the origin and the destination of the arrow. The identifier of the object property is indicated within the arrow.
* Dashed arrows with identifiers between stereotype signs (i.e. "<< >>") refer to OWL constructs that are applied to some ontology elements, that is, they can be applied to classes or properties depending on the OWL construct being used.
* Dashed arrows with no identifier are used to represent the `rdf:type` relation, indicating that the element in the origin of the arrow is an instance of the class in the destination of the arrow.

Datatype properties are denoted by rectangles attached to the classes, in an UML-oriented way. Dashed boxes represent local restrictions in the class, i.e. datatype properties that can be applied to the class they are attached to.


Individuals are denoted by rectangles in which the identifier is underlined.


Note that Figure 1 aims at showing a global overview of the main classes of SAREF4AGRI and their mutual relations. More details on the different parts of Figure 1 are provided from clause 4.2.2 to clause 4.2.8.


<figure>
        <img data-docx-width="23.59cm" src="diagrams/Overview.png" alt="SAREF4AGRI overview"/>
        <figcaption>Figure 1: SAREF4AGRI overview</figcaption>
    </figure>

### Platform, System and Deployment 


The model defined in SAREF4AGRI for representing platforms, systems and deployments is depicted in Figure 2. The main entities in the modelling are represented by the `ssn:System` and `ssn:Deployment` classes. Note that the design patterns for modelling these concepts have been taken from the W3C SSN ontology and, as a best practice for reuse, the SAREF4AGRI model refers directly to the URIs of the SSN (http://www.w3.org/ns/ssn/) and SOSA (http://www.w3.org/ns/sosa/) ontologies. 


The `ssn:System` class in the SSN ontology represents a system and is components as specific devices, actuators or sensors. Moreover, the `ssn:Deployment` class from the SSN ontology describes the deployment of one or more systems on a `sosa:Platform` for a particular purpose for a given time period. SAREF4AGRI defines a `saref:Device` as subclass of an `ssn:System` and extends the `ssn:Deployment` class by means of the `s4agri:Deployment` class. In this way, it is possible to represent a specific installation of a certain agricultural system (e.g. a smart irrigation system) in a given space (expressed by means of the property `s4agri:hasDeploymentPeriod`) and at a given temporal frame (expressed by means of the property `s4agri:isDeployedAtSpace`) where SAREF4AGRI devices (e.g. a pluviometer, a soil tensiometer, a weather station and a watering gun) can be deployed. The deployment can involve a given `sosa:Platform` which hosts the system deployed in such deployment. In order to represent temporal information the TIME ontology has been reused. For the geographical information both the GeoSPARQL ontology ([http://www.opengis.net/ont/geosparql#](http://www.opengis.net/ont/geosparql)) and the WGS84 Geo vocabulary ([http://www.w3.org/2003/01/geo/wgs84_pos#](http://www.w3.org/2003/01/geo/wgs84_pos)) are reused.


<figure>
        <img data-docx-width="17.00cm" src="diagrams/Platform.png" alt="Platform, System and Deployment"/>
        <figcaption>Figure 2: Platform, System and Deployment</figcaption>
    </figure>


Table 2 summarizes the properties that characterize the `s4agri:Deployment` class.


<table data-docx-preferred-width="9.48cm 6.96cm">
  <caption>Table 2: Properties of Deployment</caption>
  <tr>
    <th>
Property
</th>
    <th>
Definition
</th>
  </tr>
  <tr>
    <td>
s4agri:Deployment ssn:deployedOnPlatform some sosa:Platform
</td>
    <td>
The relation between a deployment and the platform in which it is deployed.
</td>
  </tr>
  <tr>
    <td>
s4agri:Deployment ssn:deployedSystem some ssn:System 
</td>
    <td>
The relation between a deployment and the system deployed.
</td>
  </tr>
  <tr>
    <td>
s4agri:Deployment s4agri:hasDeployementPeriod some time:TemporalEntity
</td>
    <td>
The relation between a deployment and the time span during which the systems are deployed.
</td>
  </tr>
  <tr>
    <td>
s4agri:Deployment s4agri:isDeployedAtSpace somegeosp:SpatialObject
</td>
    <td>
The relation between a deployment and the spatial area in which the systems are deployed.
</td>
  </tr>
</table>



### Measurement


As shown in Figure 3, the modelling of measurements in SAREF4AGRI relies on the measurement model proposed in SAREF to express information about a certain property to be measured, its measured value, its measurement unit and the time of the measurement.


This modelling includes the `saref:FeatureOfInterest` (whose design pattern has been taken from the W3C SSN ontology) that provides the means to refer to the real world phenomena that is being observed in a given measurement (e.g. a cow can be defined in SAREF4AGRI as the feature of interest of a weight measurement made by a weight sensor). The reader is referred to the SAREF specification [1] for details about the modelling of measurements, whereas the present document includes details only for the new concepts created in SAREF4AGRI, such as the classes and instances added to support the livestock farming and smart irrigation use cases. Note that a work item ETSI TS 103 264 [1 has been opened to evolve the current SAREF core specification ETSI TS 103 264 [1]  according to the latest developments in various sectors, including the input from the SAREF4AGRI extension in the present document. ETSI TS 103 264 [1 work item will result in an updated SAREF 3.0 core ontology. The following properties (to be included in SAREF 3.0) are reused in SAREF4AGRI to complete the model of measurements:

* `saref:isPropertyOf` (and its inverse `saref:hasProperty)` to link the property being observed with the feature of interest.
* `saref:hasFeatureOfInterest` (and its inverse `saref:isFeatureOfInterestOf`) to link a given measurement with the feature of interest being observed.
* `saref:measurementMadeBy` has been included as complement of the `saref:makesMeasurement`, as its inverse, to link a measurement and the device that produces it.

<figure>
        <img data-docx-width="13.52cm" src="diagrams/Measurement.png" alt="Measurement model"/>
        <figcaption>Figure 3: Measurement model</figcaption>
    </figure>


In order to support the Smart Irrigation use case, a number of units of measure have been added to SAREF4AGRI as instances of the `saref:UnitOfMeasure` class, namely `dbpedia:DBM` (decibel-milliwatts), `om:millivolt` (millivolt), `om:millimetre` (millimetre), `om:millibar` (millibar) and `om:degree_Celsius` (degree Celsius). Additionally, for the livestock farming use case the `om:Liter` unit has been added. These instances have been reused from DBpedia ([https://wiki.dbpedia.org/](https://wiki.dbpedia.org/)) and the Ontology of units of Measure (OM) 2.0 ([http://www.ontology-of-units-of-measure.org/](http://www.ontology-of-units-of-measure.org/)).


In order to support the livestock farming use case (and potentially other use cases such as arable farming and horticulture in future SAREF4AGRI releases), the `s4agri:Animal`, `s4agri:AnimalGroup` and `s4agri:Crop` classes have been added to SAREF4AGRI as subclasses of `saref:FeatureOfInterest` (see clause 4.2.4).


In this way, measurements from relevant sensors (such as on animal activity movement, temperature, weight, milking yield, etc.) can be related via the `hasFeatureOfInterest` relation to specific e.g. (groups of) animals that are instances of the `saref:FeatureOfInterest` class. This relation is explained in more detail in the following clause. 

### Animal, Crop and Soil (Feature of Interest)


The main features of interest in SAREF4AGRI currently support (aspects of) the livestock farming and smart irrigation use cases and are represented by the `s4agri:Animal`, `s4agri:AnimalGroup`, `s4agri:Crop` and `s4agri:Soil` classes that are shown in Figure 4. 


<figure>
        <img data-docx-width="4.54cm" src="diagrams/FoI.png" alt="Animal, Crop and Soil"/>
        <figcaption>Figure 4: Animal, Crop and Soil</figcaption>
    </figure>


The `s4agri:Animal` class describes an animal that can be classified in SAREF4AGRI reusing the `TAXRANK` taxonomy vocabulary ([http://purl.obolibrary.org/obo/taxrank.owl#](http://purl.obolibrary.org/obo/taxrank.owl)). Besides the reuse of the `TAXRANK` taxonomy vocabulary, an animal is furthermore defined in SAREF4AGRI in order to have a birth and death date. An animal also has a unique identifier and can be part of one or more `s4agri:AnimalGroup` that are used to conduct experiments and observations on the livestock. Note that animals can be also specialized using subclasses, as is shown in the example in clause 4.3.1 with the `ex:LactatingCow` class that was created as a subclass of `s4agri:Animal`. Animals and animal groups are related to measurements via the `saref:FeatureOfinterest` concept of SAREF (see clause 4.2.3). 


The `s4agri:Soil` class represents the upper layer of the earth in which plants grow. The `s4agri:Crop` class describes a collection of homogeneous plant species that is grown on a large scale commercially (especially a cereal, fruit, or vegetable) and is planted on a single location. A `s4agri:Crop` is grown on some `s4agri:Parcel`, which is an area of land, defined in SAREF4AGRI as subclass of the `geosp:Feature` (see clause 4.2.6). Moreover, `s4agri:Crop` is related to measurements via `saref:FeatureOfInterest` (see clause 4.2.3).


Table 3 and Table 4 summarize the definitions of the main classes and properties described above. 


<table data-docx-preferred-width="4.24cm 12.74cm">
  <caption>Table 3: Animal, Crop and Soil: class definitions</caption>
  <tr>
    <th>
Class
</th>
    <th>
Definition
</th>
  </tr>
  <tr>
    <td>
s4agri:Animal
</td>
    <td>
An individual and identifiable organism that feeds on organic matter, typically having specialized sense organs and nervous system and able to respond rapidly to stimuli. Animals can be further specialized using subclasses, for example, to represent a lactating cow that is a domesticated cow specialized for the production of milk.
</td>
  </tr>
  <tr>
    <td>
s4agri:AnimalGroup
</td>
    <td>
A collection of one or multiple s4agri:Animal.
</td>
  </tr>
  <tr>
    <td>
s4agri:Crop
</td>
    <td>
A collection of cultivated plants that is grown on a large scale commercially, especially a cereal, fruit, or vegetable.
</td>
  </tr>
  <tr>
    <td>
s4agri:Soil
</td>
    <td>
Upper layer of the earth in which plants grow. 
</td>
  </tr>
</table>




<table data-docx-preferred-width="6.74cm 10.24cm">
  <caption>Table 4: Animal and Crop: property definitions</caption>
  <tr>
    <th>
Property
</th>
    <th>
Definition
</th>
  </tr>
  <tr>
    <td>
<strong>s4agri:Animal</strong>
</td>
    <td>

</td>
  </tr>
  <tr>
    <td>
obo:TAXRANK_1000000 some obo:TAXRANK_0000000
</td>
    <td>
The taxonomic ranking using TAXRANK. 
</td>
  </tr>
  <tr>
    <td>
s4agri:hasBirthDate max 1 xsd:dateTime
</td>
    <td>
The birth date of an animal.
</td>
  </tr>
  <tr>
    <td>
s4agri:hasDeathDate max 1 xsd:dateTime
</td>
    <td>
The death date of an animal.
</td>
  </tr>
  <tr>
    <td>
s4agri:hasID exactly 1 s4agri:ID
</td>
    <td>
The unique identifier of an animal.
</td>
  </tr>
  <tr>
    <td>
s4agri:isLocatedIn some geo:Feature
</td>
    <td>
The physical location of an animal.
</td>
  </tr>
  <tr>
    <td>
s4agri:isMemberOf some s4agri:AnimalGroup
</td>
    <td>
An animal can be part of groups.
</td>
  </tr>
  <tr>
    <td>
s4agri:name max 1 xsd:string
</td>
    <td>
The name of an animal.
</td>
  </tr>
  <tr>
    <td>

</td>
    <td>

</td>
  </tr>
  <tr>
    <td>
<strong>s4agri:AnimalGroup</strong>
</td>
    <td>

</td>
  </tr>
  <tr>
    <td>
s4agri:hasMember some s4agri:Animal
</td>
    <td>
The members of an AnimalGroup.
</td>
  </tr>
  <tr>
    <td>
s4agri:receives some s4agri:Intake
</td>
    <td>
The intake/consumption of an AnimalGroup.
</td>
  </tr>
  <tr>
    <td>
s4agri:generates some s4agri:Yield
</td>
    <td>
The yield generated by an AnimalGroup.
</td>
  </tr>
  <tr>
    <td>
s4agri:isLocatedIn some geo:Feature
</td>
    <td>
The physical location of an AnimalGroup.
</td>
  </tr>
  <tr>
    <td>
s4agri:name max 1 xsd:string
</td>
    <td>
The name of an AnimalGroup.
</td>
  </tr>
  <tr>
    <td>

</td>
    <td>

</td>
  </tr>
  <tr>
    <td>
<strong>s4agri:Crop</strong>
</td>
    <td>

</td>
  </tr>
  <tr>
    <td>
obo:TAXRANK_1000000 some obo:TAXRANK_0000000
</td>
    <td>
The taxonomic ranking using TAXRANK. 
</td>
  </tr>
  <tr>
    <td>
s4agri:receives some s4agri:Intake
</td>
    <td>
The intake/consumption of certain substances in a Crop.
</td>
  </tr>
  <tr>
    <td>
s4agri:generates some s4agri:Yield
</td>
    <td>
The yield generated by a Crop.
</td>
  </tr>
  <tr>
    <td>
s4agri:hasPlantDate some xsd:DateTime
</td>
    <td>
The day the crop is planted. 
</td>
  </tr>
  <tr>
    <td>
s4agri:hasHarvestDate some xsd:DateTime
</td>
    <td>
The day the crop is harvested. 
</td>
  </tr>
  <tr>
    <td>

</td>
    <td>

</td>
  </tr>
  <tr>
    <td>
<strong>s4agri:Parcel</strong>
</td>
    <td>

</td>
  </tr>
  <tr>
    <td>
s4agri:contains some s4agri:Crop
</td>
    <td>
A parcel can contain some crops. 
</td>
  </tr>
  <tr>
    <td>
s4agri:name max 1 xsd:string
</td>
    <td>
The name of a parcel.
</td>
  </tr>
</table>



### Device


SAREF4AGRI extends the device hierarchy defined in SAREF in order to include devices needed to support the livestock farming and the smart irrigation use cases. These devices are shown in Figure 5. The devices included for the Smart Irrigation use case are: `s4agri:Pluviometer`, `s4agri:SoilTensiometer`, `s4agri:WeatherStation,` and `s4agri:WateringGun`. The devices included for the Livestock Farming use case are: `s4agri:MovementActivitySensor`, `EatingActivitySensor`, `s4agri:MilkingSensor,` and `s4agri:WeightSensor`.


<figure>
        <img data-docx-width="8.34cm" src="diagrams/Device.png" alt="Device hierarchy"/>
        <figcaption>Figure 5: Device hierarchy</figcaption>
    </figure>

### Property


SAREF4AGRI extends the property hierarchy defined in SAREF in order to include properties needed to support the livestock farming and the smart irrigation use cases. These devices are shown in Figure 6. The properties included for the smart irrigation use case are: `s4agri:SoilMoisture, s4agri:IrrigationWater, s4agri:SoilTemperature, s4agri:AirTemperature, s4agri:AmbientHumidity, s4agri:Precipitation` and `s4agri:PlantGrowthStage.`


The properties included for the livestock farming use case are: `s4agri:Yield` (which can further be specialized in subclasses, such as MilkYield, CropYield, MeatYield, MilkYield, etc. as needed) and `s4agri:Intake` (which can further be specialized in subclasses, such as FoodIntake for animals, FertilizerIntake for crops, etc. as needed). 


<figure>
        <img data-docx-width="8.08cm" src="diagrams/Property.png" alt="Property hierarchy"/>
        <figcaption>Figure 6: Property hierarchy</figcaption>
    </figure>


Table 5 summarizes the definitions of the classes described above.


<table data-docx-preferred-width="4.24cm 12.74cm">
  <caption>Table 5: Intake and Yield: class definitions</caption>
  <tr>
    <th>
Class
</th>
    <th>
Definition
</th>
  </tr>
  <tr>
    <td>
s4agri:Intake
</td>
    <td>
The amount of food or other substance taken into the body of an animal or into the soil.
</td>
  </tr>
  <tr>
    <td>
s4agri:Yield
</td>
    <td>
The produced amount of food for animals or of agricultural products.
</td>
  </tr>
  <tr>
    <td>
s4agri:SoilMoisture
</td>
    <td>
The amount of water or humidity contained in the soil.
</td>
  </tr>
  <tr>
    <td>
s4agri:IrrigationWater
</td>
    <td>
The amount of water falling in the soil by irrigation methods.
</td>
  </tr>
  <tr>
    <td>
s4agri:Precipitation
</td>
    <td>
The amount of water falling in the soil by natural process (e.g. rain).
</td>
  </tr>
  <tr>
    <td>
s4agri:PlantGrowthStage
</td>
    <td>
The level or stage of growth of the plant.
</td>
  </tr>
  <tr>
    <td>
s4agri:AmbientHumidity
</td>
    <td>
The amount of water vapour in the air.
</td>
  </tr>
  <tr>
    <td>
s4agri:AirTemperature
</td>
    <td>
The degree or intensity of heat present in the air.
</td>
  </tr>
  <tr>
    <td>
s4agri:SoilTemperature
</td>
    <td>
The degree or intensity of heat present in the soil.
</td>
  </tr>
</table>



### Topology


SAREF4AGRI adopts the same topology modelling pattern that is adopted in the SAREF4CITY extension [i.3], where existing standard ontologies have been reused for this purpose. As shown in Figure 7, for representing spatial objects in SAREF4AGRI, the `geosp:SpatialObject` class from GeoSPARQL has been reused along with its subclasses `geosp:Feature`, `geosp:Geometry` and the properties `geosp:sfContains`, `geosp:sfWithin` and `geosp:hasGeometry`. In addition, the class `geo:Point` and the property `geo:location` have been reused from the "WGS84 Geo Positioning vocabulary" (which is the W3C de-facto standard for geographical information) in order to be able to indicate that something is located at certain coordinates. 


<figure>
        <img data-docx-width="8.80cm" src="diagrams/Topology.png" alt="Topology model"/>
        <figcaption>Figure 7: Topology model</figcaption>
    </figure>


For the purpose of SAREF4AGRI, the `geosp:Feature` class has been extended with the following subclasses: 

* the s4agri:Farm
* the s4agri:Building
* the s4agri:BuildingSpace
* the s4agri:Parcel

A `s4agri:Farm` can contain one or more `s4agri:Building` and `s4agri:Parcel` (via the `geosp:sfContains` relation). Note that these types of feature are used in the present document as examples, but more feature types (and building types) can be added as needed. Moreover, a `s4agri:Building` can be further decomposed in one or more `s4agri:BuildingSpaces` (once again via the `geosp:sfContains` relation). As subclasses of `geosp:Feature`, all the classes mentioned above inherit the possibility to have a physical geometric description using `geosp:Geometry`, if needed (e.g. especially relevant for `s4agri:Parcel`). As subclasses of `geosp:SpatialObject`, all the classes mentioned above also inherit the possibility to use the `geo:location` property to indicate that something is located at certain coordinates (e.g. especially relevant for `s4agri:Bulding`). 

### Person and Organization


As it is modelled in the SAREF4CITY extension [i.3], also SAREF4AGRI reuses the FOAF vocabulary (http://xmlns.com/foaf/0.1/) and Schema.org vocabulary ([https://schema.org/](https://schema.org/)) to represent the concepts of Person and Organization. Figure 8 shows that in SAREF4AGRI the `foaf:Person` and `org:Organization` classes are extended with the `s4agri:Farmer` and `s4agri:FarmHolding` subclasses to describe farmers and their organizations. Both `foaf:Person` and `org:Organization` are subclass of `foaf:Agent`. Organizations (e.g. `s4agri:FarmHolding)` have members (e.g. farmers). Both `s4agri:Farmer` and `s4agri:FarmHolding` can manage some `s4agri:Farm`. 


<figure>
        <img data-docx-width="8.80cm" src="diagrams/Person.png" alt="Person and Organization model"/>
        <figcaption>Figure 8: Person and Organization model</figcaption>
    </figure>
