# Approach


To create the SAREF4AGRI extension specified in the present document, a combination of bottom-up and top-down approaches was followed. First, the SAREF4AGRI extension has been developed bottom-up from a set of requirements extracted from the livestock farming and smart irrigation examples (also considering existing ontologies in the sector, such as the Common Dairy Ontology in [i.4]). Note that although various other examples exist in the AgriFood sector (such as arable farming, horticulture, agricultural equipment, greenhouses, food chain, etc.), it was necessary to make actionable choices within the STF 534 timeframe and the available resources, therefore livestock farming and smart irrigation have been chosen as the two initial examples to create SAREF4AGRI. 


As a second step, following a top-down approach, the SAREF4AGRI extension development has been driven by reuse in order to connect SAREF with already existing ontologies (such as SOSA, SSN, FOAF, Schema.org, GeoSPARQL and WGS84). 


Afterwards, following the process defined in [i.1], the ontological engineers with the support of domain experts considered existing AgriFood standards (e.g. ICAR, ISOBUS, etc.) and vocabularies (e.g. TAXRANK). A list of the considered standards is detailed in [i.2]. Finally, an initial version of the ontological requirements for SAREF4AGRI was proposed, which was then refined together with domain experts in order to obtain a stable version of the requirements and create SAREF4AGRI. 


As mentioned, SAREF concepts and properties have been reused and extended. The following classes and properties have been directly reused from SAREF:

* saref:Device
* saref:Measurement
* saref:Property
* saref:makesMeasurement
* saref:relatesToMeasurement
* saref:isMeasuredIn

The following classes and properties have been reused in SAREF4AGRI to complete the model of measurements:

* `saref:FeatureOfInterest` to define the feature of interest being observed in a certain measurement.
* `saref:isPropertyOf` (and its inverse `saref:hasProperty)` to link the property being observed with the feature of interest.
* `saref:hasFeatureOfInterest` (and its inverse `saref:isFeatureOfInterestOf`) to link a given measurement with the feature of interest being observed.
* `saref:measurementMadeBy` as complement of the `saref:makesMeasurement`, as its inverse, to link a measurement and the device that produces it.

The following classes and properties have been directly reused from FOAF:

* foaf:Agent
* foaf:Person
* foaf:member

The following classes and properties have been directly reused from Schema.org:

* org:Organization

The following classes and properties have been directly reused from GeoSPARQL:

* geosp:SpatialObject
* geosp:Feature
* geosp:Geometry 
* geosp:sfContains

The following classes and properties have been directly reused from WGS84:

* geo:Point
* geo:location

The following classes and properties have been directly reused from SOSA:

* sosa:Platform

The following classes and properties have been directly reused from SSN:

* ssn:System
* ssn:deployedOnPlatform 
* ssn:deployedSystem
* ssn:Deployment

Finally, the Time ontology ([http://www.w3.org/2006/time](http://www.w3.org/2006/time)), which is already reused by SAREF, has also been reused in SAREF4AGRI.


As a next step, it is recommended to further refine the livestock farming and smart irrigation examples to add relevant sensors that are not considered yet, and also consider additional use cases to create new releases of SAREF4AGRI, following and extending the examples provided in the present document. As all the SAREF ontologies, SAREF4AGRI is a dynamic semantic model that is meant to evolve over time. Therefore, the stakeholders in the AgriFood domain (starting from the ICAR, AEF and AgGateway initiatives) are invited to use, validate and provide feedback on SAREF4AGRI, collaborating with the SAREF ontology experts to improve and evolve SAREF4AGRI in an iterative and interactive manner, so that changes and additions can be incorporated in future releases of the present document. 


# Bibliography

* ETSI TS 103 267 (V2.1.1) (2020-02): "SmartM2M; Smart Applications; Communication Framework".
* ETSI TS 102 689 (V1.1.1) (2010-08): "Machine-to-Machine communications (M2M); M2M Service Requirements".

