# SAREF4AGRI ontology and semantics

## Introduction and overview


The present document has been developed in the context of the STF 534, an ETSI specialists task force that was established with the goal to extend SAREF [1] for the domains of Smart Cities, Smart Industry & Manufacturing, and Smart AgriFood ([https://portal.etsi.org/STF/stfs/STFHomePages/STF534](https://portal.etsi.org/STF/stfs/STFHomePages/STF534)). In particular, the present document is a technical specification of SAREF4AGRI, an OWL-DL ontology that extends SAREF for the Smart Agriculture and Food Chain domain. The intention of SAREF4AGRI is to connect SAREF with existing ontologies (such as W3C SSN, W3C SOSA, GeoSPARQL, etc.) and important standardization initiatives and ontologies in the Smart Agriculture and Food Chain domain, including ICAR for livestock data ([https://www.icar.org/](https://www.icar.org/)), AEF for agricultural equipment ([http://www.aef-online.org](http://www.aef-online.org)), Plant Ontology Consortium for plants ([http://archive.plantontology.org](http://archive.plantontology.org)), AgGateway for IT support for arable farming ([http://www.aggateway.org/](http://www.aggateway.org/)), as mentioned in the associated SAREF4AGRI requirements document ETSI TR 103 511 [i.2].


To show the potential of SAREF4AGRI, the present document focuses on two examples, which are the "livestock farming" and "smart irrigation" use cases. Various other examples exist in the Smart Agriculture and Food Chain domain, such as arable farming, horticulture, agricultural equipment, greenhouses and food chain, as mentioned in [i.2] (for an exhaustive list of use cases, see also the H2020 Large Scale Pilot "Internet of Food and Farm 2020 (IoF2020)" at [https://iof2020.eu/trials](https://iof2020.eu/trials)). However, it was necessary to make actionable choices within the STF 534 timeframe and the available resources, thus livestock farming and smart irrigation have been chosen as the two initial examples to create SAREF4AGRI. As a next step, it is recommended to further refine the proposed livestock farming and smart irrigation examples to add relevant sensors that are not considered yet, and also consider additional use cases to create new releases of SAREF4AGRI, following and extending the examples provided in the present document. As all the SAREF ontologies, SAREF4AGRI is a dynamic semantic model that is meant to evolve over time. Therefore, the stakeholders in the AgriFood domain (starting from the ICAR, AEF and AgGateway initiatives) are invited to use, validate and provide feedback on SAREF4AGRI, collaborating with the SAREF ontology experts to improve and evolve SAREF4AGRI in an iterative and interactive manner, so that changes and additions can be incorporated in future releases of the present document.


The livestock farming and smart irrigation use cases used as basis to create SAREF4AGRI in the present document are concerned with the integration of multiple data sources for the purpose of providing decision support services located on the local "Farm Management System" of the farmers or provided by a service over the network. Multiple data sources of interest include GPS, meteorological data (both historic and current), remote observation (via satellite sources such as Copernicus) and local observation using near or proximal sensors. As an extension of SAREF, which is a semantic model for IoT that describes smart devices and applications in terms of their functions, services, states and measurements [1], SAREF4AGRI is concerned with the description of proximal sensors that measure a variety of relevant parameters for agriculture, including: (on animal) movement, temperature, etc., (in the soil) moisture/humidity, Ph value, salinity, compaction, (on plant) plant colour (NDVI), etc. The measurements from these sensors need to be integrated by a decision support service to enable the planning of (for example) a treatment plan for animals (in a livestock scenario), or a decision to irrigate or harvest (in an irrigation, horticulture or greenhouse context). The requirements used to create the SAREF4AGRI extension specified in the present document are described in the associated ETSI TR 103 511 [i.2].


The prefixes and namespaces used in SAREF4AGRI and in the present document are listed in Table 1.

{{table_1}}
