#!/usr/bin/perl -w

## the next line should point to the perl.exe executable when executed on windows.
## it should replace the first line
#!C:/Perl64/bin/perl.exe

# script written by: maxime.lefrancois@emse.fr
use strict;
use warnings;
use Try::Tiny;

print "Content-type: text/html\n\n";

my %h = ( "html" => "text/html",
  "ttl" => "text/turtle" ,
  "rdf" => "application/rdf+xml" ,
  "jsonld" => "application/ld+json" ,
  "n3" => "application/n3" ,
  "nt" => "application/n-triples" ,
  );


try {
  "$ENV{\"DOCUMENT_ROOT\"}$ENV{\"REDIRECT_URL\"}" =~ /^(.*\/)([^\/]+)$/ ;
  my $DIR = $1;
  my $filename = $2;
  opendir(DIR, $1 ) or die "opendir() failed: $!";
  my @files = grep(/^$filename\.[^\.]+$/,readdir(DIR));
  closedir(DIR);
  foreach my $file (@files) {
    $file =~ /^$filename\.([^\.]+)$/;
    my $ext = $1;
    print " <li><a href=\"$ENV{\"REDIRECT_URL\"}.$1\">$filename.$ext</a>, type $h{$ext}</li>\n";
  }
} catch {
  "$ENV{\"DOCUMENT_ROOT\"}$ENV{\"REDIRECT_URL\"}" =~ /^(.*\/)([^\/]+)$/ ;
  my $DIR = $1;
  my $filename = $2;
  print "<li><a href=\"$ENV{\"REDIRECT_URL\"}.html\">$filename.html</a>, type text/html (probably?)</li>\n";
  print "<li><a href=\"$ENV{\"REDIRECT_URL\"}.ttl\">$filename.ttl</a>, type text/turtle (maybe?)</li>\n";
  print "<li><a href=\"$ENV{\"REDIRECT_URL\"}.rdf\">$filename.rdf</a>, type application/rdf+xml (feeling lucky?)</li>\n";
};