docker.SHACL.validation.configuration.txt::

SHACL Validation server notes: See ShaclValidationManager.java
 Support per validation type of loading the imports defined in the input that can also be set by users at validation time.
 Support for querying SPARQL endpoints to retrieve the content to validate.
 Remote SHACL shape caching: Caching is used to avoid constant lookups of remote SHACL shape files. 
 Once loaded, remote SHACL shape files will be automatically refreshed every hour.

Docker development configuration::https://www.itb.ec.europa.eu/docs/guides/latest/installingTheTestBed/
These steps are for the specific validator, not the generic one that is in actual use.
Step 1: Install Docker Community Edition & Docker Compose from https://docs.docker.com/desktop/install/ubuntu/
    docker --version => Docker version 26.0.0, build 2ae903e
    docker compose version => Docker Compose version v2.25.0
Step 2: Define the test bed’s configuration:
    mkdir ~/dev/testbed && cd ~/dev/testbed && touch docker-compose.yml 
    sudo groupadd docker && sudo usermod -aG docker ${USER} && sudo chmod 666 /var/run/docker.sock
    sudo ufw allow 8080/tcp && sudo ufw status verbose   (Later: sudo netstat -lnp --tcp --udp)
Step 3:     REST interface: http://localhost:8080/shacl/DOMAIN/api/validate    DOMAIN={Commodity|Ontology} 
    Parameter   Verb    Description                                                         Example
    validate    POST    Validate one RDF instance. Request payload type: application/json.  http://localhost:8080/shacl/Ontology/api/validate <payload>
Step 4: Test your installation: browse to http://localhost:9000/    => test@test.com / test => })cdVZP8>=}wZFa  <adminPassword>
Step 5: Docker commands to manage the test bed: 
    docker build -t local/OntologyValidator .                                   # this binds the specific validator to the shapes configuration. NOT USED!
    docker run -d --name SAREFvalidator -p 8080:8080 isaitb/shacl-validator     # this runs the general validator.


Generic Validator Dockerfile::
FROM isaitb/shacl-validator:latest
COPY resources /validator/resources/
ENV validator.resourceRoot /validator/resources/

Docs for RDF validator: https://www.itb.ec.europa.eu/docs/guides/latest/validatingRDF/index.html
Base docker image: https://hub.docker.com/r/isaitb/shacl-validator
Use Swagger UI for testing: http://localhost:8080/shacl/swagger-ui/index.html#/{domain}/api/validate
                            http://localhost:8080/shacl/swagger-ui.html 

~/dockerls.sh: sudo docker image ls && sudo docker volume ls && sudo docker container ls && sudo docker network ls
    !!! images !!!
    REPOSITORY                TAG       IMAGE ID       CREATED       SIZE
    local/ontologyvalidator   latest    8b929e2a947c   3 hours ago   436MB  # THIS ONE IS NOT USED!
    isaitb/shacl-validator    latest    723eca0b679b   2 weeks ago   436MB  # THIS ONE IS USED!
    !!! volumes !!!
    DRIVER    VOLUME NAME
    !!! containers !!!
    CONTAINER ID   IMAGE                     COMMAND                  CREATED       STATUS       PORTS                                       NAMES
    d9daf40eed08   local/ontologyvalidator   "java -XX:+ExitOnOut…"   3 hours ago   Up 3 hours   0.0.0.0:8080->8080/tcp, :::8080->8080/tcp   SAREFvalidator
    !!! networks !!!
    NETWORK ID     NAME      DRIVER    SCOPE
    4a98c5692963   bridge    bridge    local
    f02e9cbf7d1d   host      host      local
    631ce42d72e6   none      null      local


