package fr.mines_stetienne.ci.saref;

import org.slf4j.Logger;

import fr.mines_stetienne.ci.saref.entities.SAREFProject;
import fr.mines_stetienne.ci.saref.entities.SAREFRepository;
import fr.mines_stetienne.ci.saref.entities.SAREFVersion;
import fr.mines_stetienne.ci.saref.entities.SAREFVersionName;
import fr.mines_stetienne.ci.saref.managers.RepositoryManager;

public class SAREFRepositoryVersionErrorLogger extends SAREFErrorLogger {
	
	protected final RepositoryManager repositoryManager;
	protected final SAREFRepository repository;
	protected final SAREFProject project;
	protected final String branch;
	protected final SAREFVersion version;
	protected final SAREFVersionName versionName;

	public SAREFRepositoryVersionErrorLogger(RepositoryManager repositoryManager, Logger logger) {
		super(repositoryManager.getPipeline(), logger);
		this.repositoryManager = repositoryManager;
		this.repository = repositoryManager.getRepository();
		this.project = repository.getProject();
		this.branch = repositoryManager.getCurrentBranch();
		this.version = repositoryManager.getCurrentVersion();
		this.versionName = repositoryManager.getCurrentVersionName();
	}

}
