package fr.mines_stetienne.ci.saref.entities;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;

public class SAREFNamedGraph {

	protected final String iri;
	protected final Resource resource;
	protected final Model model;
	
	public SAREFNamedGraph(String iri) {
		this.iri = iri;
		this.model = ModelFactory.createDefaultModel();
		this.resource = ResourceFactory.createResource(iri);
	}
	
	public final String getIRI() {
		return iri;
	}

	public final Resource getResource() {
		return resource;
	}

	public final Model getModel() {
		return model;
	}

	@Override
	public final int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((iri == null) ? 0 : iri.hashCode());
		return result;
	}

	@Override
	public final boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SAREFNamedGraph other = (SAREFNamedGraph) obj;
		if (iri == null) {
			if (other.iri != null)
				return false;
		} else if (!iri.equals(other.iri))
			return false;
		return true;
	}

}
