/*
 * Copyright 2020 ETSI
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package fr.mines_stetienne.ci.saref.checkers;

import fr.mines_stetienne.ci.saref.SAREF;
import fr.mines_stetienne.ci.saref.SAREFPipelineException;
import fr.mines_stetienne.ci.saref.SAREFPipeline.Mode;
import fr.mines_stetienne.ci.saref.managers.RepositoryManager;

/**
 * Checks TS 103 673 Clause 9.4.3.2: Documentation metadata
 * 
 */
public class Clause_9_4_3_2_Checker extends AbstractShaclChecker {

	private static enum MESSAGE implements MessageResource {
		title1, title2, title3, abstract1, abstract2, description1, description2, issued1, issued2, modified1,
		modified2, source, seeAlso, license, publisher;
	}

	public Clause_9_4_3_2_Checker(RepositoryManager repositoryManager) throws SAREFPipelineException {
		super(repositoryManager, Clause_9_4_3_2_Checker.class);
	}

	protected final void updateShapeModel() {
		add(MESSAGE.title1);
		add(MESSAGE.title2);
		add(MESSAGE.title3);
		add(MESSAGE.abstract1);
		add(MESSAGE.abstract2);
		add(MESSAGE.description1);
		add(MESSAGE.description2);
		add(MESSAGE.issued1);
		add(MESSAGE.issued2);
		add(MESSAGE.modified1);
		add(MESSAGE.modified2);
		String source = String.format("%s%s/", SAREF.FORGE, version.getRepository().getProject().getRepositoryName());
		add(exactly(source), MESSAGE.source, source);
		add(MESSAGE.seeAlso);
		add(exactly(SAREF.LICENSE), MESSAGE.license);
		add(exactly(SAREF.PUBLISHER), MESSAGE.publisher);

		if (pipeline.mode == Mode.DEVELOP) {
			remove(MESSAGE.issued1);
			remove(MESSAGE.issued2);
			remove(MESSAGE.modified1);
			remove(MESSAGE.modified2);
			remove(MESSAGE.source);
			remove(MESSAGE.seeAlso);
		}
	}

}