/*
 * Copyright 2020 ETSI
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package fr.mines_stetienne.ci.saref.tests;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

import fr.mines_stetienne.ci.saref.SAREF;
import fr.mines_stetienne.ci.saref.SAREFPipelineException;
import fr.mines_stetienne.ci.saref.tests.TestCase.Status;

/**
 * Appends to a TestSuites
 * 
 * @author maxime.lefrancois
 *
 */
public class TestSuitesAppender extends AppenderSkeleton {

	private TestSuites testSuites;

	/**
	 * Instantiate a TestSuitesAppender
	 */
	public TestSuitesAppender(TestSuites testSuites) {
		this.testSuites = testSuites;
	}

	/**
	 * This method is called by the {@link AppenderSkeleton#doAppend} method.
	 * 
	 */
	public void append(LoggingEvent event) {
		Level level = event.getLevel();
		if(level.isGreaterOrEqual(Level.INFO)) {
			String loggerName = event.getLoggerName().substring(SAREF.LOGGER_BASE.length()+1);
			TestSuite testSuite = testSuites.get(loggerName);
			String msg = event.getMessage() == null ? "" : event.getMessage().toString();
			TestCase testCase = new TestCase(msg);
			if(level.equals(Level.WARN)) {
				testCase.setStatus(Status.FAILURE);
				ThrowableInformation info = event.getThrowableInformation();
				if(info!=null) {
					Throwable throwable = info.getThrowable();
					String type = getType(throwable);
					String message = throwable.getMessage();
					testCase.setFailure(type, message);
					setSystemErr(testCase, event);
				}
			}
			if(level.equals(Level.ERROR)) {
				testCase.setStatus(Status.ERROR);
				ThrowableInformation info = event.getThrowableInformation();
				if(info!=null) {
					Throwable throwable = info.getThrowable();
					String type = getType(throwable);
					String message = throwable.getMessage();
					testCase.setError(type, message);
					setSystemErr(testCase, event);
				}
			}
			testSuite.addTestcase(testCase);
		}
	}

	private String getType(Throwable throwable) {
		if(throwable instanceof SAREFPipelineException) {
			SAREFPipelineException exception = (SAREFPipelineException) throwable;
			return exception.getType();
		} else {
			return throwable.getClass().getSimpleName();
		}
	}

	private void setSystemErr(TestCase testCase, LoggingEvent event) {
		testCase.setSystemErr(String.join("\n", event.getThrowableStrRep()));
	}

	public synchronized void close() {
		if (this.closed)
			return;
		this.closed = true;
	}

	public boolean requiresLayout() {
		return false;
	}


}
