/*
 * Copyright 2020 ETSI
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package fr.mines_stetienne.ci.saref.checkers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.stream.Collectors;

import fr.mines_stetienne.ci.saref.SAREF;
import fr.mines_stetienne.ci.saref.SAREFPipelineException;
import fr.mines_stetienne.ci.saref.managers.RepositoryManager;

/**
 * Checks TS 103 673 Clause 9.8.1.1: The vocabularies directory.
 * 
 */
public class Clause_9_8_1_1_Checker extends AbstractClauseChecker {

	private enum MESSAGE {
		directories, one, ttl, turtle, write_error
	}

	public Clause_9_8_1_1_Checker(RepositoryManager repositoryManager) {
		super(repositoryManager, Clause_9_8_1_1_Checker.class);
	}

	@Override
	public void checkClause() throws SAREFPipelineException {
		try {
			File dir = new File(repository.getDirectory(), "vocabularies");
			/*String directories = Files.walk(dir.toPath()).filter(p -> {
				try {
					return p.toFile().isDirectory() && !Files.isSameFile(dir.toPath(), p);
				} catch(IOException ex) {
					return false;
				}
			}).map(p -> p.toString()).collect(Collectors.joining(", "));
			if(directories.isEmpty()) {
				logError(getMessage(MESSAGE.directories, directories));
			}*/

			String nonTtl = Files.walk(dir.toPath(), 1).filter(p -> {
				try {
					return p.toFile().isFile() && !SAREF.TTL_MATCHER.matches(p) && !p.toFile().getName().startsWith(".");
				} catch (Exception ex) {
					return false;
				}
			}).map(p -> p.getFileName().toString()).collect(Collectors.joining(", "));
			if(nonTtl.length()>0) {
				logError(getMessage(MESSAGE.ttl, nonTtl));
			}

		} catch (IOException ex) {
			throw new SAREFPipelineException(ex);
		}
	}

}
