/*
 * Copyright 2020 ETSI
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package fr.mines_stetienne.ci.saref.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import fr.mines_stetienne.ci.saref.SAREF;
import fr.mines_stetienne.ci.saref.SAREFPipeline.Mode;

public class FunctionalitiesPanel extends JPanel {
	
	final MainFrame mainFrame;
	final JButton start;
	final JButton fileChooser;
	final JRadioButton develop;
	final JRadioButton release;
	final JRadioButton prerelease_portal;
	final JRadioButton release_portal;
	final JCheckBox ignoreSite;
	final JCheckBox ignoreExamples;
	final JCheckBox ignoreTerms;
	final JCheckBox ignoreDocumentation;

	public FunctionalitiesPanel(MainFrame mainFrame) {
		super();
		this.mainFrame = mainFrame;
		
		fileChooser = new JButton(SAREF.getMessage("directory"));
		add(fileChooser);
		
		develop = new JRadioButton(SAREF.getMessage("develop"), true);
		develop.setToolTipText(SAREF.getMessage("develop_tooltip"));
		develop.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if(develop.isSelected()) {
					mainFrame.setMode(Mode.DEVELOP);
				}
			}
		});
		release = new JRadioButton(SAREF.getMessage("release"));
		release.setToolTipText(SAREF.getMessage("release_tooltip"));
		release.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if(release.isSelected()) {
					mainFrame.setMode(Mode.RELEASE);
				}
			}
		});
		prerelease_portal = new JRadioButton(SAREF.getMessage("prerelease_portal"));
		prerelease_portal.setToolTipText(SAREF.getMessage("prerelease_portal_tooltip"));
		prerelease_portal.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if(prerelease_portal.isSelected()) {
					mainFrame.setMode(Mode.PRERELEASE_PORTAL);
				}
			}
		});
		release_portal = new JRadioButton(SAREF.getMessage("release_portal"));
		release_portal.setToolTipText(SAREF.getMessage("release_portal_tooltip"));
		release_portal.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				if(release_portal.isSelected()) {
					mainFrame.setMode(Mode.RELEASE_PORTAL);
				}
			}
		});
		ButtonGroup modeGroup = new ButtonGroup();
		modeGroup.add(develop);
		modeGroup.add(release);
		modeGroup.add(prerelease_portal);
		modeGroup.add(release_portal);
		JPanel panel2 = new JPanel();
		panel2.setLayout(new BoxLayout(panel2, BoxLayout.Y_AXIS));
		panel2.add(new JLabel(SAREF.getMessage("modes")));
		panel2.add(develop);
		panel2.add(release);
		panel2.add(prerelease_portal);
		panel2.add(release_portal);
		add(panel2);
		
		ignoreSite = new JCheckBox(SAREF.getMessage("ignoreSite"), false);
		ignoreSite.setToolTipText(SAREF.getMessage("ignoreSite_tooltip"));
		ignoreSite.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				mainFrame.setIgnoreSite(ignoreSite.isSelected());
			}
		});

		ignoreExamples = new JCheckBox(SAREF.getMessage("ignoreExamples"), false);
		ignoreExamples.setToolTipText(SAREF.getMessage("ignoreExamples_tooltip"));
		ignoreExamples.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				mainFrame.setIgnoreExamples(ignoreExamples.isSelected());
			}
		});

		ignoreTerms = new JCheckBox(SAREF.getMessage("ignoreTerms"), false);
		ignoreTerms.setToolTipText(SAREF.getMessage("ignoreTerms_tooltip"));
		ignoreTerms.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				mainFrame.setIgnoreTerms(ignoreTerms.isSelected());
			}
		});

		ignoreDocumentation = new JCheckBox(SAREF.getMessage("ignoreDocumentation"), false);
		ignoreDocumentation.setToolTipText(SAREF.getMessage("ignoreDocumentation_tooltip"));
		ignoreDocumentation.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				mainFrame.setIgnoreDocumentation(ignoreDocumentation.isSelected());
			}
		});

		JPanel panel3 = new JPanel();
		panel3.setLayout(new BoxLayout(panel3, BoxLayout.Y_AXIS));
		panel3.add(new JLabel(SAREF.getMessage("options")));
		panel3.add(ignoreSite);
		panel3.add(ignoreExamples);
		panel3.add(ignoreTerms);
		panel3.add(ignoreDocumentation);
		add(panel3);

		start = new JButton(SAREF.getMessage("run"));
		start.setEnabled(false);
		add(start);
	}
	
	public void setEnabled() {
		start.setEnabled(true);
	}

	public void addStartActionListener(ActionListener fileChooserAction) {
		start.addActionListener(fileChooserAction);
	}

	public void addFileChooserActionListener(ActionListener fileChooserAction) {
		fileChooser.addActionListener(fileChooserAction);
	}


}
