/*
 * Copyright 2020 ETSI
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package fr.mines_stetienne.ci.saref.tests;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

/**
 * @author Omar Qawasmeh
 */
@XmlRootElement(name = "testcase")
@XmlType(propOrder = { "name", "status", "error", "failure", "systemErr", "systemOut" })
public class TestCase {

	@XmlAttribute
	private String name = "";

	@XmlTransient
	private String status = "success";

	@XmlElement
	private Error error;

	@XmlElement
	private Error failure;

	@XmlTransient
	private String systemErr;

	@XmlTransient
	private String systemOut;

	public TestCase() {
	}

	public TestCase(final String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	@XmlAttribute
	public String getStatus() {
		return status;
	}

	@XmlElement(name = "system-err")
	public String getSystemErr() {
		return systemErr;
	}

	public void setSystemErr(String systemErr) {
		this.systemErr = systemErr;
	}

	@XmlElement(name = "system-out")
	public String getSystemOut() {
		return systemOut;
	}

	public void setSystemOut(String systemOut) {
		this.systemOut = systemOut;
	}

	public void setStatus(Status status) {
		this.status = status.getName();
	}

	public void setError(String type, String message) {
		this.error = new Error(type, message);
		this.status = "error";
	}

	public boolean isError() {
		return status.equals(Status.ERROR.getName());
	}

	public void setFailure(String type, String message) {
		this.failure = new Error(type, message);
		this.status = "failure";
	}

	public boolean isFailure() {
		return status.equals(Status.FAILURE.getName());
	}

	public String getErrorType() {
		if (error != null) {
			return error.getType();
		}
		return null;
	}

	public String getErrorMessage() {
		if (error != null) {
			return error.getMessage();
		}
		return null;
	}

	public String getFailureType() {
		if (failure != null) {
			return failure.getType();
		}
		return null;
	}

	public String getFailureMessage() {
		if (failure != null) {
			return failure.getMessage();
		}
		return null;
	}

	@XmlRootElement(name = "error")
	private static class Error implements Serializable {

		@XmlAttribute
		private String type;

		@XmlAttribute
		private String message;

		public Error() {
		}

		private Error(String type, String message) {
			this.type = type;
			this.message = message;
		}

		public String getType() {
			return type;
		}

		public String getMessage() {
			return message;
		}
	}

	public static enum Status {
		SUCCESS, FAILURE, ERROR;

		public String getName() {
			return toString().toLowerCase();
		}
	}

}
