/*
 * Copyright 2020 ETSI
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package fr.mines_stetienne.ci.saref.gui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;

import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class InfoPanel extends JPanel {

	private final JEditorPane directoryLabel = new JEditorPane("text/html", "<html><i>Please select a directory first</i></html>");
	
	public InfoPanel() {

		setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		HyperlinkListener listener = new HyperlinkListener() {
			@Override
			public void hyperlinkUpdate(HyperlinkEvent e) {
				if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
					if (Desktop.isDesktopSupported()) {
						try {
							Desktop.getDesktop().browse(e.getURL().toURI());
						} catch (Exception ex) {
						}
					}
				}
			}
		};

		JEditorPane jep = new JEditorPane("text/html",
				"<html>Runs the SAREF pipeline as specified in Technical Specification:<br>"
						+ "  ETSI TS 103 673 V1.1.1: \"SmartM2M; SAREF Development Framework and Workflow, Streamlining the Development of SAREF and its Extensions\"<br>"
						+ "<br>" + "The SAREF pipeline is part of the SAREF Development Framework\n"
						+ "  <a href=\"https://portal.etsi.org/STF/STFs/STF-HomePages/STF578\">https://portal.etsi.org/STF/STFs/STF-HomePages/STF578</a></html>");

		jep.addHyperlinkListener(listener);
		jep.setEditable(false);
		jep.setBackground(UIManager.getColor("Panel.foreground"));
		directoryLabel.addHyperlinkListener(listener);
		directoryLabel.setEditable(false);
		directoryLabel.setBackground(UIManager.getColor("Panel.foreground"));

		add(jep);
		add(directoryLabel);
	}

	public void setDirectory(File directory) {
		try {
			String url = directory.getCanonicalFile().getAbsolutePath();
			directoryLabel.setText(String.format("<html>Selected directory: <a href=\"%s\">%s</a></html>", url, url));
		} catch (IOException e) {
			String url = directory.getAbsolutePath();
			directoryLabel.setText(String.format("<html>Selected directory: <a href=\"%s\">%s</a></html>", url, url));
		}
	}

}
