/*
 * Copyright 2020 ETSI
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software without 
 *    specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package fr.mines_stetienne.ci.saref.tests;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * @author Omar Qawasmeh
 */
@XmlRootElement(name = "testsuite")
@XmlType(propOrder = { "name", "tests", "failures", "errors", "testCases" })
public class TestSuite implements Serializable {

	@XmlAttribute
	private String name = "";

	@XmlAttribute
	private int tests = 0;

	@XmlAttribute
	private int failures = 0;
	
	@XmlAttribute
	private int errors = 0;
	
	@XmlElement(name = "testcase")
	private List<TestCase> testCases = new ArrayList<>();
	
	private transient TestSuites testSuites;

	TestSuite() {}
	
	TestSuite(TestSuites testSuites, String name) {
		this.testSuites = testSuites;
		this.name = name;
	}
	
	public String getName() {
		return name;
	}

	public int getTests() {
		return tests;
	}

	public int getFailures() {
		return failures;
	}

	public int getErrors() {
		return errors;
	}

	public void addTestcase(TestCase testCase) {
		testCases.add(testCase);
		tests++;
		testSuites.tests++;
		if(testCase.isFailure()) {
			failures++;
			testSuites.failures++;
		}
		if(testCase.isError()) {
			errors++;
			testSuites.errors++;
		}
	}
	
	public List<TestCase> getTestCases() {
		return testCases;
	}
	
}