<div class="alert-warning">NOTE: The text in this section is extracted from ETSI TS 103 264 (V3.2.1) [[0]](#[0]), and therefore falls inside the <a href="https://www.etsi.org/intellectual-property-rights">ETSI IPR Policy</a></div> 

### <a id="5.1"></a>General Overview

<a href="#Figure_3">Figure 3</a> shows an overview of the main classes and properties of SAREF Core.

A detailed explanation of each class is presented in <a href="#5.2"/>clause 5.2</a> to <a href="#5.13"/>clause 5.13</a>.
 

<figure>
  <img src="diagrams/Overview_generic.png" alt="Overview of the SAREF ontology"/>
  <figcaption id="Figure_3">Figure 3: Overview of the SAREF ontology</figcaption>
</figure>

### <a id="5.2"></a>Feature kinds and features of interest

<a href="#Figure_4">Figure 4</a> illustrates the main classes and properties for feature kinds and features of interest. SAREF extensions and applications may create, specialize, and categorize feature kinds and features of interest as specified in ETSI TS 103 548 <a href="#[4]">[4], clause 5.2</a>.
 

<figure>
  <img src="diagrams/FeatureOfInterest.png" alt="Feature kinds and features of interest"/>
  <figcaption id="Figure_4">Figure 4: Feature kinds and features of interest</figcaption>
</figure>


Class [saref:FeatureOfInterest](#saref:FeatureOfInterest) represents any real world entity from which a property or a state may be acted upon, such as observed and controlled. An instance of [saref:FeatureOfInterest](#saref:FeatureOfInterest) represents one specific real world entity.


<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1:

```
<etsi_premises/athena> a saref:FeatureOfInterest ;
    rdfs:label "ATHENA amphitheatre"@en ;
	rdfs:comment "The ATHENA amphitheatre in the ETSI premises."@en .

<etsi_premises/athena/window5> a saref:FeatureOfInterest ;
    rdfs:label "ATHENA Window 5"@en ;
    rdfs:comment "Window 5 of ATHENA amphitheatre"@en .
```
</div>

Class [saref:FeatureKind](#saref:FeatureKind) allows to describe kinds of features of interest, with common properties having the same value, and common states being the same. An instance of [saref:FeatureKind](#saref:FeatureKind) represents an archetype of real world entities, for example to populate product catalogs.

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2:

```
<1000x2000mmWindowOrientedNorth> a saref:FeatureKind ;
    rdfs:label "1000x2000mm window oriented north"@en ;
    rdfs:comment "The kind of windows with dimensions 1000x2000mm and oriented north."@en .
```
</div>

Feature kinds can be organized in a taxonomy using OPs skos:narrower and skos:broader.

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3:

```
<1000x2000mmWindowOrientedNorth> a saref:FeatureKind ;
    skos:broader <1000x2000mmWindow> ;
    skos:broader <WindowOrientedNorth> .
```
</div>

A feature of interest can be linked to its kind(s) using OP [saref:hasFeatureKind](#saref:hasFeatureKind).

<div id="EXAMPLE_4" class="alert-info">EXAMPLE 4:

```
<etsi_premises/athena/window5>
 			saref:hasFeatureKind <1000x2000mmWindowOrientedNorth> .
```
</div>

<div class="alert-warning">NOTE: Feature of interest inherit broader feature kinds.

```
saref:hasFeatureKind o skos:broader ⊑ saref:hasFeatureKind
```
</div>

<div id="EXAMPLE_5" class="alert-info">EXAMPLE 5:

```
<etsi_premises/athena/window5>
    saref:hasFeatureKind <1000x2000mmWindow> ;
    saref:hasFeatureKind <WindowOrientedNorth> .
```
</div>

A feature kind (respectively a feature of interest) may consist of (OP [saref:consistsOf](#saref:consistsOf)) other feature kinds (respectively features of interest).

<div id="EXAMPLE_6" class="alert-info">EXAMPLE 6:

```
s4abcd:AAHeatPumpDryer a saref:FeatureKind ;
	saref:consistsOf s4abcd:HeatPump , s4abcd:AirCyclingCircuit , s4abcd:Dryer .
```
</div>

<div id="EXAMPLE_7" class="alert-info">EXAMPLE 7:

```
<etsi_premises/athena> a saref:FeatureOfInterest ;
 		saref:consistsOf <etsi_premises/stage> ;
 		saref:consistsOf <etsi_premises/athena/window5> .
```
</div>

Whenever appropriate, SAREF extensions and applications should also use the classes from SAREF4SYST to specify if a [saref:FeatureOfInterest](#saref:FeatureOfInterest) is a system ([s4syst:System](https://saref.etsi.org/saref4syst/#System)), a Connection between systems ([s4syst:Connection](https://saref.etsi.org/saref4syst/#Connection)), or a connection point of a system ([s4syst:ConnectionPoint](https://saref.etsi.org/saref4syst/#ConnectionPoint)).

The model and the manufacturer of a [saref:FeatureKind](#saref:FeatureKind) or a [saref:FeatureOfInterest](#saref:FeatureOfInterest) can be explicited using DPs [saref:hasModel](#saref:hasModel) and [saref:hasManufacturer](#saref:hasManufacturer), respectively. 

<div id="EXAMPLE_8" class="alert-info">EXAMPLE 8:

```
<ball-bearing-xsd215sd7f> a saref:FeatureOfInterest ;
		saref:hasManufacturer "Company X"@en ;
	saref:hasModel "6000-2RZ1 "@en .
```
</div>

### <a id="5.3"></a>Devices

<a href="#Figure_5">Figure 5</a> illustrates the main classes and properties for devices. SAREF extensions and applications may create, specialize, and categorize devices as specified in ETSI TS 103 548 <a href="#[4]">[4], clause 5.3</a>.

<figure>
  <img src="diagrams/Devices.png" alt="Devices"/>
  <figcaption id="Figure_5">Figure 5: Devices</figcaption>
</figure>

Class [saref:Device](#saref:Device) represents any tangible object designed to accomplish a particular task by performing one or more functions. An instance of [saref:Device](#saref:Device) represents one specific real world entity.

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1: Examples of devices are a light switch, a temperature sensor, an energy meter, a water flow meter, and a laundry dryer. A laundry dryer is designed to dry laundry, and to accomplish this task it has a start/stop function.
</div>

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2:

```
ex:Meter4837QW123 a saref:Device ;
    rdfs:label "Meter 4837QW123"@en ;
    rdfs:comment "The meter that measures the incoming water flow of the Computer Science school."@en .
```
</div>

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3:

```
ex:Dryer354A1E08FA a saref:Device ;
    rdfs:label "Dryer 354A1E08FA"@en ;
    rdfs:comment "The laundry dryer with serial number 354A1E08FA"@en.
```
</div>

Devices are also systems ([s4syst:System](https://saref.etsi.org/saref4syst/System)) and features of interest ([saref:FeatureOfInterest](#saref:FeatureOfInterest)).

A device can be linked to its feature kinds using OP [saref:hasDeviceKind](#saref:hasDeviceKind). Kinds of devices describe models of devices, with common properties having the same value, common states being the same, common functions, and common services. OP [saref:hasDeviceKind](#saref:hasDeviceKind) is a sub-property of OP [saref:hasFeatureKind](#saref:hasFeatureKind).

<div id="EXAMPLE_4" class="alert-info">EXAMPLE 4:

```
ex:Meter4837QW123 saref:hasDeviceKind s4abcd:SmartWaterMeterABC123 .
s4abcd:SmartWaterMeterABC123 a saref:FeatureKind ;
	rdfs:label "Smart Water Meter ABC123"@en ;
	rdfs:comment "The smart water meter ABC123 of manufacturer ABC. A device kind."@en .
```
</div>

A device can act upon (OP [saref:actsUpon](#saref:actsUpon)) features, properties, or states. SAREF Core defines different sub-properties of [saref:actsUpon](#saref:actsUpon):

- [saref:observes](#saref:observes) for when a device observes a feature, or property or state of that feature.
- [saref:controls](#saref:controls) for when a device controls a feature, or property or state of that feature.

<div class="alert-warning">NOTE: Property [saref:actsUpon](#saref:actsUpon) also applies to functions, commands, and procedure executions. 
</div>

<div id="EXAMPLE_5" class="alert-info">EXAMPLE 5:

```
s4abcd:AAHeatPumpDryer a saref:FeatureKind ;
	saref:controls s4abcd:DryerRotationalSpeed ;
	saref:controls s4abcd:DryerTemperature ;
	saref:observes s4abcd:LaudryBatchHumidity .
```
</div>

As shown in <a href="#Figure_6">Figure 6</a>, SAREF Core provides some examples of classes of devices including appliances, sensors, actuators, and meters. Their definitions are the following:

- [saref:Appliance](#saref:Appliance): The class of devices designed to accomplish a particular task for occupant use. It consumes, produces, or stores, some commodity.
- [saref:Sensor](#saref:Sensor): A device designed to observe one or more properties or states of one or more features of interest.
- [saref:Actuator](#saref:Actuator): A device designed to control one or more properties or states of one or more features of interest.
- [saref:Meter](#saref:Meter): A device designed to observe and measure one or more properties of one or more features of interest.
 
<figure>
  <img src="diagrams/Devices_sub.png" alt="Categories of devices"/>
  <figcaption id="Figure_6">Figure 6: Categories of devices</figcaption>
</figure>

### <a id="5.4"></a>Tasks

Class [saref:Task](#saref:Task) represents goals for which a device is designed, from a user perspective.

SAREF extensions and applications may create, specialize, and categorize tasks as specified in ETSI TS 103 548 <a href="#[4]">[4], clause 5.4</a> and illustrated on <a href="#Figure_7">Figure 7</a>.

<figure>
  <img src="diagrams/Tasks.png" alt="Taxonomy of tasks, grouped by categories"/>
  <figcaption id="Figure_7">Figure 7: Taxonomy of tasks, grouped by categories</figcaption>
</figure>

Tasks can be organized in a taxonomy using OPs skos:narrower and skos:broader.

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1: Example of tasks are cleaning, drying, and lighting.

```
saref:Drying a saref:Task ;
    rdfs:label "Drying"@en ;
    rdfs:comment "A type of task for which a device is designed."@en .
```
</div>

Device kinds and devices can be linked to the one or more tasks they are designed to accomplish with OP [saref:accomplishes](#saref:accomplishes).

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2:

```
s4abcd:AAHeatPumpDryer a saref:FeatureKind ;
    saref:accomplishes s4abcd:DryingLaundry .
```
</div>

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3:

```
ex:switch21354 a saref:Device ;
    saref:hasDeviceKind s4abcd:Switch ;
    saref:accomplishes s4abcd:Lighting .
```
</div>

<div class="alert-warning">NOTE: Property [saref:accomplishes](#saref:accomplishes) can also apply to other classes such as functions, commands, and procedure executions.
</div>

### <a id="5.5"></a>Commodities

Class [saref:Commodity](#saref:Commodity) represents marketable items which may be supplied without qualitative differentiation. Commodities may be consumed, produced, or stored, by some feature of interest or device.

SAREF extensions and applications may create, specialize, and categorize commodities as specified in ETSI TS 103 548 <a href="#[4]">[4], clause 5.5</a> and illustrated on <a href="#Figure_8">Figure 8</a>.
 
<figure>
  <img src="diagrams/Commodities.png" alt="Taxonomy of commodities, grouped by categories"/>
  <figcaption id="Figure_8">Figure 8: Taxonomy of commodities, grouped by categories</figcaption>
</figure>

Commodities can be organized in a taxonomy using OPs skos:narrower and skos:broader.

SAREF Core defines the category of energy commodities that groups electricity, gas, propane (of kind gas), coal. It furthermore defines the category of natural resource commodity.

<figure>
  <img src="diagrams/Commodities_sub.png" alt="Categories of commodities"/>
  <figcaption id="Figure_9">Figure 9: Categories of commodities</figcaption>
</figure>

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1:

```
s4abcd:Electricity a saref:EnergyCommodity ;
    rdfs:label "Electricity"@en ;
    rdfs:comment "The electricity energy commodity."@en .
```
</div>

A feature kind, feature of interest, or device, can consume (OP [saref:consumes](#saref:consumes)), produce (OP [saref:produces](#saref:produces)), or store (OP [saref:stores](#saref:stores)), a certain commodity.

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2:

```
s4abcd:AAHeatPumpDryer a saref:FeatureKind ;
    saref:consumes s4abcd:Electricity ;
    saref:produces s4abcd:Water .
```
</div>

### <a id="5.6"></a>Properties, properties of interest, and property values

#### <a id="5.6.1"></a>Introduction

In SAREF, properties refer to the identifiable qualities of features of interest that can be acted upon by devices, such as observed or controlled. While properties can apply to different features of interest, properties of interest are specific to a feature of interest. Property values describe the value for a property.

<a href="#Figure_10">Figure 10</a> illustrates the main classes and properties for describing properties, properties of interest, and property values.

SAREF extensions and applications may create, specialize, and categorize properties as specified in ETSI TS 103 548 <a href="#[4]">[4], clause 5.6</a>.
  
<figure>
  <img src="diagrams/Properties.png" alt="Properties, properties of interest, and property values"/>
  <figcaption id="Figure_10">Figure 10: Properties, properties of interest, and property values</figcaption>
</figure>

#### <a id="5.6.2"></a>Properties

An instance of [saref:Property](#saref:Property) can apply to different features of interest. 

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1: Air temperature, pressure, luminance, etc. are all properties.

```
s4abcd:Temperature a saref:Property ;
	rdfs:label "Temperature"@en ;
	rdfs:comment "The temperature property kind."@en . 
s4abcd:Pressure a saref:Property ;
	rdfs:label "Pressure"@en ;
	rdfs:comment "The pressure property kind."@en .
s4abcd:Luminance a saref:Property ;
	rdfs:label "Temperature"@en ;
	rdfs:comment "The luminance property kind."@en .
```
</div>


<div id="NOTE_1" class="alert-warning">NOTE 1: Until SAREF V3.1.1 <a href="#[i.7]">[i.7]</a>, there was an ambiguity between whether properties should be specific or generic to features of interest. This ambiguity has been solved in SAREF V3.2.1 (the present document), and the new modeling choice will be enforced in the next release of SAREF.
</div>

Properties can be organized in a taxonomy using properties skos:narrower and skos:broader.

<div id="NOTE_2" class="alert-warning">NOTE 2: Concepts from existing code lists, vocabularies, and taxonomies, may be used as instances of <a href="#saref:Property">saref:Property</a>. 
</div>

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2: Two examples using the QUDT Quantity Kind vocabulary <a href="#[i.22]">[i.22]</a>, and the British Oceanographic Data Centre Parameter Usage Vocabulary <a href="#[i.24]">[i.24]</a>.

```
<https://qudt.org/2.1/vocab/quantitykind/ActiveEnergy> a saref:Property ;
	rdfs:label "Active Energy"@en ;
	rdfs:comment "\"Active Energy\" is the electrical energy transformable into some other form of energy."@en .

<http://vocab.nerc.ac.uk/collection/P01/current/CDTSZZ01/> a saref:Property ;
	skos:prefLabel "Absolute temperature standard deviation of the atmosphere by dry bulb thermometer"@en .
```
</div>


The OP [saref:hasProperty](#saref:hasProperty) may be used to link a feature kind or feature of interest to its properties. Its inverse is [saref:isPropertyOf](#saref:isPropertyOf).

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3:

```
	s4abcd:AAHeatPumpDryer a saref:FeatureKind ;
saref:hasProperty s4abcd:DryerRotationalSpeed ;
saref:hasProperty s4abcd:DryerTemperature .
```
</div>

<div id="NOTE_3" class="alert-warning">NOTE 3: Feature kinds inherit the properties of their broader feature kinds.

```	
skos:broader o saref:hasProperty ⊑ saref:hasProperty
```
</div>

<div id="NOTE_4" class="alert-warning">NOTE 4: Features of interest inherit the properties of their feature kinds.

```	
  saref:hasFeatureKind o saref:hasProperty ⊑ saref:hasProperty
```
</div>

#### <a id="5.6.3"></a>Properties of interest

An instance of [saref:PropertyOfInterest](#saref:PropertyOfInterest) is specific to a feature of interest. It is inherent to and cannot exist without that feature of interest.

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1: The air temperature of the atmosphere sample at a certain location and altitude, the received signal strength indicator of a wireless IoT connection, the luminance of the ETSI ATHENA amphitheatre.
</div>

The OP [saref:hasPropertyOfInterest](#saref:hasPropertyOfInterest) may be used to link a feature of interest to its properties of interest. 

Its inverse is [saref:isPropertyOfInterestOf](#saref:isPropertyOfInterestOf) and is functional.

A property of interest is the property of (OP [saref:isPropertyOfInterestOf](#saref:isPropertyOfInterestOf)) exactly one feature of interest.

<div id="NOTE_1" class="alert-warning">NOTE 1: Properties of interest need not always be explicited. It depends on the use case. Typically, properties of interest are useful in applications, where the association between a feature of interest and a property (i.e. the property of interest) needs to be identified and related to other properties of interest.
</div>

Given a property of interest belongs to exactly one feature of interest, it is recommended that its identifier consists of the identifier of the feature of interest, followed by character '#' and a fragment identifier. The fragment identifier part of the IRI of a property of interest should not contain "property".

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2: The luminance of the ETSI ATHENA amphitheatre belongs to the ETSI ATHENA amphitheatre.

```
<etsi_premises/athena#luminance> a saref:PropertyOfInterest ;
	saref:isPropertyOfInterestOf <etsi_premises/athena> ; 
	rdfs:comment "The luminance of amphitheatre ATHENA"@en .
```
</div>

A property of interest can be linked to its kind(s) using OP [saref:hasPropertyKind](#saref:hasPropertyKind).

<div id="NOTE_2" class="alert-warning">NOTE 2: Properties of interest inherit broader properties.

```	
saref:hasPropertyKind o skos:broader ⊑ saref:hasPropertyKind
```
</div>

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3: The luminance of the ETSI ATHENA amphitheatre is of kind luminance.

```
<etsi_premises/athena#luminance> a saref:PropertyOfInterest ;
	saref:hasPropertyKind saref:Luminance .
```
</div>

<div id="NOTE_3" class="alert-warning">NOTE 3: Features of interest inherit the property kinds of their properties of interest.

```	
saref:hasPropertyOfInterest o saref:hasPropertyKind ⊑ saref:hasProperty
```
</div>


<div id="EXAMPLE_4" class="alert-info">EXAMPLE 4: The ETSI ATHENA amphitheatre has a property luminance.

```
<etsi_premises/athena> a saref:FeatureOfInterest ;
	saref:hasPropertyOfInterest <etsi_premises/athena#luminance> ;
	saref:hasProperty saref:Luminance .
```
</div>


#### <a id="5.6.4"></a>Property Values

Class [saref:PropertyValue](#saref:PropertyValue) describes the value for a property. The property value is linked to its value expressed as an RDF literal (DP [saref:hasValue](#saref:hasValue)), optionally to the unit of measurement (OP [saref:isMeasuredIn](#saref:isMeasuredIn)), and optionally to the properties or properties of interest it is a value of (OP [saref:isValueOfProperty](#saref:isValueOfProperty)). 

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1:

```
[] a saref:PropertyValue ;
    saref:hasValue 22.7
    saref:isMeasuredIn <https://qudt.org/2.1/vocab/unit/DEG_C> .
```
</div>

The range of [saref:isMeasuredIn](#saref:isMeasuredIn) is defined as [saref:UnitOfMeasure](#saref:UnitOfMeasure).

<div id="NOTE_1" class="alert-warning">NOTE 1: Concepts from existing code lists, vocabularies, and taxonomies, may be used as instances of <a href="#saref:UnitOfMeasure">saref:UnitOfMeasure</a>. For example the QUDT Unit vocabulary <a href="#[i.23]">[i.23]</a>.
</div>

The OP [saref:hasPropertyValue](#saref:hasPropertyValue) links a feature kind, a feature of interest, or a property of interest, to a property value.

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2:

```
<etsi_premises/athena#size> a saref:PropertyOfInterest ;
    saref:isPropertyOf <etsi_premises/athena> ;
    saref:hasPropertyValue [
        a saref:PropertyValue ;
        saref:hasValue 105.0 ;
        saref:isMeasuredIn <https://qudt.org/2.1/vocab/unit/M2> ] .
```
</div>

<div id="NOTE_2" class="alert-warning">NOTE 2: The property values are inherited in the hierarchy of feature kinds. This enables to incrementally construct prototypical descriptions of features of interest.

```
  skos:broader saref:hasPropertyValue ⊑ saref:hasPropertyValue
```
</div>

<div id="NOTE_3" class="alert-warning">NOTE 3: A feature of interest does not inherit the property values of its kinds. There may be multiple reasons why the property value of a feature of interest is different from that of its prototypical descriptions. For example, it may be caused by a defect, a deterioration, or a customization.
</div>

The OP [saref:isValueOfProperty](#saref:isValueOfProperty) links a property value to the properties and properties of interest it is a value of.

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3:

```
<1000x2000mmWindowOrientedNorth> a saref:FeatureKind ;
    saref:hasProperty <WindowArea> ;
    saref:hasPropertyValue [
        a saref:PropertyValue ;
        saref:hasValue 2.0 ;
        saref:isMeasuredIn <https://qudt.org/2.1/vocab/unit/M2> ;
        saref:isValueOfProperty <WindowArea> ] .
```
</div>

<div id="NOTE_4" class="alert-warning">NOTE 4: A property value about a property of interest is also a property value of its property kinds.

```
  saref:isValueOfProperty o saref:hasPropertyKind ⊑ saref:isValueOfProperty
```
</div>


<div id="NOTE_5" class="alert-warning">NOTE 5: <a href="#saref:hasPropertyValue">saref:hasPropertyValue</a> and <a href="#saref:isValueOfProperty">saref:isValueOfProperty</a> are not inverse properties.
</div>

### <a id="5.7"></a>States and states of interest

#### <a id="5.7.1"></a>Introduction

In SAREF, states refer to the identifiable conditions that features of interest are or may be in, and that can be acted upon by devices, such as observed and controlled. While states can apply to different features of interest, states of interest are specific to a feature of interest.

<a href="#Figure_11">Figure 11</a> illustrates the main classes and properties for describing states and states of interest.

SAREF extensions and applications may create, specialize, and categorize states as specified in ETSI TS 103 548 <a href="#[4]">[4], clause 5.7</a>.
  
<figure>
  <img src="diagrams/States.png" alt="States and states of interest"/>
  <figcaption id="Figure_11">Figure 11: States and states of interest</figcaption>
</figure>

#### <a id="5.7.2"></a>States

An instance of [saref:State](#saref:State) can apply to different features of interest.

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1: A switch can be found in the [saref:OnOffState](#saref:OnOffState), which is further specialized in [saref:OnState](#saref:OnState) and [saref:OffState](#saref:OffState).

```
saref:OnOffState a saref:State .
saref:OnState a saref:State ;
    skos:broader saref:OnOffState .
	saref:OffState a saref:State ;
    skos:broader saref:OnOffState .
 	s4abcd:Switch a saref:FeatureKind ;
 	saref:hasState saref:OnOffState .
```
</div>

<div id="NOTE_1" class="alert-warning">NOTE 1: SAREF is not restricted to binary states such as the <a href="#saref:OnOffState">saref:OnOffState</a>, but allows to define also n-ary states (see, for example, the <a href="#saref:MultiLevelState">saref:MultiLevelState</a> class).
</div>

States can be organized in a taxonomy using properties skos:narrower and skos:broader.

<div id="NOTE_2" class="alert-warning">NOTE 2: Concepts from existing code lists, vocabularies, and taxonomies, may be used as instances of <a href="#saref:State">saref:State</a>.
</div>

The OP [saref:hasState](#saref:hasState) may be used to link a feature kind to its states. Its inverse is [saref:isStateOf](#saref:isStateOf).

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2:

```
s4abcd:TwoButtonsOneWaySwitch a saref:FeatureKind ;
	saref:hasState s4abcd:Button1UpDownState , s4abcd:Button2UpDownState .
s4abcd:Button1UpDownState a saref:State ;
	skos:broader s4abcd:ButtonUpDownState .
s4abcd:Button2UpDownState a saref:State ;
	skos:broader s4abcd:ButtonUpDownState .
```
</div>


The narrowest states of the taxonomy of states can be considered as the state values.

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3: s4abcd:ButtonUp and s4abcd:ButtonDown can be considered as the possible values for state s4abcd:ButtonUpDownState.

```
s4abcd:ButtonUp a saref:State ;
	skos:broader s4abcd:ButtonUpDownState .
s4abcd:ButtonDown a saref:State ;
	skos:broader s4abcd:ButtonUpDownState .
```
</div>


<div id="NOTE_3" class="alert-warning">NOTE 3: Feature kinds inherit the states of their broader feature kinds.

```
skos:broader o saref:hasState ⊑ saref:hasState
```
</div>


<div id="NOTE_4" class="alert-warning">NOTE 4: Features of interest inherit the states of their feature kinds.

```
saref:hasFeatureKind o saref:hasState ⊑ saref:hasState
```
</div>

#### <a id="5.7.3"></a>States of Interest

An instance of [saref:StateOfInterest](#saref:StateOfInterest) is specific to a feature of interest. It is inherent to and cannot exist without that feature of interest.

The OP [saref:hasStateOfInterest](#saref:hasStateOfInterest) may be used to link a feature of interest to its states of interest. 

Its inverse is [saref:isStateOfInterestOf](#saref:isStateOfInterestOf) and is functional.

A state of interest is the state of (OP [saref:isStateOfInterestOf](#saref:isStateOfInterestOf)) exactly one feature of interest.

<div id="NOTE_1" class="alert-warning">NOTE 1: States of interest need not always be explicited. It depends on the use case. Typically, states of interest are useful in applications where the association between a feature of interest and a state (i.e. the state of interest) needs to be identified and related to other states of interest.
</div>

Given a state of interest belongs to exactly one feature of interest, it is recommended that its identifier consists of the identifier of the feature of interest, followed by character '#' and a fragment identifier. The fragment identifier part of the IRI of a property of interest should not contain "state".

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1: Switch <switch_sdf5ze4fz3> has two up/down states of interest.

```
<switch_sdf5ze4fz3> a saref:Device ;
    saref:hasDeviceKind s4abcd:TwoButtonsOneWaySwitch ; 
    saref:hasState <switch_sdf5ze4fz3#btn1>, <switch_sdf5ze4fz3#btn2> .
<switch_sdf5ze4fz3#btn1> a saref:StateOfInterest ;
    saref:hasStateKind s4abcd:Button1UpDownState .
<switch_sdf5ze4fz3#btn2> a saref:StateOfInterest ;
    saref:hasStateKind s4abcd:Button2UpDownState .
```
</div>

A state of interest can be linked to its kind(s) using OP [saref:hasStateKind](#saref:hasStateKind).

<div id="NOTE_2" class="alert-warning">NOTE 2: States of interest inherit broader states.

```
  saref:hasStateKind o skos:broader ⊑ saref:hasStateKind
```
</div>

<div id="NOTE_3" class="alert-warning">NOTE 3: Features of interest inherit the state kinds of their states of interest.

```
  saref:hasStateOfInterest o saref:hasStateKind ⊑ saref:hasState
```
</div>


As the narrowest states of the taxonomy of states can be thought of as the state values, it is possible to assign a stable value to a state as follows:

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2: Button 2 of switch  <switch_sdf5ze4fz3> is in stable up position.

```
<switch_sdf5ze4fz3#btn2> a saref:StateOfInterest ;
    saref:hasStateKind s4abcd:Button2UpDownState ;
    saref:hasState s4abcd:ButtonUp .
```
</div>


### <a id="5.8"></a>Functions and functions of interest

#### <a id="5.8.1"></a>Introduction

In SAREF, functions are logical groups of commands that devices support to accomplish their tasks. Function can act upon (OP [saref:actsUpon](#saref:actsUpon) and its sub-properties) features, properties, or states. While functions are independent of any devices, functions of interest are functions actually supported by a device.

<a href="#Figure_12">Figure 12</a> illustrates the main classes and properties for describing functions and functions of interest.

SAREF extensions and applications may create, specialize, and categorize functions as specified in ETSI TS 103 548 <a href="#[4]">[4], clause 5.8</a>.

<figure>
  <img src="diagrams/Functions.png" alt="Functions and functions of interest"/>
  <figcaption id="Figure_12">Figure 12: Functions and functions of interest</figcaption>
</figure>

#### <a id="5.8.2"></a>Functions

An instance of [saref:Function](#saref:Function) can apply to different devices.

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1: To accomplish the task of controlling the light, a smart light switch may have a function for turning on and off the light, and another to set the luminosity of the light.
</div>

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2: To accomplish the task of sensing the temperature, a temperature sensor should have a sensing function.
</div>

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3: To accomplish the task of washing clothes, a washing machine should have a function for washing.
</div>

Functions can be organized in a taxonomy using properties skos:narrower and skos:broader.

<div id="NOTE_1" class="alert-warning">NOTE 1: Concepts from existing code lists, vocabularies, and taxonomies, may be used as instances of <a href="#saref:Function">saref:Function</a>.
</div>

Kinds of devices can be defined from pre-defined building blocks, based on the functions they have.

<div id="EXAMPLE_4" class="alert-info">EXAMPLE 4:

```
s4abcd:AAHeatPumpDryer a saref:FeatureKind ;
    saref:hasFunction s4acd:WashingFunction .
```
</div>

The OP [saref:hasFunction](#saref:hasFunction) may be used to link a feature kind or device to its functions. Its inverse is [saref:isFunctionOf](#saref:isFunctionOf).

<div id="NOTE_2" class="alert-warning">NOTE 2: Feature kinds inherit the functions of their broader feature kinds.

```
skos:broader o saref:hasFunction ⊑ saref:hasFunction
```
</div>

<div id="NOTE_3" class="alert-warning">NOTE 3: Devices inherit the functions of their device kinds.

```
  saref:hasDeviceKind o saref:hasFunction ⊑ saref:hasFunction
```
</div>

#### <a id="5.8.3"></a>Functions of Interest

An instance of [saref:FunctionOfInterest](#saref:FunctionOfInterest) is supported by exactly one device.

The OP [saref:hasFunctionOfInterest](#saref:hasFunctionOfInterest) may be used to link a device to its function of interest. 

Its inverse is [saref:isFunctionOfInterestOf](#saref:isFunctionOfInterestOf) and is functional.

A function of interest is the function of (OP [saref:isFunctionOfInterestOf](#saref:isFunctionOfInterestOf)) exactly one device.

<div id="NOTE_1" class="alert-warning">NOTE 1: Functions of interest need not always be explicited. It depends on the use case. Typically, functions of interest are useful to specify which command is actually exposed, and which actual property of interest or state of interest it acts upon.
</div>

A function of interest can be linked to its kind(s) using OP [saref:hasFunctionKind](#saref:hasFunctionKind).

<div id="NOTE_2" class="alert-warning">NOTE 2: Functions of interest inherit broader functions.

```
saref:hasFunctionKind o skos:broader ⊑ saref:hasFunctionKind
```
</div>

<div id="NOTE_3" class="alert-warning">NOTE 3: Devices inherit the function kinds of their functions of interest.

```
saref:hasFunctionOfInterest o saref:hasFunctionKind ⊑ saref:hasFunction
```
</div>

### <a id="5.9"></a>Commands and commands of interest

#### <a id="5.9.1"></a>Introduction

In SAREF, commands represent the lowest-level directives a device supports and exposes to some network. Commands can act upon (OP [saref:actsUpon](#saref:actsUpon) and its sub-properties) features, properties, or states. While commands are independent of any function, commands of interest are commands actually supported by a function of interest.

<a href="#Figure_13">Figure 13</a> illustrates the main classes and properties for describing commands and device commands.

SAREF extensions and applications may create, specialize, and categorize commands as specified in ETSI TS 103 548 <a href="#[4]">[4], clause 5.8</a>.

<figure>
  <img src="diagrams/Commands.png" alt="Command kinds and device commands"/>
  <figcaption id="Figure_13">Figure 13: Command kinds and device commands</figcaption>
</figure>

#### <a id="5.9.2"></a>Commands

An instance of [saref:Command](#saref:Command) is independent of any device.

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1: Observe property, control property, observe state, control state, invoke action, cancel action, turn on or off, change color, subscribe, publish, etc. are all commands.
</div>

Commands can be organized in a taxonomy using OPs skos:narrower and skos:broader.
Functions can be defined from pre-defined building blocks, based on the commands they have.

The OP [saref:hasCommand](#saref:hasCommand) may be used to link a function or function of interest to its commands. Its inverse is [saref:isCommandOf](#saref:isCommandOf). SAREF Core defines two sub-properties of [saref:hasCommand](#saref:hasCommand), that only apply to functions:

- [saref:hasMandatoryCommand](#saref:hasMandatoryCommand) for when the command is mandatory to the function;
- [saref:hasOptionalCommand](#saref:hasOptionalCommand) for when the command is optional to the function.

<div id="NOTE_1" class="alert-warning">NOTE 1: Functions inherit the mandatory commands of their broader functions.

```
skos:broader o saref:hasMandatoryCommand ⊑ saref:hasMandatoryCommand
```
</div>

<div id="NOTE_2" class="alert-warning">NOTE 2: Functions of interest inherit the mandatory commands of their function kinds.

```
saref:hasFunctionKind o saref:hasMandatoryCommand ⊑ saref:hasCommand
```
</div>

A command may be described in terms of its input parameters using OP [saref:hasInput](#saref:hasInput). Typically, input parameters are feature kinds, properties, or states.

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2: Different complementary commands can be defined for controlling a light. Turn on or off the light based on a desired state, toggle the light status of a specific light, set the luminosity level with a transition time, set the default transition time.
</div>

A command may be described in terms of its outputs using OP [saref:hasOutput](#saref:hasOutput). Typically, outputs are properties or states.

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3: Different complementary commands can be defined for observing a smart home. Observe the temperature once will output the indoor temperature property; observe status of the entry door will output an open/close state.
</div>

A command may be described in terms of the properties or states it acts upon, such as observe, or control.

#### <a id="5.9.3"></a>Commands of Interest

A [saref:CommandOfInterest](#saref:CommandOfInterest) is a directives actually supported by a device and exposed to some network.

Like for commands, commands of interest may be described in terms of their input parameters, outputs, and of which properties or states they act upon.

The OP [saref:hasCommandOfInterest](#saref:hasCommandOfInterest) may be used to link a function of interest to its command of interest. 

Its inverse is [saref:isCommandOfInterestOf](#saref:isCommandOfInterestOf) and is functional.

A command of interest is the command of (OP [saref:isCommandOfInterestOf](#saref:isCommandOfInterestOf)) exactly one function.

<div id="NOTE_1" class="alert-warning">NOTE 1: Commands of interest need not always be explicited. It depends on the use case. Typically, commands of interest are useful to specify the actual property of interest or state of interest that is expected as input parameter, output, or that will be acted upon.
</div>

<div id="EXAMPLE_4" class="alert-info">EXAMPLE 4: The corridor smart light switch supports a command of kind "turn on/off", which controls the state of the outdoor light.
</div>

<div id="EXAMPLE_5" class="alert-info">EXAMPLE 5: The smart fridge supports a command of kind "observes temperature", which observes the temperature of the fridge.
</div>

A command of interest can be linked to its kind(s) using OP [saref:hasCommandKind](#saref:hasCommandKind).

<div id="NOTE_2" class="alert-warning">NOTE 2: Commands of interest inherit broader commands.

```
saref:hasCommandKind o skos:broader ⊑ saref:hasCommandKind
```
</div>

<div id="NOTE_3" class="alert-warning">NOTE 3: Devices inherit the commands of their commands of interest.

```
saref:hasCommandOfInterest o saref:hasCommandKind ⊑ saref:hasCommand
```
</div>

### <a id="5.10"></a>Services and Operations

<a href="#Figure_14">Figure 14</a> illustrates the main classes and properties for describing services and operations. 

<figure>
  <img src="diagrams/Service.png" alt="Services and operations"/>
  <figcaption id="Figure_14">Figure 14: Services and operations</figcaption>
</figure>

A [saref:Service](#saref:Service) is a digital representation of a function in a network, making it discoverable, registerable and remotely controllable in the network.

OP [saref:represents](#saref:represents) links a service to some function or function of interest it exposes to the network.

A service represents at least one function of interest.

OP [saref:offers](#saref:offers) links a device to a service it exposes to a network. Its inverse if [saref:isOfferedBy](#saref:isOfferedBy).

A service is offered by exactly one device.

<div id="NOTE_1" class="alert-warning">NOTE 1: Typically, a device connected to a given network offers one service for each of its functions of interest.
</div>

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1: A light switch can offer the service of remotely switching the lights in a home through mobile phone devices that are connected to the local network (ex:SwitchOnService class). This "remote switching" service represents the ex:OnOffFunction.
</div>

A [saref:Operation](#saref:Operation) is the means of a service to communicate in a procedure-type manner over the network (i.e. transmit data to/from other devices). It is the -machine interpretable- exposure of a -human understandable- command to a network.

An operation may be described in terms of its inputs and outputs using OP [saref:hasInput](#saref:hasInput) and [saref:hasOutput](#saref:hasOutput). Inputs and outputs of operations typically describe the expected schema or shape of network messages.

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2: To turn on a light, send a CoAP PUT request with CBOR content `0xf5` (true).
</div>

OP [saref:represents](#saref:represents) also links an operation to some command or command of interest it exposes to the network.
An operation represents at least one command of interest.

OP [saref:hasOperation](#saref:hasOperation) links a service to its operations. Its inverse is [saref:isOperationOf](#saref:isOperationOf).

An operation belongs to exactly one service.

<div id="NOTE_2" class="alert-warning">NOTE 2: Typically, a device connected to a given network offers one service for each of its functions of interest, and each service has one operation per command of interest of the function of interest it represents.
</div>

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3: In the set of operations exposed by a smart light bulb on a given network, one may be dedicated to turn on and off the light and expect a boolean as input. Another one may be dedicated to set the luminosity status and expect a target luminosity level (a byte) and a transition time (encoded on two bytes).
</div>

<div id="EXAMPLE_4" class="alert-info">EXAMPLE 4: In the set of operations exposed by a smart washing machine on a given network, one may be dedicated to set the water temperature for the washing cycle, and expected as input a enumerated value. Another one may be dedicated to start, pause, or stop the washing cycle.
</div>

<div id="NOTE_3" class="alert-warning">NOTE 3: The concept of service is further elaborated in the oneM2M Base Ontology <a href="#[1]">[1]</a>, to which the reader is referred in order to model the details of a service that are out of the scope of SAREF.
</div>

### <a id="5.11"></a>Procedure executions and sub-classes

#### <a id="5.11.1"></a>Procedure executions

A [saref:ProcedureExecution](#saref:ProcedureExecution) represents the act of carrying out a procedure.

<a href="#Figure_15">Figure 15</a> illustrates the main properties for describing procedure executions.
 
<figure>
  <img src="diagrams/ProcedureExecution.png" alt="Procedure executions"/>
  <figcaption id="Figure_15">Figure 15: Procedure executions</figcaption>
</figure>

OP [saref:madeBy](#saref:madeBy) links a procedure execution to the device that made it.

A procedure execution may be linked to its inputs using OP [saref:hasInput](#saref:hasInput).

A procedure execution may be linked to its result using OP [saref:hasResult](#saref:hasResult).

DP [saref:hasResultTime](#saref:hasResultTime) links a procedure execution to the instant of time when the procedure is completed, expressed as an xsd:dateTime literal.

OP [saref:hasPhenomenonTime](#saref:hasPhenomenonTime) links a procedure execution to the time that the result applies. It may be an interval or an instant, or some other compound temporal entity expressed using OWL Time <a href="#[7]">[7]</a>.

When the execution time and the phenomenon time are the same time instants, then DP [saref:hasTimestamp](#saref:hasTimestamp) can be used to simply link a procedure execution to the time of these instants, expressed as an xsd:dateTime literal. 

Optionally, a procedure execution can act upon (OP [saref:actsUpon](#saref:actsUpon)) a feature, property, or state.

#### <a id="5.11.2"></a>Command executions and operation executions

<a href="#Figure_16">Figure 16</a> illustrates the main classes and properties for describing command executions and operation executions. 

<figure>
  <img src="diagrams/CommandExecution.png" alt="Command executions and operation executions"/>
  <figcaption id="Figure_16">Figure 16: Command executions and operation executions</figcaption>
</figure>

A [saref:CommandExecution](#saref:CommandExecution) describes the execution of a command. Typically, its inputs and outputs are human understandable and relate to some feature of interest, such as its state (e.g. s4abcd:On), or the value of its temperature (e.g. property value 21,0 °C).

A [saref:OperationExecution](#saref:OperationExecution) describes the execution of an operation in a network: the-machine interpretable-  description of a communication between devices over the network. Typically, its input and result are network messages, that conform to the input and output of the executed operation.

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1: A CoAP PUT request with CBOR content `0xf5` (true), a CoAP response with code `2.04` (Changed).
</div>

OP [saref:isExecutionOf](#saref:isExecutionOf) links a command execution to the command or command of interest that was executed.

It also liks an operation execution to the operation that was executed.

<div id="NOTE_1" class="alert-warning">NOTE 1: If a command execution is an execution of a command, it is also the execution of its broader commands.

```
saref:isExecutionOf o skos:broader ⊑ saref:isExecutionOf
```
</div>

<div id="NOTE_2" class="alert-warning">NOTE 2: If a command execution is an execution of a command of interest, it is also the execution of the command kind of that command of interest.

```
saref:isExecutionOf o saref:hasCommandKind ⊑ saref:isExecutionOf
```
</div>

#### <a id="5.11.3"></a>Observations, Measurements, and Actuations

<a href="#Figure_17">Figure 17</a> illustrates the main classes and properties for describing observations, measurements, and actuations.

<figure>
  <img src="diagrams/Observation.png" alt="Observations, measurements, and actuations"/>
  <figcaption id="Figure_17">Figure 17: Observations, measurements, and actuations</figcaption>
</figure>

A [saref:Observation](#saref:Observation) is the act of carrying out a procedure to estimate or calculate a value of a property of a feature of interest, or a state of a feature of interest. It links to a sensor to describe what made the observation, and to the observed feature, property, property of interest, state, or state of interest. Typically, its result is a property value or a state. An observation of a state (OP [saref:observes](#saref:observes)) should have a state as a result (OP [saref:hasResult](#saref:hasResult)). Respectively, an observation of a property should have a property value as a result.

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2:

```
ex:DTSObservation106 a saref:Observation ;
	saref:madeBy <meter> ;
  saref:hasTimestamp "2023-12-06T21:01:10"^^xsd:dateTime ;
	saref:observes s4watr:Cadmium ;
saref:hasResult ex:Meter4837QW123Value184 .
ex:Meter4837QW123Value184 a saref:PropertyValue ;
  saref:isValueOfProperty s4watr:Cadmium ;
	saref:hasValue 0.005 .
```
</div>

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3:

```
[] a saref:Observation ;
  saref:madeBy <sensor> ;
 	saref:hasTimestamp "2023-12-06T21:47:10"^^xsd:dateTime .
saref:observes <door_zef53ze7> ;
    saref:observes <door_zef53ze7#openclose> ;
	saref:observes saref:OpenClose ;
saref:hasResult saref:Open .
```
</div>

<div id="NOTE_3" class="alert-warning">NOTE 3: <a href="#saref:Observation">saref:Observation</a> is more general than <a href="#saref:Measurement">saref:Measurement</a>, as it apply to states in addition to properties. The indirection <a href="#saref:hasResult">saref:hasResult</a> to a property value improves its semantic correctness. It also improves the alignment with the OGC® and W3C® SOSA/SSN ontology <a href="#[6]">[6]</a>. Therefore, <a href="#saref:Measurement">saref:Measurement</a> has been deprecated in the present document, and may be deleted in the next release of SAREF.
</div>

A [saref:Actuation](#saref:Actuation) is the act of carrying out a procedure to control the state of the world using an actuator. It links to an actuator to describe what made the actuation, and to the controlled feature, property, property of interest, state, or state of interest. Typically, its input is a property value or a state. An actuation of a state (OP [saref:controls](#saref:controls)) should have a state as input (OP [saref:hasInput](#saref:hasInput)). Respectively, an actuation of a property should have a property value as input.

<div id="NOTE_4" class="alert-warning">NOTE 4: An observation or an actuation may also be a command execution, if it corresponds to the execution of a directives a device supports and exposes to some network. However, an observation or an actuation should not be an operation execution, as these are intended to be machine interpretable descriptions of network communications.
</div>

<div id="NOTE_5" class="alert-warning">NOTE 5: It is acceptable that the inputs or results of a command execution are observations or actuations. For example:

- A command execution to aggregate observations will have these observations as input.
- A command execution to retrieve the past five observations will have these observations as output.
- A command execution to plan a series of actuations will have these actuations as input, and potentially also as result if successful. 
</div>

### <a id="5.12"></a>Profiles

A device in SAREF can be further characterized by profiles. <a href="#Figure_18">Figure 18</a> illustrates the main classes and properties for describing profiles.

<figure>
  <img src="diagrams/Profiles.png" alt="Profiles"/>
  <figcaption id="Figure_18">Figure 18: Profiles</figcaption>
</figure>

A [saref:Profile](#saref:Profile) describes the money earned (negative values) or paied (positive values) for the use (production or consumption) of a commodity by a device in a certain context.

OP [saref:hasProfile](#saref:hasProfile) links a device to its profile. Its inverse is [saref:isProfileOf](#saref:isProfileOf). The device should be linked to a certain commodity using OP [saref:isUsedFor](#saref:isUsedFor) or its sub-properties, and optionally to some property or state using OP [saref:actsUpon](#saref:actsUpon) or its sub-properties.

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1:

```
ex:Device_1 a saref:Device ;
	saref:isUsedFor s4abcd:Electricity ;
	saref:hasProfile ex:FlexibilityProfile ;
	saref:controls <house#temperature> .
ex:FlexibilityProfile a saref:Profile ;
	saref:hasPrice <pricePropertyValue> .
```
</div>

The applicable context of a profile can be bound temporally using DP [saref:hasTimestamp](#saref:hasTimestamp) or its subproperties defined by SAREF extensions, or OP [saref:hasApplicableTime](#saref:hasApplicableTime) which links to instant or interval or other compound temporal entity expressed using OWL Time <a href="#[7]">[7]</a>.

<div class="alert-warning">NOTE: [saref:hasApplicableTime](#saref:hasApplicableTime) may be applied to other entities, such as functions, commands, or procedure executions.
</div>

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2:

```
ex:FlexibilityProfile [saref:hasTimestamp](#saref:hasTimestamp) "2023-12-15T11:00:00"^^xsd:dateTime .
```
</div>

<div id="EXAMPLE_3" class="alert-info">EXAMPLE 3:

```
ex:FlexibilityProfile
	rdfs:comment "applies only on Saturdays"@en ;
saref:hasApplicableTime [ 
		a time:DateTimeDescription ;
		time:dayOfWeek time:Saturday ] .
```
</div>

The applicable context can be restricted to when the property of a feature of interest has some value (OPs [saref:whenPropertyValue](#saref:whenPropertyValue)).

<div id="EXAMPLE_4" class="alert-info">EXAMPLE 4:

```
ex:FlexibilityProfile
saref:whenPropertyValue [
    a saref:PropertyValue ;
    saref:hasValue 22.0 ;
    saref:isMeasuredIn <http://qudt.org/vocab/unit/DEG_C> ;
 	saref:isValueForProperty <house#comfort_temperature_setpoint> ] .
```
</div>

The applicable context can be restricted to when a feature of interest has a certain state (OPs [saref:whenState](#saref:whenState)).

<div id="EXAMPLE_5" class="alert-info">EXAMPLE 5:

```
ex:FlexibilityProfile
saref:whenState [
    a saref:State ;
    skos:broader s4abcd:ComfortSetpoint ;
 	saref:isStateOf <house#temperature_setpoint> ] .
```
</div>
   
OP [saref:profileHasPrice](#saref:profileHasPrice) links a profile to the money earned (negative values) or paid (positive values) for the use (production or consumption) of the commodity by the device.

<div id="EXAMPLE_6" class="alert-info">EXAMPLE 6:

```
ex:FlexibilityProfile
saref:profileHasPrice [
    a saref:PropertyValue ;
    saref:hasValue 0.2 ;
    saref:isMeasuredIn <http://qudt.org/vocab/currency/EUR> ] .	
```
</div>

A set of specializations of a Profile is given via the Flexibility Profile defined in the SAREF4ENER extension in ETSI TS 103 410-1 <a href="#[i.8]">[i.8]</a>. Each Flexibility Profile describes the ways in which a device can regulate its energy consumption and production. Therefore, the Flexibility Profile is a static set of options to choose from and a set of user preferences, instead of a pre-calculated energy usage time series. The details of each Flexibility Profile can be specified using the related extensions.
A specialization of a Profile may additionally relate to other SAREF classes via properties defined in the extensions, including, but not limited to a state, property, property value, function, and command.

<div id="EXAMPLE_7" class="alert-info">EXAMPLE 7:

```
ex:FlexibilityProfile a saref:Profile ;
	s4abcd:{someConditionDefinedBySAREF4ABCD} <conditionSpecification> .
```
</div>

### <a id="5.13"></a>Features of Interest, devices, and spatial objects

An instance may be classified as both [saref:FeatureOfInterest](#saref:FeatureOfInterest) and geo:SpatialObject.

The class [saref:Device](#saref:Device) is a sub-class of geo:Feature from the GeoSPARQL standard <a href="#[8]">[8]</a>, section 6.2.

SAREF application may attach a geometry to a [saref:FeatureOfInterest](#saref:FeatureOfInterest) or a [saref:Device](#saref:Device) using geo:hasGeometry or its sub-properties geo:hasBoundingBox, geo:hasCentroid, geo:hasDefaultGeometry <a href="#[8]">[8]</a>, section 6.4.

<div id="EXAMPLE_1" class="alert-info">EXAMPLE 1:

```
<etsi_premises> a saref:FeatureOfInterest , geo:Feature ; 
	geo:hasCentroid "POINT( 7.052986 43.6169446 )"^^geo:wktLiteral .
```
</div>

SAREF application may describe how things are spatially related using different families of topological relations from GeoSPARQL, such as the Simple Features relation family (e.g. geo:sfWithin, geo:sfOverlaps), the Egenhoer Relation Family (e.g. geo:ehInside, geo:ehOverlap), the RCC8 Relation Family (e.g. geo:rcc8tpp, geo:rcc8po) <a href="#[8]">[8]</a>, section 7.

<div id="EXAMPLE_2" class="alert-info">EXAMPLE 2:

```
<etsi_premises/athena> a saref:FeatureOfInterest , geo:Feature ; 
	geo:sfWithin <etsi_premises> .
```
</div>
