<div class="alert-warning">NOTE: The text in this section is extracted from ETSI TS 103 264 (V3.2.1) [[0]](#[0]), and therefore falls inside the <a href="https://www.etsi.org/intellectual-property-rights">ETSI IPR Policy</a></div> 

The Smart Applications REFerence ontology (SAREF) is intended to enable interoperability between solutions from different providers and among various activity sectors in the Internet of Things (IoT), thus contributing to the development of the global digital market.

SAREF explicitly specifies the recurring core concepts in the Smart Applications domain, the main relationships between these concepts, and axioms to constrain the usage of these concepts and relationships. SAREF is based on the fundamental principles of **reuse and alignment** of concepts and relationships that are defined in existing assets, **modularity** to allow separation and recombination of different parts of the ontology depending on specific needs, **extensibility** to allow further growth of the ontology, and **maintainability** to facilitate the process of identifying and correcting defects, accommodate new requirements, and cope with changes in (parts of) SAREF.

Mappings to other concepts used by different semantic assets allow translation from the reference ontology to specific assets, reducing the effort of translating from one asset to another, since the reference ontology requires one set of mappings to each asset, instead of a dedicated set of mappings for each pair of assets. 


### A Brief History of SAREF

The SAREF initiative started in 2014/2015 with a study requested by the European Commission on "Available Semantics Assets for the Interoperability of Smart Appliances: Mapping into a Common Ontology as a M2M Application Layer Semantics"  [[i.1]](#[i.1]). Such study acknowledged that the energy utilization of Smart Appliances can be reduced if they are managed and controlled on a system level. The system needs standardized interfaces to ensure interoperability. Many of the required standards already exist, but a common architecture does not, resulting in a market which is too fragmented and powerless. Therefore, a reference ontology of consensus was designed to cover the needs of all appliances relevant for energy efficiency. The study consisted of three tasks:

- **Task 1**: Take stock of existing semantic assets and use case assets.
- **Task 2**: Perform a translation exercise of each model (or use case) to a common ontology language and a mapping or matching exercise between all the models.
- **Task 3**: Propose a reference ontology and document the ontology into the ETSI M2M architecture.

NOTE: The ETSI M2M architecture has evolved into the oneM2M architecture, therefore the latter one was considered.

About 50 different semantic assets (i.e. standards, protocols, data models, ontologies) had been identified that describe various properties of Smart Appliances in residential environments. After translating half of these semantic assets into Web Ontology Language (OWL) (https://sites.google.com/site/smartappliancesproject/ontologies), 20 recurring concepts were used as initial building blocks for creating the Smart Applications REFerence ontology. The concepts were mapped from the semantic assets to SAREF to allow for translations between different semantic assets  [[i.4]](#[i.4]).

In November 2015, SAREF was transformed into a Technical Specification and published by ETSI SmartM2M as ETSI TS 103 264  [[i.5]](#[i.5]).

In 2016, ETSI SmartM2M requested a Specialist Task Force (STF) to identify and create possible extensions of SAREF, and provide input to update SAREF according to the requirements collected from the stakeholders that have used SAREF since its first release in April 2015. This led to a new release SAREF V2.1.1  [[i.6]](#[i.6]), which incorporated the feedback both from the STF that created the first SAREF extensions, and from the stakeholders that provided their input for improving SAREF. This feedback can be found in ETSI TR 103 411  [[i.3]](#[i.3]) and was used to create SAREF V2.1.1.

The scope of the first release of SAREF was limited to an indoor managed domain, such as a building managed by a building manager or an apartment managed by a user. This scope also included the outdoor premises that belong to the considered indoor managed domain, in other words, a pergola that is part of the building is also within the scope, as well as a sensor located under that pergola. Note that the smart city domain was not originally considered, i.e. if the same sensor that is under the pergola is also in a street, then the sensor in the street was out of the scope of SAREF. After extending SAREF to different domains, it was clear the need for broadening the scope of SAREF from home appliances and buildings to any device that can be found in smart applications; this motivated the change of name of the ontology from "Smart Appliances REFerence ontology" to "Smart Applications REFerence ontology".

In June 2018, another STF started in SmartM2M with the goal (among others) of consolidating SAREF with new reference ontology patterns, based on the experience from the EUREKA ITEA SEAS project. As a result of this STF, 37 different issues were identified and discussed in ETSI TR 103 549  [[i.20]](#[i.20]), proposing and agreeing on resolutions for most of them. Furthermore, it was identified the need for moving some transversal terms used in several extensions of SAREF to the core SAREF ontology, because of the broad applicability of such terms. This led to the release of SAREF ETSI TS 103 264 V3.1.1  [[i.7]](#[i.7]).

SAREF and its different extensions were developed quite independently by different teams of experts, sometimes in parallel. Sometimes different modelling decisions were made, with the result that SAREF extensions had important discrepancies. SmartM2M started to identify ontology patterns that may be used to homogenise the structure of SAREF extensions. In 2022, two new STFs started in SmartM2M with the goal to homogenise and facilitate the use of SAREF and existing 11 SAREF domain mapping by using common ontology patterns. A total of 91 different issues were identified and discussed in ETSI TR 103 781  [[i.21]](#[i.21]), and a set of SAREF Core reference ontology patterns was specified in ETSI TS 103 548  [[4]](#[4]).

A summary of the most relevant changes made in SAREF ETSI TS 103 264 V2.1.1  [[i.6]](#[i.6]), V3.1.1  [[i.7]](#[i.7]) and V3.2.1 (the present version) is available in annex A of [[0]](#[0]).

### SAREF Design Principles

The Smart Applications REFerence ontology (SAREF) is conceived as a shared model of consensus that facilitates the matching of existing semantic assets for building smart applications, reducing the effort of translating from one asset to another, since SAREF requires one set of mappings to each asset, instead of a dedicated set of mappings for each pair of assets.

Different semantic assets share some recurring, core concepts, but they often use different terminologies and adopt different data models to represent these concepts. Using SAREF, different assets can keep using their own terminology and data models, but still can relate to each other through their common semantics. In other words, SAREF enables semantic interoperability in smart applications through its shared, core concepts.

SAREF explicitly specifies recurring core concepts in smart applications, the main relationships between these concepts, and axioms to constrain the usage of these concepts and relationships. SAREF has been created based on the following fundamental principles:

**Reuse and alignment** of concepts and relationships that are defined in existing assets. Since a large amount of work was already being done in the smart appliances and in the Internet of Things domains, nothing has been re-invented, but harmonized and aligned what was already there. SAREF is based on the core concepts that were identified as especially relevant to describe the existing semantic assets for smart applications and is aligned to the main classes and properties of the oneM2M base ontology  [[1]](#[1]). SAREF reuses the following resources:

- oneM2M base ontology  [[1]](#[1]);
- W3C® SKOS ontology  [[5]](#[5]);
- OGC® and W3C® SOSA/SSN ontology  [[6]](#[6]);
- OGC® and W3C® Time ontology  [[7]](#[7]);
- OGC® GeoSPARQL vocabulary  [[8]](#[8]).

SAREF currently does not contain explicit references to upper ontologies such as DUL or SUMO. The use of upper ontologies is a best practice in ontology engineering, but the industrial world - main user of SAREF - is very pragmatic and is not acquainted with high-level upper ontologies. Introducing DUL would have unnecessarily complicated the understanding and, consequently, the adoption of SAREF by the industry. Anyway, SAREF has been built on a solid ontological foundation and can be related to DUL, but this was not explicitly done in order not to confuse industry users. Furthermore, SAREF currently has mappings to the OGC® and W3C® SOSA/SSN ontology, which is in turn related to DUL. Therefore, SAREF currently includes an indirect reference to DUL through the OGC® and W3C® SOSA/SSN ontology.

**Modularity** to allow separation and recombination of different parts of the ontology depending on specific needs. SAREF provides building blocks that can be combined to accommodate different needs and points of view. The starting point is the concept of device, which is actually common to all the semantic assets considered in the study, although some assets may refer to it with different names, such as resource or product, but mappings for that are provided in  [[i.4]](#[i.4]). A device is always designed to perform one or more functions, therefore, SAREF offers a list of basic functions that can be eventually combined in order to have more complex functions in a single device. Each function has some associated commands, which can also be selected as building blocks from a list. Depending on the function(s) it performs, a device can be found in some corresponding states that are also listed as building blocks, so that it is easy and intuitive to combine devices, functions and states. SAREF also provides a list of properties that can be used to further specialize the functioning of a device.

**Extensibility** to allow further growth of the ontology. Different stakeholders can specialize the SAREF concepts according to their needs and points of view, add more specific relationships and axioms to refine the general (common) semantics expressed in the reference ontology, and create new concepts, as long as they explicitly link these extensions to at least one existing concept and/or relationship in SAREF. The minimum requirement is that any extension/specialization shall comply with SAREF. Examples of extensions of SAREF in different domains are SAREF4ENER (energy domain)  [[i.8]](#[i.8]), SAREF4ENVI (environment domain)  [[i.9]](#[i.9]) and SAREF4BLDG (building domain)  [[i.10]](#[i.10]). SAREF and extensions are based on patterns that are used in different domains. SAREF extension developers should reuse SAREF reference ontology patterns as specified in ETSI TS 103 548  [[4]](#[4]).

**Maintainability** to facilitate the process of identifying and correcting defects, accommodate new requirements, and cope with changes in (parts of) SAREF. According to the extensibility criterion mentioned above, a new module/ontology can be created to further extend/specialize concepts of SAREF. The party that creates the extension should also be responsible for the maintenance of this extension and its evolution over time. SAREF extension developers shall comply with the SAREF Development Framework and Workflow as specified in ETSI TS 103 673  [[3]](#[3]). For an initial strategy proposed in ETSI to extend, maintain and evolve SAREF (and its extensions), see ETSI TR 103 411  [[i.3]](#[i.3]).

### SAREF Extensions

SAREF is the reference ontology for smart applications and contains recurring concepts that are used in several domains. SAREF has a close relation with the oneM2M Base Ontology, for which a mapping is defined in clause 6. As smart applications are not restricted to only one domain, it is possible that specific concepts for a certain domain are not part of SAREF. To be able to handle these additional concepts and provide different domains with a proper ontology that reflects the specific needs of that domain, extensions to SAREF should be created. Figure 11 shows SAREF as the core model to be used as basis for creating extensions in different domains, which are represented as rectangles. Each domain can have one or more extensions, depending on the complexity of the domain and the different needs. Extensions of SAREF have been created for:

- SAREF4ENER for the Energy domain in ETSI TS 103 410-1  [[i.8]](#[i.8]).
- SAREF4ENVI for the Environment domain in ETSI TS 103 410 2  [[i.9]](#[i.9]).
- SAREF4BLDG for the Building domain in ETSI TS 103 410-3  [[i.10]](#[i.10]).
- SAREF4CITY for the Smart City domain in ETSI TS 103 410-4  [[i.11]](#[i.11]).
- SAREF4INMA for the Industry and Manufacturing domain in ETSI TS 103 410-5  [[i.12]](#[i.12]).
- SAREF4AGRI for the Agrifood domain in ETSI TS 103 410-6  [[i.13]](#[i.13]).
- SAREF4AUTO for the Automotive domain in ETSI TS 103 410-7  [[i.14]](#[i.14]).
- SAREF4EHAW for the eHealth and Ageing Well domain in ETSI TS 103 410-8  [[i.15]](#[i.15]).
- SAREF4WEAR for the Wearables domain in ETSI TS 103 410-9  [[i.16]](#[i.16]).
- SAREF4WATR for the Water domain in ETSI TS 103 410-10  [[i.17]](#[i.17]).
- SAREF4LIFT for the Smart Lifts domain in ETSI TS 103 410-11  [[i.18]](#[i.18]).
- SAREF4GRID for the Smart Grids domain in ETSI TS 103 410-12  [[i.19]](#[i.19]).

Other extensions can be created for new domains and, if needed, also for the same domains for which extensions already exist.
 
<figure>
  <img src="diagrams/Modules.png" alt="SAREF and its extensions"/>
  <figcaption id="Figure_2">Figure 2: SAREF and its extensions</figcaption>
</figure>


### Develop, apply and evolve SAREF ontologies

The following provisions apply to SAREF:

- **Provision 1**: SAREF Core and SAREF Extension development shall conform to ETSI TS 103 673  [[3]](#[3]).
- **Provision 2**: Whenever appropriate, SAREF Extensions should reuse and extend SAREF Reference ontology patterns as specified in ETSI TS 103 548  [[4]](#[4]).
- **Provision 3**: SAREF shall use the SAREF Communication framework as defined in ETSI TS 103 267  [[2]](#[2]).

Some examples of device built using SAREF can be found in ETSI TR 103 411  [[i.3]](#[i.3]) and in the different SAREF extensions ( [[i.8]](#[i.8]) to  [[i.19]](#[i.19])).
