package org.etsi.osl.util;

import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecification;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCreate;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationUpdate;

import java.util.ArrayList;

public class ResourceSpecificationPayloadsMaker {

    // Change ServiceSpecificationCreate to ResourceSpecificationCreate
    public static ResourceSpecificationCreate createResourceSpecDataFromFile(ResourceSpecification resourceSpecFromFile) {
        // Parse the JSON file into a ServSpecCr object
        ResourceSpecificationCreate newResourceSpec = new ResourceSpecificationCreate();
        newResourceSpec.setName(resourceSpecFromFile.getName());
        newResourceSpec.setDescription(resourceSpecFromFile.getDescription());
        //newServSpec.setAttachment(new ArrayList<>(resourceSpecFromFile.getAttachment()));
        newResourceSpec.setIsBundle(resourceSpecFromFile.isIsBundle());
        //newServSpec.setRelatedParty(new ArrayList<>(resourceSpecFromFile.getRelatedParty()));
        //newServSpec.setResourceSpecification(new ArrayList<>(resourceSpecFromFile.getResourceSpecification()));
        //newServSpec.setServiceLevelSpecification(new ArrayList<>(resourceSpecFromFile.getServiceLevelSpecification()));
        //newServSpec.setServiceSpecCharacteristic(new ArrayList<>(resourceSpecFromFile.getServiceSpecCharacteristic()));
        //newServSpec.setServiceSpecRelationship(new ArrayList<>(resourceSpecFromFile.getServiceSpecRelationship()));
        newResourceSpec.setVersion(resourceSpecFromFile.getVersion());
        newResourceSpec.setValidFor(new TimePeriod());

        if (resourceSpecFromFile.getType() != null) {
            newResourceSpec.setType( resourceSpecFromFile.getType() );
        }
        return newResourceSpec;
    }

    public static ResourceSpecificationUpdate updateResourceSpecDataFromFile(ResourceSpecification resourceSpecFromFile) {
        ResourceSpecificationUpdate newResourceSpecToUpdate = new ResourceSpecificationUpdate();

        if (resourceSpecFromFile.getName() != null) {
            newResourceSpecToUpdate.setName(resourceSpecFromFile.getName());
        }

        if (resourceSpecFromFile.getDescription() != null) {
            newResourceSpecToUpdate.setDescription(resourceSpecFromFile.getDescription());
        }

        if (resourceSpecFromFile.isIsBundle() != null) {
            newResourceSpecToUpdate.setIsBundle(resourceSpecFromFile.isIsBundle());
        }

        if (resourceSpecFromFile.getVersion() != null) {
            newResourceSpecToUpdate.setVersion(resourceSpecFromFile.getVersion());
        }

        if (resourceSpecFromFile.getResourceSpecCharacteristic() != null) {
            System.out.println("ServiceSpecCharacteristic: " + resourceSpecFromFile.getResourceSpecCharacteristic());
            newResourceSpecToUpdate.setResourceSpecificationCharacteristic(new ArrayList<>(resourceSpecFromFile.getResourceSpecCharacteristic()));
        }

        return newResourceSpecToUpdate;
    }
}