package org.etsi.osl.util;

import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.etsi.osl.tmf.common.model.Any;
import org.etsi.osl.tmf.common.model.ELifecycle;
import org.etsi.osl.tmf.common.model.EValueType;
import org.etsi.osl.tmf.common.model.TimePeriod;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCharacteristic;
import org.etsi.osl.tmf.rcm634.model.ResourceSpecificationCharacteristicValue;
import org.etsi.osl.tmf.scm633.model.*;

public class ServiceSpecificationPayloadsMaker {

	public static ServiceSpecificationCreate createServiceSpecDataFromFile(ServiceSpecification serviceSpecFromFile) {
		// Parse the JSON file into a ServSpecCr object
		ServiceSpecificationCreate newServSpec = new ServiceSpecificationCreate();
		newServSpec.setName(serviceSpecFromFile.getName());
		newServSpec.setDescription(serviceSpecFromFile.getDescription());
		//newServSpec.setAttachment(new ArrayList<>(servSpec.getAttachment()));
		newServSpec.setIsBundle(serviceSpecFromFile.isIsBundle());
		//newServSpec.setRelatedParty(new ArrayList<>(servSpec.getRelatedParty()));
		//newServSpec.setResourceSpecification(new ArrayList<>(servSpec.getResourceSpecification()));
		//newServSpec.setServiceLevelSpecification(new ArrayList<>(servSpec.getServiceLevelSpecification()));
		//newServSpec.setServiceSpecCharacteristic(new ArrayList<>(servSpec.getServiceSpecCharacteristic()));
		//newServSpec.setServiceSpecRelationship(new ArrayList<>(servSpec.getServiceSpecRelationship()));
		newServSpec.setVersion(serviceSpecFromFile.getVersion());
		newServSpec.setValidFor(new TimePeriod());

		if (serviceSpecFromFile.getType() != null) {
			newServSpec.setType( serviceSpecFromFile.getType() );
		}
		return newServSpec;
	}

	public static ServiceSpecificationUpdate updateServiceSpecDataFromFile(ServiceSpecification serviceSpecFromFile) {
		ServiceSpecificationUpdate newServiceSpecToUpdate = new ServiceSpecificationUpdate();

		if (serviceSpecFromFile.getName() != null) {
			newServiceSpecToUpdate.setName(serviceSpecFromFile.getName());
		}

		if (serviceSpecFromFile.getDescription() != null) {
			newServiceSpecToUpdate.setDescription(serviceSpecFromFile.getDescription());
		}

		if (serviceSpecFromFile.isIsBundle() != null) {
			newServiceSpecToUpdate.setIsBundle(serviceSpecFromFile.isIsBundle());
		}

		if (serviceSpecFromFile.getVersion() != null) {
			newServiceSpecToUpdate.setVersion(serviceSpecFromFile.getVersion());
		}

		if (serviceSpecFromFile.getServiceSpecCharacteristic() != null) {
			System.out.println("ServiceSpecCharacteristic: " + serviceSpecFromFile.getServiceSpecCharacteristic());
			newServiceSpecToUpdate.setServiceSpecCharacteristic(new ArrayList<>(serviceSpecFromFile.getServiceSpecCharacteristic()));
		}

		return newServiceSpecToUpdate;
	}

	public static ServiceSpecificationUpdate getServiceSpecificationRelationshipsDataFromFile(ServiceSpecification serviceSpecFromFile, ServiceSpecification serviceSpecToPatch) {
		ServiceSpecificationUpdate newServiceSpecToUpdate = new ServiceSpecificationUpdate();
		if (newServiceSpecToUpdate.getServiceSpecRelationship() != null) {
			newServiceSpecToUpdate.setServiceSpecRelationship((List<ServiceSpecRelationship>) serviceSpecFromFile.getServiceSpecRelationship());
		}
		return newServiceSpecToUpdate;
	}

	public static ServiceSpecification updateServiceSpecDataFromAPIcall(ServiceSpecification serviceSpecFromFile, ServiceSpecificationUpdate newServiceSpecToUpdate) {


			if (newServiceSpecToUpdate.getName() != null) {
				serviceSpecFromFile.setName(newServiceSpecToUpdate.getName());
			}

			if (newServiceSpecToUpdate.getDescription() != null) {
				serviceSpecFromFile.setDescription(newServiceSpecToUpdate.getDescription());

			}

			if (newServiceSpecToUpdate.isIsBundle() != null) {
				serviceSpecFromFile.isBundle(newServiceSpecToUpdate.isIsBundle());

			}

			serviceSpecFromFile.setLastUpdate(OffsetDateTime.now(ZoneOffset.UTC));


			if (newServiceSpecToUpdate.getLifecycleStatus() != null) {
				serviceSpecFromFile.setLifecycleStatusEnum(ELifecycle.getEnum(newServiceSpecToUpdate.getLifecycleStatus()));
			}

			if (newServiceSpecToUpdate.getVersion() != null) {
				serviceSpecFromFile.setVersion(newServiceSpecToUpdate.getVersion());
			}

			/**
			 * Update ServiceSpecCharacteristic list We need to compare by name, since IDs
			 * will not exist
			 */
			if (newServiceSpecToUpdate.getServiceSpecCharacteristic() != null) {
				// reattach attachments fromDB

				Map<String, Boolean> idAddedUpdated = new HashMap<>();

				for (ServiceSpecCharacteristic charUpd : newServiceSpecToUpdate.getServiceSpecCharacteristic()) {

					boolean nameExists = false;
					for (ServiceSpecCharacteristic originalSpecChar : serviceSpecFromFile.getServiceSpecCharacteristic()) {
						if (originalSpecChar.getName()!=null && charUpd.getName()!=null && originalSpecChar.getName().equals(charUpd.getName())) {
							nameExists = true;
							idAddedUpdated.put(originalSpecChar.getName(), true);
							originalSpecChar.updateWith(charUpd);
							break;
						}
					}

					if (!nameExists) {
						serviceSpecFromFile.getServiceSpecCharacteristic().add(new ServiceSpecCharacteristic(charUpd));
						if ( charUpd.getName() == null ) {
							charUpd.setName( UUID.randomUUID().toString() );
						}
						idAddedUpdated.put(charUpd.getName(), true);
					}

				}

				List<ServiceSpecCharacteristic> toRemove = new ArrayList<>();
				for (ServiceSpecCharacteristic ss : serviceSpecFromFile.getServiceSpecCharacteristic()) {
					if (idAddedUpdated.get(ss.getName()) == null) {
						toRemove.add(ss);
					}
				}

				for (ServiceSpecCharacteristic serviceSpecCharacteristic : toRemove) {
					serviceSpecFromFile.getServiceSpecCharacteristic().remove(serviceSpecCharacteristic);
				}

			}

			return serviceSpecFromFile;
		}

	private static ServiceSpecCharacteristic copyResourceCharacteristic(ResourceSpecificationCharacteristic sourceChar) {

		ServiceSpecCharacteristic serviceSpecCharacteristicItem = new ServiceSpecCharacteristic();
		serviceSpecCharacteristicItem.setDescription( sourceChar.getDescription());
		serviceSpecCharacteristicItem.valueType( sourceChar.getValueType() );
		serviceSpecCharacteristicItem.configurable(sourceChar.isConfigurable());
		serviceSpecCharacteristicItem.setMinCardinality( sourceChar.getMinCardinality() );
		serviceSpecCharacteristicItem.setMaxCardinality( sourceChar.getMaxCardinality()  );
		serviceSpecCharacteristicItem.setValidFor( sourceChar.getValidFor() );
		for (ResourceSpecificationCharacteristicValue cv : sourceChar.getResourceSpecCharacteristicValue()) {
			ServiceSpecCharacteristicValue serviceSpecCharacteristicValueItem = new ServiceSpecCharacteristicValue();
			serviceSpecCharacteristicValueItem.setValue( new Any( cv.getValue().getValue(), cv.getValue().getAlias()));
			serviceSpecCharacteristicValueItem.isDefault( cv.isIsDefault() );
			serviceSpecCharacteristicValueItem.setUnitOfMeasure( cv.getUnitOfMeasure() );
			serviceSpecCharacteristicItem.addServiceSpecCharacteristicValueItem(serviceSpecCharacteristicValueItem );
		}
		return serviceSpecCharacteristicItem;
	}


	private static ServiceSpecCharacteristic addServiceSpecCharacteristic(ServiceSpecification serviceSpec, String aName, String description, Any any, EValueType eValueType) {
		ServiceSpecCharacteristic serviceSpecCharacteristicItem = new ServiceSpecCharacteristic();
		serviceSpecCharacteristicItem.setName( aName );
		serviceSpecCharacteristicItem.setDescription(description);
		serviceSpecCharacteristicItem.valueType( eValueType.getValue() );
		serviceSpecCharacteristicItem.configurable(false);
		serviceSpecCharacteristicItem.setMinCardinality(1);
		serviceSpecCharacteristicItem.setMaxCardinality(1);
		ServiceSpecCharacteristicValue serviceSpecCharacteristicValueItem = new ServiceSpecCharacteristicValue();
		serviceSpecCharacteristicValueItem.setValue( new Any( any.getValue() , any.getAlias()));
		serviceSpecCharacteristicValueItem.isDefault( true );
		serviceSpecCharacteristicValueItem.setUnitOfMeasure("N/A");
		serviceSpecCharacteristicItem.addServiceSpecCharacteristicValueItem(serviceSpecCharacteristicValueItem );
		serviceSpec.addServiceSpecCharacteristicItem(serviceSpecCharacteristicItem );
		return serviceSpecCharacteristicItem;
	}
}