
# CRIDGE: A Service to manage Custom Resources in a Kubernetes Cluster

<!-- **Intended Audience: OpenSlice Developers** -->

## Introduction
 
Kubernetes is an orchestration system for automating software deployment, scaling, and management. One can interact though the Kubernetes API and it has a set of objects ready for use out of the box. Custom Resource Definitions (CRDs) is a way that allows to manage things other than Kubernetes itself and allows to create our own objects The use of CRDs makes the possibilities of Kubernetes management almost limitless. You can extend the base Kubernetes API with any object you like using CRDs.
 
CRIDGE is a service designed to create and manage Custom Resources (CRs) based on Custom Resource Definitions (CRDs) installed on a Kubernetes cluster. By leveraging OpenSlice (OSL), CRIDGE enables seamless integration and orchestration within Kubernetes environments, utilizing Kubernetes APIs via the TMF APIs and models. Thus, more or less, OSL exposes Kubernetes APIs as TMF APIs and models.

By allowing the design and lifecycle management of services/resources that expose CRDs/CRs in a Kubernetes cluster via the TMF APIs, OSL can be used in many complex scenarios now involing resources from multiple domains. 

Pros, in a nutshell:

1. CRIDGE service allows OSL to:
    - Create and manage Custom Resources (CRs) using installed CRDs on a target Kubernetes cluster.
    - Facilitate complex orchestration scenarios by wrapping Kubernetes APIs as TMF APIs and models.
    - Handles connectivity to a Kubernetes cluster and manages the lifecycle of CRDs
    - Wraps the Kubernetes API, receives and provides resources towards other OSL services via the service bus
        
2. Enabling Loose Coupling and Orchestration
    - Language Flexibility: Developers can write CRDs in any language and expose them via the Kubernetes APIs. OSL will reuse these CRDs, enhancing flexibility and integration capabilities.
    - Familiar Deployment: Developers can create and deploy applications using familiar tools such as Helm charts, simplifying the process and reducing the learning curve.

3. Ecosystem Reusability
    - CRIDGE capitalizes on the extensive Kubernetes ecosystem, particularly focusing on operators (CRDs).
    - Key repositories and hubs such as artifacthub.io and Operatorhub.io can be utilized for finding and deploying operators.

4. Service Catalog Exposure and Deployment

    OSL can expose CRs in service catalogs, facilitating their deployment in complex scenarios.
    These scenarios may include service bundles that involve multiple systems, such as RAN controllers or other Kubernetes clusters, providing a robust and versatile deployment framework.
        
    
> Why the CRIDGE name? We wanted to build a service that maps TMF models to CRDs; a kind of a **CR**D to TMF br**idge**. Therefore CRIDGE was born.

## Approach

> OSL in general is responsible for exposing Service Specifications which are ready to be ordered and orchestrated, through TMFORUM Open APIs as defined in the OSL Service Spec Catalog. Usually for a service specification a corresponding (one or more) Resource Specification (resourceSpecificationReference) is registered in the OSL Resource Spec Catalog.
 
The following image illustrates the approach.

[![img01.png](img01.png)]()

1. A CRD in a cluster will be mapped in TMF model as a Resource specification and therefore can be exposed as a service specification in a catalog
2. Service Orders can be created for this service specification. The OSL Orchestrator (OSOM) will manage the lifecycle of the Service Order.
3. OSOM creates a Resource in OSL Resource inventory and requests (via CRIDGE) a new Custom Resource (CR) in the target cluster
	- The resource is created in a specific namespace (for example the UUID of the Service Order)
	- A CR in a cluster will be mapped in TMF model as a Resource in the resource Inventory
	- Other related resources created by the CRD Controller within the namespace are automatically created in OSL Resource Inventory under the same Service Order



[![img02.png](img02.png)]()



The provided image illustrates the architecture and workflow of the CRIDGE service, showing how it interacts with other components within a Kubernetes (K8s) cluster. 

Following, there is an explanation of the key components and flow in the diagram:

 - Other OSL Services: This box represents various OSL services such as Service Spec Catalogue, Resource Spec Catalogue, Service Inventory, Resource Inventory, and OSOM (OpenSlice Service Orchestration and Management).
 - Service Bus: This is the communication layer that facilitates interaction between the CRIDGE service and other OSL services.
 - CRIDGE: CRIDGE acts as a bridge that converts CRDs (Custom Resource Definitions) to TMF (TM Forum) APIs and models. It enables the creation and management of Custom Resources (CRs) in the Kubernetes cluster.
 - K8s API: The Kubernetes API server, which is the central control point for managing the Kubernetes cluster. CRIDGE interacts with the K8s API to manage CRDs and CRs.

    > CRD (Custom Resource Definition): A CRD is a way to define custom resources in Kubernetes cluster-wise. It allows the extension of Kubernetes API to create and manage user-defined resources. Example :
```yaml
apiVersion: apiextensions.k8s.io/v1
kind: CustomResourceDefinition
metadata:
	name: myresource.example.com
```

 - Namespaces: Kubernetes namespaces provide a way to partition resources within a cluster. The diagram shows that multiple namespaces (nsxx, nsyy, nsz) can be managed by CRIDGE.

	> CR (Custom Resource):  A CR is an instance of a CRD. It represents the actual custom resource that is managed within the Kubernetes cluster. Example shown in different namespaces:
```yaml
apiVersion: example.com/v1
kind: Myresource
metadata:
    name: example_resource_1
```

In a nutchell:

 - Various OSL services use the Service Bus to communicate with CRIDGE.
 - CRIDGE converts requests towards Kubernetes API and vice-versa, facilitating the integration of custom resources with other OSL services.
 - CRDs are defined and managed through the K8s API. The example CRD is named myresource.example.com.
 - Deploying CRs in Namespaces: Custom resources defined by the CRD are created and managed within different namespaces in the Kubernetes cluster. Each namespace can have its own instances of the custom resources.

> The example CRD myresource.example.com allows the creation of custom resources of type Myresource.

> Instances of Myresource are created in various namespaces, each with unique names like example_resource_1.
    	

## Mupliple Clusters Management

A CRIDGE service is usually responsible for managing one cluster. In the following diagram we show how it can be used for managing multiple clusters:


[![img03.png](img03.png)]()
    	
We assume that there is an OSL Management cluster that OSL is installed. CRIDGE is also installed there if we would like to manage resources in the same management cluster. 

 - Each CRIDGE service has its own configuration to connect to target cluster
 - Each CRIDGE can be installed either in the managed cluster or at the remote clusters. Connectivity is handled via the service bus.
 - **Important**: Each CRIDGE has a different context and API endpoints. This is used to request CRDs on a different cluster.
 
 
 > A CRD has a globally unique name for example mycrd.example.com. So we need to somehow identify also the different cluster.
 
 
##  Awareness for CRDs and CRs in a Cluster

> CRDs and CRs can appear (disappear) or change status at any time in a cluster. OSL Resource Inventory need to be aware of these events.
 
The implemented synchronization process is explained by the following diagram:


[![img04.png](img04.png)]()

 WatcherService is executed when the CRIDGE service application starts (see onApplicationEvent). Specifically:
 	
- KubernetesClientResource is a class that wraps fabric8’s KubernetesClient
	- This fabric8 KubernetesClient is initialized from the kubeconf and default context of the machine that runs CRIDGE
- On CRIDGE start-up we try to register this cluster and context to OSL catalogs.
	- See registerKubernetesClientInOSLResource method which registers the KubernetesContextDefinition in Resource Inventory as a LogicalResource via  createOrUpdateResourceByNameCategoryVersion method
- After the creation (or update) of this cluster as a Resource in OSL we proceed to create SharedIndexInformers for CustomResourceDefinition objects
- In this way, CRIDGE is always aware of all CRDs and their CRs in the cluster, even if a CRD or CR is added/updated/deleted in the K8S cluster outside of OSL (CRIDGE)
- The SharedIndexInformer events notify CRIDGE, which is always aware of all CRDs and their CRs in the cluster, even if a CRD or CR is added/updated/deleted in the K8S cluster outside of OSL (CRIDGE)
	- NOTE: The ADD event is raised every time also we run CRIDGE. Therefore, on ADD we do the method to createORupdate resource specifications and resources
- On ADD event:
	- The CRD is transformed to OSL Kubernetes domain model: method kubernetesClientResource.KubernetesCRD2OpensliceCRD
	- Then the OSL Kubernetes domain model is:
		- Transformed to Resource Specification and is stored to catalog (see createOrUpdateResourceSpecByNameCategoryVersion)
		- Transformed to Resource and is stored to catalog (see createOrUpdateResourceByNameCategoryVersion)
	- Conceptually while a CRD is a new resource located in the Kubernetes cluster resource, it is transformed also as a Resource Specification (a high-level entity) which is ready to be reused as an entity to other scenarios. The same concept as in Kubernetes where a CRD is a definition ready to be used for instantiating resources of this CRD
	- Then for this CRD a Watcher is added for all Resources of this Kind (fabric8’s GenericKubernetesResource entity) 	
	- When we have a newly added/updated/deleted resource of a certain CRD the method updateGenericKubernetesResourceInOSLCatalog is called for this object  (fabric8’s GenericKubernetesResource entity)
	- We examine if the resource has label org.etsi.osl.resourceId
		- This label is added by OSOM during service orders to correlate K8S requested resources with resources in inventory
	- If the label exists, we update the resource by ID updateResourceById
	- Else a resource is created in catalog
	

## Exposure of CRDs as Service Specifications 

See [Exposing Kubernetes Resources](../../service_design/kubernetes/exposing_kubernetes_resources.md) section for ways to design services around CRDs.


## Service Orchestration and CRDs/CRs

OSOM checks the presence of attribute _CR_SPEC at the RFS to make a request for a CR deployment

- _CR_SPEC is a JSON or YAML string that is used for the request
	- It is similar to what one will do with e.g. a kubectl apply
	- There are tools to translate a yaml file to a json

> LCM rules can be used to change attributes of this yaml/json file, before sending this for orchestration

However, the following issue needs to be solved: **How to map the CR lifecycle that is defined in the CRD with the TMF resource Lifecycle?**

For this We introduced the following characteristics:  

- _CR_CHECK_FIELD
- CR_CHECKVAL_STANDBY
- _CR_CHECKVAL_ALARM 
- _CR_CHECKVAL_AVAILABLE
- _CR_CHECKVAL_RESERVED
- _CR_CHECKVAL_UNKNOWN
- _CR_CHECKVAL_SUSPENDED

OSOM sends to CRIDGE a message with the following information:

- currentContextCluster: current context of cluster 
- clusterMasterURL: current master url of the cluster 
- org.etsi.osl.serviceId: This is the related service id that the created resource has a reference 
- org.etsi.osl.resourceId: This is the related resource id that the created CR will wrap and reference.  
- org.etsi.osl.prefixName: we need to add a short prefix (default is cr) to various places. For example in K8s cannot start with a number 
- org.etsi.osl.serviceOrderId: the related service order id of this deployment request 
- org.etsi.osl.namespace: requested namespace name 
- org.etsi.osl.statusCheckFieldName: The name of the field that is needed to be monitored in order to monitor the status of the service and translate it to TMF resource statys (RESERVED AVAILABLE, etc) 
- org.etsi.osl.statusCheckValueStandby: The CR specific value (of the CheckFieldName) that needs to me mapped to the TMF resource state STANDBY (see org.etsi.osl.tmf.ri639.model.ResourceStatusType) 
- org.etsi.osl.statusCheckValueAlarm: The CR specific value (of the CheckFieldName) that needs to me mapped to the TMF resource state ALARMS (see org.etsi.osl.tmf.ri639.model.ResourceStatusType) 
- org.etsi.osl.statusCheckValueAvailable: The CR specific value (of the CheckFieldName) that needs to me mapped to the TMF resource state AVAILABLE (see org.etsi.osl.tmf.ri639.model.ResourceStatusType) 
- org.etsi.osl.statusCheckValueReserved: The CR specific value (of the CheckFieldName) that needs to me mapped to the TMF resource state RESERVED (see org.etsi.osl.tmf.ri639.model.ResourceStatusType) 
- org.etsi.osl.statusCheckValueUnknown: The CR specific value (of the CheckFieldName) that needs to me mapped to the TMF resource state UNKNOWN (see org.etsi.osl.tmf.ri639.model.ResourceStatusType) 
- org.etsi.osl.statusCheckValueSuspended: The CR specific value (of the CheckFieldName) that needs to me mapped to the TMF resource state SUSPENDED (see org.etsi.osl.tmf.ri639.model.ResourceStatusType) 

- Parameters:
	- aService reference to the service that the resource and the CR belongs to
	- resourceCR reference the equivalent resource in TMF repo of the target CR. One to one mapping
	- orderId related service order ID
	- startDate start date of the deployment (not used currently)
	- endDate end date of the deployment (not used currently)
	- _CR_SPEC the spec that is sent to CRIDGE (in json)
- Returns:
	- a string response from CRIDGE. It might return "OK" if everything is ok. "SEE OTHER" if there are multiple CRIDGEs then some other CRIDGE instance will handle the request for the equivalent cluster. Any other response is handled as error


- CRIDGE receives the message and creates according to the labels the necessary CR
- It monitors the created resource(s) in namespace (see the Sequence Diagram in previous images)
- It monitors and tries to figure out and map the Status of the CR to the TMF Status according to the provided org.etsi.osl.statusCheck* labels
- It sends to the message bus the current resource for creation or update to the TMF service inventory

## Deployment of a new CR based on a CRD

The implemented process to deploy a CR is explained by the following diagram:


[![img05.png](img05.png)]()

- A message arrives to deploy a CR
	- The call examines if this CRIDGE service can handle the request (based on context and masterURL)
- There are headers received and a _CR_SPEC in json
- The _CR_SPEC is unmarshaled as GenericKubernetesResource
- Headers are in format org.etsi.osl.*
- These headers are injected as labels (see [Service Orchestration section](#service-orchestration-and-crdscrs))
- A  namespace is created for this resource
- Watchers are created for this namespace for e.g. new secrets, config maps etc, so that they can be available back as resources to the Inventory of OSL

## Probe further

- See examples of exposing Kubernetes Operators as a Service via OpenSlice:
    - [Offering "Calculator as a Service"](../../service_design/examples/calculator_crd_aas/calculator_crd_aas.md)
    - [Offering "Helm installation as a Service" (Jenkins example)](../../service_design/examples/jenkins_helm_install_aas/jenkins_helm_install_aas.md)
 	
 	
 	
 	

