
# Developing

OpenSlice backend services are mainly implemented with Java 17 or above and Spring boot.

OpenSlice uses various subsystems and depending on the module would you like to work, other subsystems must be present (you can disable them though in the code, e.g. at docker-compose.yaml file).

To get the latest development branch:
```bash
wget https://labs.etsi.org/rep/osl/code/org.etsi.osl.main/-/raw/develop/compose/deploy.sh 
sudo ./deploy.sh develop  #[or replace develop with other branch name]
```

You may follow the [installation process](https://osl.etsi.org/documentation/develop/deployment/), as described at "develop" tagged documentation.

To work on a specific subsystem e.g. org.etsi.osl.tmf.api, you must:

1a - Deploy only the core necessary subsystems through:
```bash
sudo docker compose --profile dev down;sudo docker compose --profile dev up -d --build
```
> Note **--profile dev** that will only deploy the core dependency subsystems, instead   of the whole OpenSlice.

1b - Or alternatively, commend out the respective container from the docker-compose.yaml file, so as to deploy the whole OpenSlice, except the subsystem you want to work on, following the provided installation steps.

2 - Clone the respective repository, e.g. https://labs.etsi.org/rep/osl/code/org.etsi.osl.tmf.api/-/tree/develop

3 - Code :)

## General requirements

- Docker should be installed in your development environment
- Run the core subsystems (see above sections)


## Slack

Feel free to join OpenSlice [Slack](https://openslice.slack.com) for any development oriented questions

## Examples on developing on specific subsystems

### VNF/NSD Catalog Management and NSD Deployment API service 

Clone the repository: https://labs.etsi.org/rep/osl/code/org.etsi.osl.portal.api/-/tree/develop

Check the docker-compose.yml file. Default port is 13080. Check specifically the datasource username/password, server port.

Make sure that the core subsystems are up and running.

Execute it with 
```bash
mvn spring-boot:run
```

For verification, Swagger API of the service is at `http://localhost:13000/osapi/swagger-ui/index.html`. 

There, you may try there various REST actions and authenticate via the OAuth server without the use of the UI.


### VNF/NSD Catalog Management and NSD Deployment WEB UI service 

The Web UI is written in AngularJS.

Clone the repository: https://labs.etsi.org/rep/osl/code/org.etsi.osl.portal.web/-/tree/develop

By default the project org.etsi.osl.portal.api exposes the folder ../org.etsi.osl.portal.web/src/ in a folder testweb (Check class MvcConfig.java in org.etsi.osl.portal.api) for development. (In production nginx is used). Point your browser to `http://localhost:13000/osapi/testweb/index.html/`

## Version/release management

Check this nice article on how we develop and release versions.

https://nvie.com/posts/a-successful-git-branching-model/

We develop in the develop branch and follow a issue driven development model.

---
## Wishlist

Check also our wishlist of new features. You can add your own.

See [Wishlist](./wishlist.md).








