# Authentication Server 

Authentication is based on oAuth2. Our authentication service is a Keycloak server which is deployed with Openslice deployment 

API users needs to authenticate. 
All APIs (except grant token request) must include Bearer token in request Authorization header.



##OAuth token

Get first an oauth token, using your username and password. 
```
curl -X POST http://portal.openslice.io/auth/realms/openslice/protocol/openid-connect/token -H 'Content-Type: application/x-www-form-urlencoded' -d 'username=demouser' -d 'password=demouser' -d 'grant_type=password' -d 'client_id=osapiWebClientId' 
```
response:

```
                                                       {"access_token":"eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6ICJHZFRjQnpxczg2VW10NTRVZV8ybTJyWHJkV3dzaWdSZE9EUldMYm1memNvIn0.eyJleHAiOjE1ODgyNDA1NzAsImlhdCI6MTU4ODI0MDI3MCwianRpIjoiOGI2ZTU0NWUtNDIyYy00NzFiLWEwN2UtYTUzYzY1NDQ0MzZmIiwiaXNzIjoiaHR0cDovL3BvcnRhbC5vcGVuc2xpY2UuaW8vYXV0aC9yZWFsbXMvb3BlbnNsaWNlIiwiYXVkIjoiYWNjb3VudCIsInN1YiI6ImExYTI3NjVhLWVjODMtNDQ1Ni1iN2IyLTIwNzMxOTg2ZTAzNSIsInR5cCI6IkJlYXJlciIsImF6cCI6Im9zYXBpV2ViQ2xpZW50SWQiLCJzZXNzaW9uX3N0YXRlIjoiMzM1MGY0OTMtNjYyNy00MzczLTg1NDQtZGVmZDI3YWQzYzc0IiwiYWNyIjoiMSIsImFsbG93ZWQtb3JpZ2lucyI6WyJodHRwOi8vbG9jYWxob3N0OjEzMDgyIiwiaHR0cDovL2xvY2FsaG9zdCIsImh0dHA6Ly9vcGVuc2xpY2UuaW8iLCJodHRwOi8vbG9jYWxob3N0OjEzMDAwIiwiaHR0cDovL2xvY2FsaG9zdDo0MjAwIiwiaHR0cDovL3BvcnRhbC5vcGVuc2xpY2UuaW8iXSwicmVhbG1fYWNjZXNzIjp7InJvbGVzIjpbIk5GVl9ERVZFTE9QRVIiLCJvZmZsaW5lX2FjY2VzcyIsInVtYV9hdXRob3JpemF0aW9uIiwiRVhQRVJJTUVOVEVSIiwiVVNFUiJdfSwicmVzb3VyY2VfYWNjZXNzIjp7ImFjY291bnQiOnsicm9sZXMiOlsibWFuYWdlLWFjY291bnQiLCJtYW5hZ2UtYWNjb3VudC1saW5rcyIsInZpZXctcHJvZmlsZSJdfX0sInNjb3BlIjoicHJvZmlsZSBlbWFpbCIsImVtYWlsX3ZlcmlmaWVkIjp0cnVlLCJwcmVmZXJyZWRfdXNlcm5hbWUiOiJkZW1vdXNlciJ9.TnzzpRLMD94UTKpT5_wkr1h4_3KUQmr4TGvFLpJ7cZx-Klrv8tB_eRkWnPqqzCAM9G21a1qXboL8MLMW8ECzG7HYKpobKOGr7LSczMOTdA2ZDyBCRUSOdW77pchu54tJ0ITEkFaDwSKMKKt04V_Sy4U-eIndj0XzzRlkDolWDnK4Z2lRaXAI6fMwOKx1Toa6RfOcemxtzl3pdtjPx92zo6MaKlbIqHK82lxdK0k8aQQaT6TmIrXbZKV2dU_1d3O0q0dVUEZJ_1kzwqOFkmxr9w0EnndC6ccYJlDAr_-GgUhhhNOn5v6tjYLUQdj5e4KEAsxIPzaCreK4un7mEAPmDw","expires_in":300,"refresh_expires_in":1800,"refresh_token":"eyJhbGciOiJIUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6ICIwZjUxMDk5Yy0wNTIzLTRjNGQtODM0Zi1iNDc0YzBjOTA1MzkifQ.eyJleHAiOjE1ODgyNDIwNzAsImlhdCI6MTU4ODI0MDI3MCwianRpIjoiZmViOTg5NWEtOTY5ZS00MzIzLWJjY2QtZTY2YzQ0NGE1MzJlIiwiaXNzIjoiaHR0cDovL3BvcnRhbC5vcGVuc2xpY2UuaW8vYXV0aC9yZWFsbXMvb3BlbnNsaWNlIiwiYXVkIjoiaHR0cDovL3BvcnRhbC5vcGVuc2xpY2UuaW8vYXV0aC9yZWFsbXMvb3BlbnNsaWNlIiwic3ViIjoiYTFhMjc2NWEtZWM4My00NDU2LWI3YjItMjA3MzE5ODZlMDM1IiwidHlwIjoiUmVmcmVzaCIsImF6cCI6Im9zYXBpV2ViQ2xpZW50SWQiLCJzZXNzaW9uX3N0YXRlIjoiMzM1MGY0OTMtNjYyNy00MzczLTg1NDQtZGVmZDI3YWQzYzc0Iiwic2NvcGUiOiJwcm9maWxlIGVtYWlsIn0.cDTx9BE1Df8EfGYm3VLr_MNFeymxZtJhMtlK7PVbIuk","token_type":"bearer","not-before-policy":1586797346,"session_state":"3350f493-6627-4373-8544-defd27ad3c74","scope":"profile email"}

```

The `access_token` will be used next as a Bearer.

```
curl http://portal.openslice.io/tmf-api/serviceCatalogManagement/v4/serviceCatalog -H 'Authorization: Bearer yJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6ICJHZFRjQnpxczg2VW10NTRVZV8ybTJyWHJkV3dzaWdSZE9EUldMYm1memNvIn0.eyJleHAiOjE1ODgyNDA1MjQsImlhdCI6MTU4ODI0MDIyNCwianRpIjoiYjg0NGYxZDAtMzk3Mi00YTMyLThiMWEtZDAxMDY3OGZjMTQ4IiwiaXNzIjoiaHR0cDovL3BvcnRhbC5vcGVuc2xpY2UuaW8vYXV0aC9yZWFsbXMvb3BlbnNsaWNlIiwic3ViIjoiYTFhMjc2NWEtZWM4My00NDU2LWI3YjItMjA3MzE5ODZlMDM1IiwidHlwIjoiQmVhcmVyIiwiYXpwIjoiYWRtaW4tY2xpIiwic2Vzc2lvbl9zdGF0ZSI6ImFmMmMzZmY1LTE4YWQtNDFkNC1hYTAyLTFlMGJkNzNmOTM5MSIsImFjciI6IjEiLCJzY29wZSI6InByb2ZpbGUgZW1haWwiLCJlbWFpbF92ZXJpZmllZCI6dHJ1ZSwicHJlZmVycmVkX3VzZXJuYW1lIjoiZGVtb3VzZXIifQ.SMtgV1E44_K_MQumGXZtWsLGVhYNaoM8Pk-DiFIZtUP4Zu-ervOsxHVQMX1frgVERR4jJidBcSshy9TnJ3UjF4l33WujHltbs-1UPy-gaIufVuEpl8RmbjOti3Up70vLfLXbzb6kN6WaahgobWXlbJsSXXwaBPQP6vSX5KigCa8TmzXcuqom14lOrlU-RB2zQTlJ30p7d9ag-a7o3I5m9GZWLJCZW2UYMl1JkskTHKgilA8HFQY4C9DYwWu8YDMyzqQSNumrTlURalBFidFbZvb1kp4dAyct8TysSWSbxxiwaL2RX1PWUqk-5Fpc1Q6BnBC8muMheiukFuoSkuADAg'^C
ubuntu@portal:~$ curl http://portal.openslice.io/tmf-api/serviceCatalogManagement/v4/serviceCatalog -H 'Authorization: Bearer eyJhbGciOiJSUzI1NiIsInR5cCIgOiAiSldUIiwia2lkIiA6ICJHZFRjQnpxczg2VW10NTRVZV8ybTJyWHJkV3dzaWdSZE9EUldMYm1memNvIn0.eyJleHAiOjE1ODgyNDA1NzAsImlhdCI6MTU4ODI0MDI3MCwianRpIjoiOGI2ZTU0NWUtNDIyYy00NzFiLWEwN2UtYTUzYzY1NDQ0MzZmIiwiaXNzIjoiaHR0cDovL3BvcnRhbC5vcGVuc2xpY2UuaW8vYXV0aC9yZWFsbXMvb3BlbnNsaWNlIiwiYXVkIjoiYWNjb3VudCIsInN1YiI6ImExYTI3NjVhLWVjODMtNDQ1Ni1iN2IyLTIwNzMxOTg2ZTAzNSIsInR5cCI6IkJlYXJlciIsImF6cCI6Im9zYXBpV2ViQ2xpZW50SWQiLCJzZXNzaW9uX3N0YXRlIjoiMzM1MGY0OTMtNjYyNy00MzczLTg1NDQtZGVmZDI3YWQzYzc0IiwiYWNyIjoiMSIsImFsbG93ZWQtb3JpZ2lucyI6WyJodHRwOi8vbG9jYWxob3N0OjEzMDgyIiwiaHR0cDovL2xvY2FsaG9zdCIsImh0dHA6Ly9vcGVuc2xpY2UuaW8iLCJodHRwOi8vbG9jYWxob3N0OjEzMDAwIiwiaHR0cDovL2xvY2FsaG9zdDo0MjAwIiwiaHR0cDovL3BvcnRhbC5vcGVuc2xpY2UuaW8iXSwicmVhbG1fYWNjZXNzIjp7InJvbGVzIjpbIk5GVl9ERVZFTE9QRVIiLCJvZmZsaW5lX2FjY2VzcyIsInVtYV9hdXRob3JpemF0aW9uIiwiRVhQRVJJTUVOVEVSIiwiVVNFUiJdfSwicmVzb3VyY2VfYWNjZXNzIjp7ImFjY291bnQiOnsicm9sZXMiOlsibWFuYWdlLWFjY291bnQiLCJtYW5hZ2UtYWNjb3VudC1saW5rcyIsInZpZXctcHJvZmlsZSJdfX0sInNjb3BlIjoicHJvZmlsZSBlbWFpbCIsImVtYWlsX3ZlcmlmaWVkIjp0cnVlLCJwcmVmZXJyZWRfdXNlcm5hbWUiOiJkZW1vdXNlciJ9.TnzzpRLMD94UTKpT5_wkr1h4_3KUQmr4TGvFLpJ7cZx-Klrv8tB_eRkWnPqqzCAM9G21a1qXboL8MLMW8ECzG7HYKpobKOGr7LSczMOTdA2ZDyBCRUSOdW77pchu54tJ0ITEkFaDwSKMKKt04V_Sy4U-eIndj0XzzRlkDolWDnK4Z2lRaXAI6fMwOKx1Toa6RfOcemxtzl3pdtjPx92zo6MaKlbIqHK82lxdK0k8aQQaT6TmIrXbZKV2dU_1d3O0q0dVUEZJ_1kzwqOFkmxr9w0EnndC6ccYJlDAr_-GgUhhhNOn5v6tjYLUQdj5e4KEAsxIPzaCreK4un7mEAPmDw'

Response:


[{"uuid":"9e186cd5-b2b2-4a06-b1d6-895720193bc9","lastUpdate":"2020-03-11T23:19:05Z","@baseType":"BaseEntity","@schemaLocation":null,"@type":"ServiceCatalog","href":null,"name":"Example Facility Services","description":"Example Facility Services","lifecycleStatus":"Active","version":"1.0","validFor":{"endDateTime":"2039-11-20T23:07:21Z","startDateTime":"2019-11-20T23:07:21Z"},"relatedParty":null,"id":"9e186cd5-b2b2-4a06-b1d6-895720193bc9","category":[{"@baseType":"org.etsi.osl.tmf.scm633.model.ServiceCategoryRef","@schemaLocation":null,"@type":"org.etsi.osl.tmf.scm633.model.ServiceCategoryRef","href":null,"name":"Generic Services","@referredType":null,"id":"98b9adf1-a1d6-4165-855f-153ddc2131b1"},{"@baseType":"org.etsi.osl.tmf.scm633.model.ServiceCategoryRef","@schemaLocation":null,"@type":"org.etsi.osl.tmf.scm633.model.ServiceCategoryRef","href":null,"name":"External","@referredType":null,"id":"08ffdb3c-6237-45d0-9f3a-d43b5fc5f0b6"},{"@baseType":"org.etsi.osl.tmf.scm633.model.ServiceCategoryRef","@schemaLocation":null,"@type":"org.etsi.osl.tmf.scm633.model.ServiceCategoryRef","href":null,"name":"eMBB","@referredType":null,"id":"ef2c90dd-b65e-4a9f-a9c3-427c9fb0219b"}]}]


```