# OpenSlice Deployment Guide with Docker Compose

## Requirements

### Hardware requirements:


| **Minimum Hardware Requirements** | **Recomended Hardware Requirements** |
| --------------------------------- | ------------------------------------ |
| 4 CPU cores                       | 8 CPU cores                          |
| 8 GB RAM                          | 16 GB RAM                            |
| 30 GB storage                     | 50 GB storage                        |

### Software Requirements:

* **Docker:** A running environment for Docker Compose services

## Preparing the environment

### 1. Backup your previous database if necessary:
```bash
sudo docker exec amysql /usr/bin/mysqldump -u root --password=letmein ostmfdb > backup_ostmfdb.sql
```
### 2. Install docker

> Since July 2023 Docker Compose V1 stopped receiving updates. OpenSlice fully reverted to Compose V2, which is integrated in the Docker installation.

### 3. Configure containers to properly resolve the DNS of your domain (optional)

```
sudo nano /etc/docker/daemon.json
```

and add:

```
{ 
  "dns": ["8.8.8.8", "8.8.4.4"]
}
```
After editing daemon.json restart docker daemon for the changes to take place

```bash
sudo systemctl restart docker
```

## Downloading the project

### 1. Create a new folder to download the project

```bash
mkdir openslice
```
```bash
cd openslice
```

### 2. Download the deployment script

Download the deployment / environment preparation script

```bash
wget https://labs.etsi.org/rep/osl/code/org.etsi.osl.main/-/raw/develop/compose/deploy.sh
```
Make it executable
```bash
sudo chmod +x deploy.sh
```

### 3. Run the deployment script

OpenSlice is a multi repo project. This script selects the same branch for all repositories of the project to pull from.

After that it builds the respective jar files locally and installs all the npm packages needed for the UI.

If you run the script without selecting a branch the the main branch is going to be selected.

We recommend:

* main branch for the most stable experience and
* develop branch for an experience with the latest features (for develop branch installation, it is strongly advisable that you may as well follow the [develop documentation](https://osl.etsi.org/documentation/develop/deployment/))

```bash
sudo ./deploy.sh develop #[or replace main with other branch name]
```

> **We recommend running the deploy.sh script with root permissions! In other case, some directories may not be accessible by the project building tools and hinder the smooth installation.**


## Configure Docker Compose services

### 1. Create configuration specific Docker Compose file from the template

```bash
cd org.etsi.osl.main/compose/
```
```bash
sudo cp docker-compose.yaml.configure docker-compose.yaml
```
### 2. Configure mysql-portal container *(optional)*

1. In folder `org.etsi.osl.main/compose/mysql-init` edit the file `01-databases.sql`.
2. In the `org.etsi.osl.main/compose/docker-compose.yaml` edit the credentials of the users that services use to connect to the databases, if you wish.
    * portaluser (default is 12345) and
    * keycloak (default is password)


### 3. Configure keycloak container *(optional)*

1. If you made changes to keycloak's mysql credentials:

    In folder `org.etsi.osl.main/compose/` edit the file `docker-compose.yaml`.

```
DB_DATABASE: keycloak
DB_USER: keycloak
DB_PASSWORD: password
```

2. If you want to change the keycloak admin password:

    In folder `org.etsi.osl.main/compose/` edit the file `docker-compose.yaml`

```
KEYCLOAK_PASSWORD: Pa55w0rd
```

### 4. Configure bugzilla container *(optional)*

If you want to utilise the Bugzilla connector:

In folder `org.etsi.osl.main/compose/` edit the file `docker-compose.yaml`
  
```
SPRING_APPLICATION_JSON: '{
  "spring.activemq.brokerUrl": "tcp://anartemis:61616?jms.watchTopicAdvisories=false",
  "spring.activemq.user": "artemis",
  "spring.activemq.password": "artemis",
  "bugzillaurl":"",
  "bugzillakey":"",
  "main_operations_product":""
}'
```

And add the provided Bugzilla installation information:

```
"bugzillaurl":"bugzillaurl.xx:443/bugzilla/",
"bugzillakey":"exampleKeyeqNNwxBlgxZgMEIne0Oeq0Bz",
"main_operations_product":"Main Site Operations" // this is the default product to issue tickets
```

Bugzilla should have the following components under the specified product:  

* NSD Deployment Request: Component used to schedule deployment req  
* Onboarding: Issues related to VNF/NSD Onboarding  
* Operations Support: Default component for operations support  
* Validation: Use to track validation processes of VNFs and NSDs  
* VPN Credentials/Access: Used for requesting VPN Credentials/Access   

Also in the 'Main Site Operations' product, a version named 'unspecified' must be created.

### 5. Configure osportalapi container (NFV services) *(conditional)*

Change the respective fields: 

- If you made changes to mysql and keycloak credentials.
- If you want to change logging level (TRACE / DEBUG / INFO / WARN / ERROR).

> ***If you are using a non-local domain, replace everywhere the http://keycloak:8080 with the respective {{protocol://domain.name}}, as well as "spring.portal.main.domain" property.***

In folder `org.etsi.osl.main/compose/` edit the file `docker-compose.yaml`
  
```
SPRING_APPLICATION_JSON: '{
  "spring.datasource.username":"root",
  "spring.datasource.password":"letmein",
  "spring-addons.issuers[0].uri": "http://keycloak:8080/auth/realms/openslice",
  "spring.security.oauth2.resourceserver.jwt.issuer-uri": "http://keycloak:8080/auth/realms/openslice",
  "springdoc.oAuthFlow.authorizationUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/auth",
  "springdoc.oAuthFlow.tokenUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/token",  
  "spring.portal.main.domain": "http://localhost",
  "logging.level.org.springframework" : "INFO"
}'
```

### 6. osscapi container (TMF API service) *(conditional)*

Change the respective fields: 

- If you made changes to mysql and keycloak credentials.
- If you want to change logging level (TRACE / DEBUG / INFO / WARN / ERROR).

> **If you are using a non-local domain, replace everywhere the http://keycloak:8080 with the respective {{protocol://domain.name}}.**

In folder `org.etsi.osl.main/compose/` edit the file `docker-compose.yaml`

```
SPRING_APPLICATION_JSON: '{
  "spring.datasource.username":"root",
  "spring.datasource.password":"letmein",
  "spring-addons.issuers[0].uri": "http://keycloak:8080/auth/realms/openslice",
  "spring.security.oauth2.resourceserver.jwt.issuer-uri": "http://keycloak:8080/auth/realms/openslice",
  "springdoc.oAuthFlow.authorizationUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/auth",
  "springdoc.oAuthFlow.tokenUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/token",  
  "logging.level.org.springframework" : "INFO"
}'
```

## Configure nginx

In folder `org.etsi.osl.main/compose/nginx` create a configuration specific `nginx.conf` file.


```bash
cd org.etsi.osl.main/compose/nginx/
```

```bash
sudo cp nginx.conf.default nginx.conf
```

If needed, in the nginx.conf file, edit the server_name for an non-local deployment.



## Configure Web UI

In folder `org.etsi.osl.portal.web/src/js/` create a configuration specific `config.js` file.

```bash
cd org.etsi.osl.portal.web/src/js
```

```bash
sudo cp config.js.default config.js
```

Edit the `config.js` file with the information of your domain. `ROOTURL` will automatically extract the the Origin (Protocol://Domain:Port) of the deployment, but you must change `APIURL` property, if you are not aiming for a localhost installation, e.g. "https://portal.openslice.io".

Example file:

```
{	  
  BUGZILLA: "ROOTURL/bugzilla/",
  STATUS: "ROOTURL/status/",
  APIURL: "http://localhost",
  WEBURL: "ROOTURL/nfvportal",
  APIOAUTHURL: "ROOTURL/auth/realms/openslice",
  APITMFURL: "ROOTURL/tmf-api/serviceCatalogManagement/v4"
}
```

## Configure TMF Web UI

In the folder `org.etsi.osl.tmf.web/src/assets/config` there are 3 files available for configuration:

* config.prod.json (Basic information + API configuration)
* theming.scss (CSS color palette theming)
* config.theming.json (HTML configuration - Logo, Favicon, Footer)


The first 2 files above (i.e. config.prod.json, theming.scss) are essential for the successful deployment of OpenSlice, thus created automatically during the initial deployment at `org.etsi.osl.tmf.web/src/assets/config` directory as a copy of the default ones from the remote repository.

Ensure that you check the `config.prod.json` and `theming.scss` files and readjust to your deployment if needed.

```bash
# Starting from the root project directory
cd org.etsi.osl.tmf.web/src/assets/config
```

E.g. You may edit "TITLE", "WIKI", etc properties with your domain title. Also configure TMF's API and Keycloak's location for the web application, if needed.

Example file:

```
{	      
    "TITLE": "OpenSlice by ETSI",
    "PORTALVERSION":"2024Q2",
    "WIKI": "https://osl.etsi.org/documentation",
    "BUGZILLA": "{BASEURL}/bugzilla/",
    "STATUS": "{BASEURL}/status/",
    "WEBURL": "{BASEURL}",
    "PORTAL_REPO_APIURL": "{BASEURL}/osapi",
    "ASSURANCE_SERVICE_MGMT_APIURL": "{BASEURL}/oas-api",
    "APITMFURL": "{BASEURL}/tmf-api",
    "OAUTH_CONFIG" : {
        "issuer": "{BASEURL}/auth/realms/openslice",
        "loginUrl": "{BASEURL}/auth/realms/openslice/protocol/openid-connect/auth",
        "tokenEndpoint": "{BASEURL}/auth/realms/openslice/protocol/openid-connect/token",
        "userinfoEndpoint": "{BASEURL}/auth/realms/openslice/protocol/openid-connect/userinfo",
        "redirectUri": "{BASEURL}/redirect",
        "logoutUrl": "{BASEURL}/auth/realms/openslice/protocol/openid-connect/logout", 
        "postLogoutRedirectUri": "{BASEURL}",
        
        "responseType": "code",
        "oidc": false,
        "clientId": "osapiWebClientId",
        "dummyClientSecret": "secret",
            
        "requireHttps": false,
        "useHttpBasicAuth": true,
        "clearHashAfterLogin": false,
      
        "showDebugInformation": true
    }
}
```

> The {BASEURL} placeholder in the file automatically detects the Origin (Protocol://Domain:Port) of the deployment and applies it to every respective property. E.g. If you are attempting a local deployment of OpenSlice, then {BASEURL} is automatically translated to "http://localhost". Similarly, you may use {BASEURL} to translate to a public deployment configuration, e.g. "https://portal.openslice.io".

If further customization, apart from the default provided, is needed for branding (Logo, Footer) then `config.theming.json` needs to be created in io.openslice.tmf.web/src/assets/config directory, as follows:

```bash
# Starting from the root project directory
cd org.etsi.osl.tmf.web/src/assets/config
```

```bash
sudo cp config.theming.default.json config.theming.json
```

> ***IMPORTANT NOTE:***
If you want to apply changes to the JSON configuration files without the need to rebuild the application, you have to apply the changes at the `org.etsi.osl.tmf.web/dist/io-openslice-portal-web/assets/config` directory. Although, it is <u>mandatory</u> to also apply these changes to the `org.etsi.osl.tmf.web/src/assets/config` for <u>persistancy</u>, as after any future rebuild of OpenSlice the `/dist` directory is being overwritten along with its contents. The OpenSlice team strongly recommends to always apply your changes to the TMF web UI configuration files at `org.etsi.osl.tmf.web/src/assets/config` and rebuild the application.

## Deploy OpenSlice via Docker Compose

After configuring the services, and editing the docker compose file accordingly, the docker compose instantiation command can be performed.

```bash
# Starting from the root project directory
cd org.etsi.osl.main/compose/
```

```bash
sudo docker compose --profile prod down;sudo docker compose --profile prod up -d --build
```

> Depending on your machine, this process might take time. if for any reason the deployment fails during first time, please rerun the above before any further measures.


## Validating deployments and container monitoring

You can monitor containers' status with portainer at port 9000 (http://your-ip:9000).

Initially, you may monitor the local machine at portainer.

Please check that all containers are in running state.


## Post installation steps 

After the successful deployment of OpenSlice, to ensure the E2E user experience, **this section is mandatory**. It contains crucial configuration in regard of authentication and user creation.

### Configure Keycloak server

The Keycloack server is managing authentication and running on a container at port 8080. It is also proxied to your host via nginx under http://localhost/auth. 

- Navigate to http://domain.com/auth/ or https://domain.com/auth/, (http://ipaddress:8080/auth/ or https://ipaddress:8443/auth/ which are directly accessible without proxy) 

- Navigate to Administration Console 

- Login with the credentials from section [Configure keycloak container](#3-configure-keycloak-container-optional). Default values are:
    - user: admin and 
    - password: Pa55w0rd

> if you are running in HTTP you will get a message: HTTPS required.

To resolve this issue <u>when running in HTTP</u>: 

- Select the master realm from top left corner
- Go to login Tab and select "Require SSL": None
- Repeat for realm Openslice


> If you are running in HTTPS, then "Require SSL" can be left unchanged to external requests.

#### 1. Configure redirects

Navigate to realm Openslice > Clients > osapiWebClientId and change the Root URL to your domain. 

Also, insert your domain, e.g. http://example.org/*, at:
* Valid Redirect URIs
* Web Origins

#### 2. Configure email

Keycloak allows new users to register. Subsequently, this will also allow new users to register to the OpenSlice portal.

Navigate to realm Openslice > Realm Settings > Login Tab > check User registration, Verify email, Forgot password etc.

Finally, enter the details of the mail server at the Email Tab.

> Email configuration is optional for test runs, but if not provided the above functionalities (e.g. external user registration) will not be possible.


#### 3. Add an OpenSlice admin user

This step is mandatory so as to access the OpenSlice Web UI. To add an OpenSlice admin user you must:

- Navigate to realm Openslice > Users > Add user
- Set a password
- Upon creation, navigate to Role Mappings and add ADMIN to Assigned Roles list

> That user is different from the Keycloak admin user. It is required to login and browse the OpenSlice Web UI. The Role ADMIN guarantee full access through the OpenSlice UI, thus such a user is always required.

### Keycloak at localhost

> **This is an important step if you run Keycloak on localhost!**

1 - Edit your Hosts File, adding the line below

```127.0.0.1 keycloak```

Hosts File Location:

 - In Linux/Unix, the file's location is at /etc/hosts 

 - In Windows, its location is at c:\Windows\System32\Drivers\etc\hosts

2 - Replace http://localhost/auth/ with http://keycloak:8080/auth/ in your Keycloak config for AngularJS and Angular (see examples below).


> Explanation

Nginx uses the http://keycloak:8080 URL, which is accessible via the internal docker system's network.
The Front-end (TS/Angular) shall also use the http://keycloak:8080.
This way, you will not get the invalid token error, as the API is acquiring the token from http://keycloak:8080 (internally) and the Front-end is getting verified by an issuer at the same URL, as well.



2.1 - For the Angular configuration (TMF portal UI), navigate to  org.etsi.osl.tmf.web/src/assets/config and edit config.prod.json

```bash
# Starting from the root project directory
cd org.etsi.osl.tmf.web/src/assets/config
```

```bash
nano config.prod.json
```

After editing, the displayed properties should look like the example below:

```yaml
{	      
  "OAUTH_CONFIG" : {
      "issuer": "http://keycloak:8080/auth/realms/openslice",
      "loginUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/auth",
      "tokenEndpoint": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/token",
      "userinfoEndpoint": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/userinfo",
      "redirectUri": "{BASEURL}/redirect",
      "logoutUrl": "http://keycloak:8080/auth/realms/openslice/protocol/openid-connect/logout", 
      "postLogoutRedirectUri": "{BASEURL}",
  }
}
```

> Note the difference in changing {BASEURL} -> http://keycloak:8080

> If you want the changes to take place immediately without rebuilding the project, then repeat the process for org.etsi.osl.tmf.web/dist/org.etsi.osl.tmf.web/assets/config/config.prod.json

2.2 - For the AngularJS configuration (NVF portal UI), navigate to org.etsi.osl.portal.web/src/js and edit config.js
   
```bash
# Starting from the root project directory
cd org.etsi.osl.portal.web/src/js
```
   
```bash
nano config.js
```
   
After editing, the displayed properties should look like the example below:

```
var appConfig = angular.module('portalwebapp.config',[]);


appConfig.factory('APIEndPointService', function() {
   return {	      
      APIOAUTHURL: "http://keycloak:8080/auth/realms/openslice",
   };
});
```

> Note the difference in "APIOAUTHURL" property, changing ROOTURL -> http://keycloak:8080


### NFV Orchestrator Configuration

After successfully deploying and configuring OpenSlice, you may configure its environment (e.g. the NFVO) that will facilitate the deployment of NFV artifacts.

See [NFV Orchestrator Configuration](./nfvoconfig.md).
