# Documenting

OpenSlice's documentation runs on [MkDocs](https://www.mkdocs.org/).

## Eligibility

Documenting OpenSlice is limited to active contributors. So, if you:

1. are an active member or participant;
2. wish to contribute to it;
3. you're ready!

##  System and Structure

[MkDocs](https://www.mkdocs.org/) is a fast and simple static site generator that's geared towards building project documentation. Documentation source files are written in `Markdown`, and configured with a single `YAML` configuration file. Start by reading the [introductory tutorial](https://www.mkdocs.org/getting-started/), then check the [User Guide](https://www.mkdocs.org/user-guide/) for more information.

### How does it work?

There are 2 ways to upgrade documentation published on the [OSL Documentation] website:

  * Push any change on **develop** branch will force update of the **develop** version on the [OSL Documentation] website;
  * Create a tag, this will create a version with the tag name on the [OSL Documentation] website.

### Branches

This documentation repository has 2 protected branches:

  * **main**: stable timeline on which tags are made;
  * **develop**: edge timeline, also published on the [OSL Documentation] website.

### Structure

In the `mkdocs.yml` file you will find the navigation structure of the documentation, there you can sections with sub-sections.

*For example:*

```yaml
nav:
  - Overview:
    - Introduction: index.md
    - Deployment examples: deployment_examples.md
    - History: history.md
    - OpenSlice under ETSI: etsi_osl.md
  - Getting Started:
    - Deployment: 
      - Introduction: ./getting_started/deployment/introduction.md
      - Docker Compose: ./getting_started/deployment/docker_compose.md
      - Kubernetes: ./getting_started/deployment/kubernetes.md
    - Portals: ./getting_started/portals.md
[...]
```

Please take a moment to understand the current structure of the documentations and think to update after contributing if necessary.

### Main Page

The page shown first is at **doc/index.md**. That page should be updated with the latest changes of OpenSlice and should reference the version (useful shortcut is ``{{{ documentation_version }}}``).

## Getting Started

To contribute to OpenSlice's documentation, you need to follow these easy steps:

1) Clone the [Documentation repository](https://labs.etsi.org/rep/osl/documentation) with:

```bash
git clone https://labs.etsi.org/rep/ocf/documentation.git
```

2) Checkout the develop branch (incoming contributions are only accepted to the **develop** branch):

```bash
cd ./documentation
git checkout develop
```

3) Setup a virtual environment:

* On Linux/macOS:

  ```bash
  python3 -m venv venv # Linux/macOS
  source venv/bin/activate #Linux/macOS
  ```

* On Windows:

  ```bash
  python -m venv venv # Windows
  venv\Scripts\activate # Windows
  ```

4) Setup a local ``mkdocs`` server by installing requirements:

```bash
python -m pip install -r requirements.txt
```

4) Wait for all downloads to finish and start the local ``mkdocs`` server:

```bash
mkdocs serve
```

5) Document! 😊

> You should always make sure that the local *MkDocs* server terminal is not producing any `INFO`/``WARNING`` messages regarding your contributions.

### Add Documentation During Development

To update the documentation properly during development, follow those additional steps:

1. Create an issue on the documentation [GitLab](https://labs.etsi.org/rep/osl/documentation/-/issues) repository;
2. Create a new branch with the **develop** branch as a source;
3. Update the documentation and any relevant parts (ie: the ``index.md`` with new functionalities for the latest version);
4. Check if errors are not being produced by ``mkdocs`` [locally](#getting-started);
5. Commit and push changes to the new branch;
6. Create a MR request towards **develop**;
7. Send the request for review and approval to at least one **TSC Member**.

> The documentation website supports branches, so your accepted changes will be reflected to the **develop** branch which then becomes the **release** branch after each corresponding cycle.

### Release a New Version of the Documentation

When **OpenSlice** code repository is ready for a new release, we need to follow these steps (made by a **TSC Member**):

1. Create a MR from **develop** towards **main**;
2. When **develop** is merged to **main**... then **create a tag with the released version** scheme... and you're done!

[OSL Web]: https://osl.etsi.org/ "OSL Web"
[OSL Documentation]: https://osl.etsi.org/documentation/ "OSL Documentation"
