# Lifecycle Management Rules - LCM Rules


Lifecycle Management Rules: Defining complex conditions and actions during the lifecycle of a service and any necessary modifications throughout the service lifecycle.


## Intended Audience: Service Designers

 OpenSlice end-to-end (E2E) service orchestrator follows some predefined workflows to manage a service lifecycle (They are described in BPMN language and included in our orchestration engine)

 So in the system there are already predefined recipes, which in each process-step of the workflow some piece of code is executed. 

 How is it possible to intervene in the workflow process and inject some user defined actions? The next image illustrates the idea

[![lcm](./lcm/img02.png)](./lcm/img02.png)


 ## How is it possible to intervene in the workflow process and affect it?

LCM Rules are used for defining complex conditions and actions during the lifecycle of a service. In Openslice there are the following types of rules defined:

* PRE_PROVISION
* CREATION
* AFTER_ACTIVATION 
* SUPERVISION 
* AFTER_DEACTIVATION 

The following figure displays the different phases that the rules are performed, during the lifecycle of a Network Service Instance. 


[![lcm](./lcm/img03.png)](./lcm/img03.png)


* PRE_PROVISION rules: Run only once just before creating a service with a given priority. 
* CREATION rules: Run while the referenced service dependencies of a service are created
* AFTER_ACTIVATION rules: Run only once just after a service get the ACTIVE state
* SUPERVISION rules: Run when a characteristic of a service is changed and the service is in the ACTIVE state 
* AFTER_DEACTIVATION rules: Run only once just after a service get the INACTIVE/TERMINATED state 

In general the rules allow to perform many actions during service LCM. These are some examples:

* Modify service specification parameters before the instantiation of a service (or during operation) based on other dependencies. These parameters might be part of other services already included in Service order
* Translate GST/NEST parameter values to other values passed later to NFVO for instantiation or control
* Define complex OSM Configs based on other dependencies and passing variables
* Define any dependencies when creating the referenced services
* Dynamically include new service dependencies
* Create new service orders so include dynamically other services
* Call external (RESTful) services (via http(s), define payload, examine response)




## Examine if the rules are executed successfully 

Rules are transformed automatically to executable code (currently is Java). If a rule is performed successfully  or has any issues (e.g. unexpected syntax errors or exceptions) appear in OSOM logfiles and also tey are attached as Notes to the running Service.


## Probe further

* In the [Service Design](../service_design/intro.md) section we present in details the Lifecycle rules and how one can design them
* Many of them are used in our provided Service Design [examples](../service_design/examples/intro.md)