# Service Design in OpenSlice

This section offers details on how to design Service Specifications and expose them in Service Catalogs

## Intended Audience: Service Designers

Service Designers create detailed service specifications, which are then managed and exposed in service catalogs. These services are integrated into OpenSlice E2E service orchestration framework to automate and optimize the delivery of network services.


OpenSlice can be used to design service specifications for various services, even not networking related services. Here we cover how service designers can expose services related to the NFV world and the containerized world.

## What's next

* [Design and expose services based on containerized resources via the Kubernetes Operator pattern](ExposingKubernetesResources.md)
* [Design and expose services based on NFV artifacts](./nfv/design_nfv_services.md)



