# Service Inventory

Service Inventory contains references to running services that realize a Service Order.

## Intended Audience: Service Designers, OpenSlice administrators, Users


The Service Inventory is a repository that maintains detailed records of all active services and the underlying resources that support them. It acts as a central repository, tracking the lifecycle of each service from provisioning to decommissioning, and includes references to the specific virtual and physical resources that realize the service, such as servers, network components, storage, and software instances. 

This inventory enables real-time visibility into the status, configuration, and dependencies of each service, facilitating effective management, troubleshooting, and optimization. 

By providing a view of the active services, the Service Inventory includes services/resource allocation, and ensures that services are delivered in alignment with the initial request. 


## UI management

Through the menu and dedicated forms the administrator can manage the Service Inventory and any active Services (reconfigure or terminate).Various examples in this document will guide you to the usage and the management of the Services in Service Inventory.

## API exposed

When installing OpenSlice the API endpoints can be browsed at: 
```
[YOURDOMAIN]/tmf-api/swagger-ui/index.html?urls.primaryName=tmf-api-638-ServiceInventoryManagement-v4.0.0
```

endpoint examples:

/serviceInventory/v4/service List or find Service objects


## Probe further

* See [Ordering Services from catalogs](../service_ordering/ordering_services.md)
* See [Service Design](../service_design/intro.md)

