
# Developing

OpenSlice backend services are mainly implemented with Java 17 or above and Spring Boot.

OpenSlice uses various subsystems and depending on the module would you like to work, other subsystems must be present *(you can disable them though in the code, e.g. at docker-compose.yaml file)*.

## General requirements

- Docker should be installed in your development environment
- Run the core subsystems (see [related](#contribute-to-a-subsystem) section)


## Version/release management

Check [this](https://nvie.com/posts/a-successful-git-branching-model/) nice article on how we develop and release versions.

We develop in the `develop` branch and follow a issue driven development model.

## Getting Started

To get the latest development branch, execute:

```bash
wget https://labs.etsi.org/rep/osl/code/org.etsi.osl.main/-/raw/develop/compose/deploy.sh 
sudo ./deploy.sh develop  #[or replace develop with another branch name]
```

You may follow the [installation process](https://osl.etsi.org/documentation/develop/deployment/), as described at `develop` tagged documentation.

## Contribute to a subsystem

To work on a specific subsystem e.g. `org.etsi.osl.tmf.api`, you must:

1. Deploy only the core necessary subsystems through:

    ```bash
    sudo docker compose --profile dev down;sudo docker compose --profile dev up -d --build
    ```
    > Note **--profile dev** that will only deploy the core dependency subsystems, instead   of the whole OpenSlice.

    *OR*

    Alternatively, comment out the respective container from the `docker-compose.yaml` file, so as to deploy the whole OpenSlice, except the subsystem you want to work on, following the provided installation steps.

2. Clone the respective repository, for example: [https://labs.etsi.org/rep/osl/code/org.etsi.osl.tmf.api/-/tree/develop](https://labs.etsi.org/rep/osl/code/org.etsi.osl.tmf.api/-/tree/develop) (the clone URLs are available at this link)

3. Code! 😊


## Examples of developing on specific subsystems

### VNF/NSD Catalog Management and NSD Deployment API service 

You need to:

1. Clone the repository: `https://labs.etsi.org/rep/osl/code/org.etsi.osl.portal.api/-/tree/develop`

2. Check the docker-compose.yml file. Default port is 13080. Check specifically the datasource username/password, server port.

3. Make sure that the core subsystems are up and running.

    Execute it with:
    ```bash
    mvn spring-boot:run
    ```

> For verification, Swagger API of the service is at `http://localhost:13000/osapi/swagger-ui/index.html`. 
 There, you may try there various REST actions and authenticate via the OAuth server without the use of the UI.

### VNF/NSD Catalog Management and NSD Deployment WEB UI service 

The Web UI is written in `AngularJS`. To run it:

1. Clone the repository: [https://labs.etsi.org/rep/osl/code/org.etsi.osl.portal.web/-/tree/develop](https://labs.etsi.org/rep/osl/code/org.etsi.osl.portal.web/-/tree/develop) (the clone URLs are available at that link)

    > By default the project `org.etsi.osl.portal.api` exposes the folder `../org.etsi.osl.portal.web/src/` in a folder testweb (check class `MvcConfig.java` in `org.etsi.osl.portal.api`) for development. (In production *nginx* is used)
    
2. Point your browser to `http://localhost:13000/osapi/testweb/index.html/`

## Reach us

We are available on different channels.

### Slack

Feel free to join OpenSlice's [Slack](https://openslice.slack.com) workspace for any development oriented questions *(preferred)*.

### E-mail

If you are a member or a participant, you can also reach out on the `OSL_TECH` mailing list.

For administrative support, contact `SDGsupport@etsi.org`.

---

## Wishlist

Check also our wishlist of new features. You can add your own.

See [wishlist](./wishlist.md).