# OpenSlice Service Specification

OpenSlice offers complete management of Service Specifications.

## Intended Audience: Service Designers

Service Specification is an entity that describes a service offering. There are two types of Service Specifications:

* Resource Facing Service Specification
* Customer Facing Service Specification

## Resource Facing Service Specification

Is a Service that It exposes a resource Specification as a Service. (For example expose a Network Service Descriptor as a Service)

## Customer Facing Service Specification

Customer Facing Service Specifications - or also CFSSpec (organized in Service Categories) are exposed to users for Service Orders. Usually it exposes other CFSSpec(as a Service Bundle) or other RFSSpecs

## Definition

Usually a Service Specification has the following aspects:

* Name, Description, Version
* Marked as a Service Bundle: Combines multiple services into a single offering to provide added value to customers.
* if is is a Bundle then you must add Related Service Specifications
* If it is a Resource Facing Service Specification has multiple related Resource Facing Service Specifications
* Characteristics: a list of service characteristics and their type (TEXT, INTEGER, etc)
  * Also they can be exposed as "Configurable" so to allow to end-users during the Service Order to select or type values
* A logo, displayed if needed in the Service Marketplace
* Any attachments that further help the user
* Life Cycle Rules that determine the behavior of the Service and instrument the Service Orchestrator. More on Life Cycle Rules [here](./lcm_rules_intro.md)

Service Designers can create a Service Specification from scratch or use some templates:

    * Create a Service based from a Network Service Descriptor (NSD)
    * Create a Service based on a Kubernetes Operator
    * Create a Service based on the GSMA GST - Generic Slice Template

## UI management

In the UI this looks like the following.

Through the menu and dedicated forms the administrator can manage the Service Specifications. Various examples in this document will guide you to the usage and the design of the services.

## API exposed

When installing OpenSlice the API endpoints can be browsed at: 
```
[YOURDOMAIN]/tmf-api/swagger-ui/index.html?urls.primaryName=tmf-api-633-ServiceCatalogManagement-v4.0.0
```

endpoint examples:

/serviceCatalogManagement/v4/serviceSpecification List or find ServiceSpecification objects



## Example Use Case

Scenario: A service provider wants to offer a new managed XXXX service to enterprise customers.

  * Service Definition:  Create a service specification template for the XXXX service, including specifications for bandwidth, network features, and performance metrics.


## Probe further

* Read the model of Service Catalogs in TMF [TMF633 Service Catalog API User Guide v4.0.0](https://www.tmforum.org/resources/specification/tmf633-service-catalog-api-user-guide-v4-0-0/)
* Check a demo of the API [here](http://portal.openslice.eu/tmf-api/swagger-ui/index.html?urls.primaryName=tmf-api-633-ServiceCatalogManagement-v4.0.0)
* Check a demo of the Service Specifications in Catalog and Categories [here](http://portal.openslice.eu) (You need to login - see main guide page)
* Check the GSMA GST