# Service Ordering

**Intended Audience: OpenSlice Users**

Having covered how OpenSlice can facilitate the Service Design and exposure, this section introduces the process of ordering the designed Service Specifications and their fulfillment process.

To that extend, we assume that the OpenSlice Service Designers have already created the designated, detailed Service Specifications that are willing to expose to the OpenSlice users, or to potential Communication Service Customers (CSCs). Furthermore, the designed Service Specifications are categorized in the respective Service Categories and Catalogs.

## Service Marketplace

The OpenSlice User can browse the Services Marketplace for available services. There is a designated Service Catalog Explorer that goes through all the available Catalogs and the respective Categories, as seen in the following figure.

![Service Marketplace](./images/service_marketplace.png)

The User can filter offered services within a Category, and when needed, preview a desired service for more information, as well as configurable/non-configurable characteristics.

![Service Preview](./images/service_preview.png)

Once satisfied, the User may place the selected service(s) in the Order List. An icon at the top-right part of the navbar presents the number of services in the Order List. Clicking that icon, the flow is navigated to the Service Order Checkout page.

## Service Order Checkout

Here, the User can see the Order List in detail and configure each Order Item. Specifically, all the configurable characteristics (if any) of a service can be altered and customized, as well as some general preferences, i.e. notes and Service Order duration.

> The ultimate duration may differ from the one requested by the User, as it has to be approved by an Administrator.

![Service Order Checkout](./images/service_order_checkout.png)

## Service Order Preview

When the User clicks the Order Service button from the previous step, a Service Order is created and saved in the respective database. A User can browse its issued Service Order(s) by the "My Service Orders" tab. A freshly issued Service Order acquires the state of *INITIAL*. By selecting a Service Order, the User navigates to the Service Order Overview and Management page. Here, once again, the User may change the requested duration, add notes towards the Administrator, or edit the respective Order Items (change the user-defined characteristics).

![Service Order Overview](./images/service_order_preview.png)

Once the Service Order is reviewed by an Administrator, the state is expected to switch to *ACKNOWLEDGED*, which signals that the order is ready to be processed by the orchestrator. When this happens, the state will switch once more to *IN PROGRESS* and eventually to *COMPLETED*, once the order is successfully fulfilled. At this stage, the User can browse each Order Item and navigate to the created service instances in the Service Inventory. Each service contains relevant information about its execution and deployment and can also be edited.

![Service Order Overview - Completed](./images/service_order_preview_completed.png)

The User can edit the created Services or opt to terminate the Service Order earlier than the requested duration, by selecting the Order Item and click on the termination icon.