# Design Generic Services

**Intended Audience: OpenSlice Service Designers**

This section introduces a way to integrate generic and developer-owned services/controllers within the OpenSlice (OSL) lifecycle. 

## Introduction

Since Release 2024Q2, OSL introduces extensive support for Kubernetes operators exposed as services within OSL catalogs. However, inspired by the operator pattern, developers can now write their own resource controllers and attach them to the OSL service bus. OSL's Service orchestrator (OSOM) has the capability of contacting external controllers, given a specific resource category that this controller can manage.

The intended goal is to write a controller that can handle resources of a specific type, e.g., resource Specifications for managing resources of a specific category. Therefore, a new resource controller can be registered into OSL, in the form of a Resource Specification with a designated name, category and version, and the implementation of the controller shall listen for messages in queues as specified by the name, category and version of the registered Resource Specification. Specifically, it shall listen for CREATE/UPDATE/DELETE actions, with the following scheme:

- CREATE / category_name / version
- UPDATE / category_name / version
- DELETE / category_name / version

## Workflow

In a nutshell, the Resource Definition/Specification is registered at startup. During Service Orders of related-to-the-specification services, the controller is invoked (via message queue) and a new service and its underlying resource are created, with messages passing between the service and resource layers. The resource controller processes any updates or status changes. OSOM checks the final status of the deployed resource to confirm it is ready or identify any potential errors. The following diagram describes what the resource controller needs to perform, showcasing how the “Resource Controller” component interacts with various services (TMF API, Message Queue MQa, and OSOM) to register the needed resource types, create new resources (Resource Facing Services - RFSs and underlying resources), process updates, and check the resource’s status.

1.	**Controller Registration (top swimlane)** – This happens when the controller bootstraps
    * **Register a Resource Specification**: On startup, the Resource Controller posts a ResourceSpec (containing a name, category, and version) to register it in the OSL Resource Specification Catalog.
    * **QueueRegister**: The controller is registered in these three queues and listens on messages with ResourceCreate or ResourceUpdate payloads. -->

2.	**Create RFS (middle swimlane)** – This happens when there is a Service Order
    * **ServiceOrderCreate**: When a new RFS needs to be created, a “ServiceOrderCreate” operation via the TMFAPI arrives to OSOM.
    * **ServiceCreateMSG → ResourceCreateMSG**: Internally, a “ServiceCreateMSG” as well as a “ResourceCreateMSG” are sent to the TMFAPI component to create the related entities in the inventory.
    * **Resource Deployment**: OSOM sends a message to the queue under the specific queue name to CREATE the resource.
    * **CreateGenericResourceMSG**: A generic creation message is sent (e.g., CREATE/```{category_name}```/```{version}```), containing metadata such as ServiceID, ResourceID, and OrderID in the message headers.
        1. *org.etsi.osl.serviceId*: The related service ID that refers to the created resource. 
        2. *org.etsi.osl.resourceId*: The related resource ID that is the custom controller is expected to update.
        3. *org.etsi.osl.serviceOrderId*: The related service order id of the deployment request.
    * **WaitForResourceStatus**: OSOM waits for a status response indicating success or failure in creating the resource.
3.	**Resource Controller Process (lower-middle swimlane)**
    * **ProcessRequest**: After the resource is created, the Resource Controller processes any additional instructions or updates related to the resource.
    * **ResourceUpdate**: The resource is updated accordingly (e.g., changing configurations, state, etc.). The controller needs to update the resource into a valid state, e.g. AVAILABLE, RESERVED, or ALARM. For instance, if it is update in AVAILABLE state, OSOM later will assume that everything is OK, the service is ACTIVE, and the Service Order is COMPLETED, respectively.
4.	**OSOM Check Deployment (bottom swimlane)**
    * **GETResource → Check GETResource**: OSOM retrieves the resource information to verify its deployment and status.
    * **Check Resource Status**: OSOM checks whether the resource has transitioned into a valid operational state (e.g., AVAILABLE, RESERVED, or ALARM).

![Generic Controller Sequence Diagram](./images/generic_controller_seq_diagram.png)
 
## Probe further

A working example of such a generic controller can be found [here](https://labs.etsi.org/rep/osl/code/addons/org.etsi.osl.examples.gcontroller), written in Java, but in general you can implement one in any language.