# Service Ordering

**Intended Audience: OpenSlice Service Designers, Administrators**

Customer Facing Service Specifications - or also CFSSpec (organized in Service Categories) are exposed to users for Service Orders.

The Service Order process is a structured sequence of steps initiated by a customer's Service Order request for a specific service, aimed at delivering and activating the desired service or services (if it is a service bundle), as well as its related services. It begins with the customer submitting a service request through OpenSlice Services portal or the Service Order API, specifying the necessary details such as service specification, configurations, and any specific requirements.

The request is then validated and verified for completeness and eligibility by an administrator which marks the Service Order as ACKNOWLEDGED otherwise it rejects it. 

Once ACKNOWLEDGED, the service order is processed by OpenSlice orchestration system (OSOM), which schedules/automates the provisioning of the required resources and configurations, coordinating across various components such as MANO controllers for virtual network functions (VNFs), or Containerized controllers  or any 3rd party controllers or services or even physical infrastructure. The OpenSlice orchestration system ensures that all dependencies are managed and that the service is correctly configured.

After provisioning, the service is activated and handed over to the customer, . This end-to-end process ensures a seamless, efficient, and automated delivery of services, enhancing customer satisfaction and operational efficiency.

Ongoing monitoring and other actions can be performed by the Life Cycle management rules


<i>***Future developments***: 
In future releases it might be possible the ongoing monitoring and support provided to ensure continuous performance and reliability. The service could undergo a series of tests to ensure it meets the specified performance metrics and SLAs before delivering</i>

## UI management

Through the menu and dedicated forms the administrator can manage the Service Orders. Various examples in this document will guide you to the usage and the management of the Service Orders.

## API exposed

When installing OpenSlice the API endpoints can be browsed at: 
```
[YOURDOMAIN]/tmf-api/swagger-ui/index.html?urls.primaryName=tmf-api-641-ServiceOrdering-v4.0.0
```

endpoint examples:

/serviceOrdering/v4/serviceOrder List or find ServiceOrder objects




## Probe further

* See [Ordering Services from catalogs](../service_ordering/ordering_services.md)
* See [Service Design](../service_design/intro.md)