# Example: Offer Jenkins as a Service via Openslice

Before reading this example please make sure that you went through the [Design Helm as a Service](../design_helmaas.md) 

We will use the ```Kind: Application``` of ArgoCD and create a  ResourceFacingServiceSpecification for Jenkins

	1. Go to Service Specifications
	2. Create New Specification
	3. Give a Name, eg. jenkinsrfs
	4. Go to Resource Specification Relationships
	5. Assign ```Application@argoproj.io/v1alpha1@kubernetes@https://10.10.10.144:6443/```


![img02.png](./img02.png)

Focus now on the characteristics configuration.

First we need to map the lifecycle of ArgoCD Application to TMF Resource State


![img05.png](./img05.png)


In ArgoCD the field **health.status** has the value that we need to check (Healty, Progressing, etc)
 
 
The _CR_SPEC can be designed first in a YAML or json editor. Let's see a YAML definition:

 
```yaml
apiVersion: argoproj.io/v1alpha1
kind: Application
metadata:
  finalizers:
  - resources-finalizer.argocd.argoproj.io
  name: openslice-jenkins
  namespace: argocd
spec:
  project: default
  destination:
    namespace: opencrdtest
    name: in-cluster
  source:
    repoURL: https://charts.jenkins.io
    targetRevision: 4.6.1
    chart: jenkins
    helm:
      values: |
        controller:
         service:
         type: ClusterIP
  syncPolicy:
    automated:
      prune: true
      selfHeal: true
      allowEmpty: false
    syncOptions:
    - Validate=false
    - CreateNamespace=true
    - PrunePropagationPolicy=foreground
    - PruneLast=true
    - RespectIgnoreDifferences=true
```
 
**NOTICE**

On each installation OSOM will change the name of the resource in order to be unique (will have a UUID)

 ```name: openslice-jenkins``` 
 
 destination namespace that ArgoCD will use is the name ```opencrdtest```
 
 ```destination:
    namespace: opencrdtest
 ```
 
**This implies that ArgoCD installs the Jenkins always in the same namespace**
 
**To avoid this we will create a simple pre-provision rule to change the namespace properly**

See the following image: 

![img06.png](./img06.png)

 
1. Drag-Drop the _CR_SPEC block (Set characteristic value) of jenkinsrfs from the Service > Text blocks
2. Drag-Drop the Text > Formatted text block and attach it after the block from the previous step
3. Drag-Drop the Text > Multi-line text input block and attach it at the Input(String) connector of the block from the previous text 
4. Copy paste the previously provided YAML text
5. Change the spec:destination:namespace property to the value %s
6. Drag-Drop the Lists > Create list block, delete the 2 extra items (click the gear icon). Attach it at the Variables(Array) connector of the formatted text block from the previous step.
7. Drag-Drop the Service > Context > Current Service Order block and select the ID from the drop-down menu. Attach it to the List block of the previous step.
8. Save the PRE_PROVISION Rule

# Expose the service to your users

Expose then as CustomerFacingServiceSpecification by using the previous RFSS as Service Specification Relationship 

1. Create a Jenkins service and mark as Bundle and save it 
2. Go to Service Specification Relationships and assign Jenkinsrfs
3. Add also a Logo if you wish

![img03.png](./img03.png)

![img04.png](./img04.png)

 
Expose it now to a Category and a Catalog to be available for ordering.
  
![img061.png](./img061.png)




# Order the service

Order the service from the catalog. 


Soon the order will be completed and the Services will be active




![img07.png](./img07.png)

# How to access the Jenkins installation:

From the Supporting services of the Service Order, select the ResourceFacingService (jenkinsrfs)

The ResourceFacingService has also supporting resources in resource inventory.



![img08.png](./img08.png)

One is the resource reference to the application (e.g. _cr_tmpname_...), the other is a secret (e.g. cr87893...). 

Click to go to the secret resource (This is in the Resource inventory of OpenSlice)


![img09.png](./img09.png)

Use them to login in your Jenkins.


> Exposing Jenkins externally is a matter of cluster configuration and request (nodeport, load balancing, etc), thus is not a topic for this example






