# Terminology

## User Roles

* **OpenSlice Administrator**: Installs, configures and maintains an OpenSlice instance
* **OpenSlice Service Designer**: Uses available resources to design service specifications that are offered to OpenSlice users
* **OpenSlice User**: Browses and orders offered services



## Useful Terms

* **Service Specification**: A blueprint with detailed descriptions of services, including attributes, configurations, performance metrics, and SLAs (e.g. 5G Connectivity).
* **Service**: A running instance of a Service Specification.
* **Resource Specification**: A blueprint with detailed descriptions of resources, including attributes, configurations, and instantiation patterns (e.g. a Kubernetes CRD).
* **Resource**: A running instance of a Resource Specification.
* **Resource Facing Service Specification (RFSS)**: A Service Specification that exposes a Resource Specification as a Service (e.g. UPF Deployment in K8s).
* **Customer Facing Service Specification (CFSS)**: A Service Specification exposed to Users, available for Service Orders. Usually an exposed CFSS (e.g. 5G Connectivity) is a Service Bundle and comprises of other RFSSs (e.g. UPF Deployment, Core Deployment) and CFSSs (e.g. Connect Radio Nodes).
* **Resource Facing Service (RFS)**: An running instance of an RFSS, created via a Service Order of a related Service Bundle.
* **Customer Facing Service (CFS)**: An running instance of an CFSS, created via a Service Order.
* **Service Category**: A collection of CFSSs.
* **Service Catalog**: A collection of exposed Service Categories.
* **Service Inventory**: An inventory of all the service instances.
* **Resource Inventory**: An inventory of all the resource instances.

