
# METRICO: A Service that integrates external monitoring data in OpenSlice

<!-- **Intended Audience: OpenSlice Developers** -->

## Introduction
 
Services and Resources created through OpenSlice (OSL) potentially provide a vast amount of data and metrics during their runtime. These data could be leveraged to perform actions upon the said services. Before the introduction of the METRICO component, OSL would need to rely exclusively on external tools' implementation to report metrics to it.

Not anymore! METRICO is a component designed to create an inherent mechanism that initiates customizable metrics-retrieval jobs and associate the data with services under scope. To address the challenge of data retrieval across multiple and heterogeneous environments, OSL is not coupling tightly with a monitoring solution, but is able to integrate with any monitoring stack that provides a programmable API, e.g. Prometheus. Prometheus is considered a widely-utilized monitoring solution and many alternative monitoring tools converge towards its data model via implementation of Prometheus Exporters. On the other hand, OSL remains technology agnostic by capturing the monitoring requirements (e.g., data source, queries, interval, etc) through the TMF628 Performance Management model and API.

In a nutshell, METRICO allows OSL users to:

- integrate already owned monitoring systems with OSL (also supporting several parallel integrations)
- retrieve important metrics inherently through OpenSlice Service Inventory
- natively empower the service lifecycle with external data through LCM rules
- perform closed-loop control management
 
## Approach

OSL comprises of offered Service Specifications which, when ordered, create the respective Service instances, accessible through the Service Inventory (based on TMF638). The rationale behind the introduced component is that it exposes a defined METRICO Resource Specification which is used to design monitoring-related Service Specifications. The latter comprises of meaningful characteristics (e.g. monitoring data source, query, interval, affected service, etc) that are filled in by the requester.

When the user orders a monitoring-related Service Specification (with populated characteristics of its preference) a TMF628 Measurement Collection Job entity is created which is responsible for gathering the requested metrics. Respecting the desired interval, this job returns the monitoring results to the appointed service in the Service Inventory, patching a designated characteristic.

The following image illustrates the approach:

![METRICO Architecture](./images/metrico/metrico_arch_introduction.png)

Furthemore, all the interactions that occur from the time that an OSL User orders a monitoring-related Service Specification until the requested metrics are retrieved are depicted in the following sequence diagram.

![METRICO Service Sequence Diagram](./images/metrico/metrico_service_sequence_diagram.png)

## Probe further

See examples of creating Monitoring Jobs as a Service via OpenSlice:

- [Integrate Prometheus monitoring solution as-a-Service](../service_design/examples/monitoring_aas/monitoring_aas.md)

