# Network as a Service (NaaS)

This section describes some core concepts for Delivering Network as a Service in OpenSlice. There are many articles and reports on the subject like:


* TMF909 API Suite Specification for NaaS
* TMF926A Connectivity as a Service 
* TMF931-Open Gateway Onboarding and Ordering Component Suite
* GSMA Open Gatewy initiative

In general Network as a Service (NaaS) is a  service model that allows users to consume network infrastructure and services , similar to how they would consume other cloud services like Software as a Service (SaaS) or Infrastructure as a Service (IaaS). NaaS abstracts the complexity of managing physical network infrastructure, providing users with virtualized network resources that can be dynamically allocated and managed through software.


# OpenSlice and NaaS

OpenSlice makes extensive use of TMFORUM's models and APIs. Therefore if one is familiar with TMF APIs the terminology and ideas are the same.

To deliver NaaS we need to incorporate various APIs (see TMF909 API Suite Specification for NaaS). OpenSlice implements various TMF APIs to deliver NaaS and support the  lifecycle functions required to manage the network capabilities exposed as Network as a Service and managed by operational domains.



## Probe further

* Check the [TMFORUM - API assets - Onboarding and Ordering Component Suite (TMF931)](https://www.tmforum.org/oda/open-apis/partners/camara)
* For a complete list of supported APIs, see [Supported APIs](exposed_apis.md)
* Check the defined user roles of OpenSlice in our [Terminology](../terminology.md)