# LCM Rules introduction


Lifecycle Management Rules: Defining complex conditions and actions during the lifecycle of a service and any necessary modifications throughout the service lifecycle.


## Intended Audience: Service Designers

In [Naas LCM Introduction](../../naas/lcm_intro.md) it was presented briefly the LCM Rules concept.

This section goes deeply on how Service Designers can use them.



LCM Rules are used for defining complex conditions and actions during the lifecycle of a service. In Openslice there are four types of rules defined:

* PRE_PROVISION
* CREATION
* AFTER_ACTIVATION 
* SUPERVISION 
* AFTER_DEACTIVATION 


The following figure displays the different phases that the rules are performed, during the lifecycle of a Network Slice Instance.

[![Rules in NSI](./images/lcm/lcmfig1.png)](./images/lcm/lcmfig1.png)

* PRE_PROVISION rules: Run only once just before creating a service with a given priority. 
* CREATION rules: Run while the referenced service dependencies of a service are created
* AFTER_ACTIVATION rules: Run only once just after a service get the ACTIVE state
* SUPERVISION rules: Run when a characteristic of a service is changed and the service is in the ACTIVE state 
* AFTER_DEACTIVATION rules: Run only once just after a service get the INACTIVE/TERMINATED state 

In general the rules allow to perform many actions during service LCM. Thes are some examples:

* Modify service specification parameters before the instantiation of a service (or during operation) based on other dependencies. These parameters might be part of other services already included in Service order
* Translate GST/NEST parameter values to other values passed later to NFVO for instantiation or control
* Define complex OSM Configs based on other dependencies and passing variables
* Define any dependencies when creating the referenced services
* Dynamically include new service dependencies
* Create new service orders so include dynamically other services
* Call external (RESTful) services (via http(s), define payload, examine response)




## Examine if the rules are executed successfully 

Rules are transformed automatically to executable code (currently is Java). If a rule is performed successfully  or has any issues (e.g. unexpected syntax errors or exceptions) appear in OSOM logfiles and also tey are attached as Notes to the running Service.

## LCM Rules and OSOM Service Orchestration

OSOM is the responsible service for executing the rules on a specific phase. The following image explains the design in the BPMN phases:


[![Rules](./images/lcm/lcmfig1_osom.png)](./images/lcm/lcmfig1_osom.png)



## Define rules

Rules are defined when designing a Service Spec. Here is an example of a list of rules:


[![lcmrules](./images/lcm/lcmfig2.png)](./images/lcm/lcmfig2.png)

Execution order of rules on a specific phase is random

* NOTE: There is a priority field. The lower the number the highest the priority of rule execution. For example Rule with priority 0 will run before rule with priority 1.


### Definition language

* The visual language that Openslice used is based on Google's Blockly (see https://developers.google.com/blockly)
* The blockly graph is automatically translated to Java internally and then dynamically executed during orchestration phases.

The following figure is an example of such a rule design. The rule for example will run in PRE_PROVISION phase:

[![lcmrules](./images/lcm/lcmfig3.png)](./images/lcm/lcmfig3.png)

* The goal of the above rule is to properly define a variable AreaCodes given the chosen AreaOfService from a Service Order.
* On the right side the user can define some rule properties or observe the underlying generated java code.


## The blocks library

See our [LCM Blocks specification](./specification.md)




## Probe further

* Check our [examples](../examples/intro.md) for more usages
* See next the complete [specification](./specification.md)




