# Expose HELM charts as Service Specifications
Manage Helm charts installations via OpenSlice Service Specifications and Service Orders.
## Intended Audience: Service Designers


> Kubernetes is an orchestration system for automating software deployment, scaling, and management. One can interact though the Kubernetes API and it has a set of objects ready for use out of the box. 

> Helm is a tool that automates the creation, packaging, configuration, and deployment of Kubernetes applications by combining your configuration files into a single reusable package

> At the heart of Helm is the packaging format called charts. Each chart comprises one or more Kubernetes manifests -- and a given chart can have child charts and dependent charts, as well. Using Helm charts:

>       - Reduces the complexity of deploying Microservices
>       - Enhances deployment speed
>       - Developers already know the technology

> There are many Helm charts and Helm repositories there that are ready to be used

> Enable loose coupling and more orchestration scenarios

>	Developers create and deploy applications in things they already know (e.g. Helm charts)

> Use the TMF models as wrapper entities around Helm charts


Use OpenSlice to expose them in service catalogs and deploy them in complex scenarios (service bundles) involving also other systems:

	- Include e.g. RAN controllers, 
	- Pass values through life cycle rules from one service to another, 
	- Manage multiple Helms in multiple clusters


## The installation of HELM charts is based on OpenSlice CRD support

Please read more [here](../ExposingKubernetesResources.md).


For installing HELM charts we will use ArgoCD a well known Kubernetes-native continuous deployment (CD) tool 

> ArgoCD is a Kubernetes-native continuous deployment (CD) tool

> While just deploying HELM charts is just a scenario for ArgoCD , in future one can exploit it for many things

> Despite some other tools like FluxCD, it provides also a UI which is useful for management and troubleshooting


We will mainly use the CRD of ```Kind: Application``` that ArgoCD can manage



Before proceeding, install ArgoCD in your management cluster, by following ArgoCD instructions

As soon as you install ArgoCD, OpenSlice is automatically aware for specific new Kinds. The one we will use is is the ```Kind: Application``` that ArgoCD can manage under the apiGroup argoproj.io

Browse to Resource Specifications. You will see an entry like the following:

```Application@argoproj.io/v1alpha1@kubernetes@https://10.10.10.144:6443/```

see image: 

![img01.png](../../examples/helmInstallation_aaS_Example_Jenkins/img01.png)
 


## Probe further


See the [Example: Offer Jenkins as a Service via OpenSlice](../../examples/helmInstallation_aaS_Example_Jenkins/HELM_Installation_aaS_Jenkins_Example.md) 
