<img src="images/openslice_logo.png" alt="drawing" width="200"/>

**Version**: 2024Q2 ([Release Notes](https://labs.etsi.org/rep/osl/code/org.etsi.osl.main/-/releases/2024Q2))

The ETSI Software Development Group for OpenSlice (SDG OSL) is developing an open-source service-based Operations Support System (OSS) to deliver Network as a Service (NaaS) following specifications from major SDOs including ETSI, TM Forum and GSMA.


## Usage

OpenSlice can be used in managing 5G network services from the user device to the core network and cloud as well as for Orchestrating cloud resources across private and public clouds for enterprise applications.  OpenSlice is capable of supporting most of the features of an end-to-end (E2E) service orchestration framework while many of them will be more mature in future releases. The following figure displays the general usage of OpenSlice. 

[![OpenSlice  usage](./images/global_approach.png)](./images/global_approach.png)

The image illustrates how OpenSlice supports the idea of an E2E network service orchestration framework by integrating multiple network components and layers, from user devices at the edge to radio, transport networks, core and public cloud services, ensuring seamless, secure, and efficient delivery of network services. Assuming that there are domain controllers for all the above domains OpenSlice can create the end-to-end service via the domain controllers by following the process of creating and deploying the end-to-end service by implementing transformations, and consuming APIs from various network entities.
OpenSlice, in a nutchell, offers user interfaces where users can interact with the framework to order, expose, and manage service catalogs, services and resources that can be ordered, following business logic and policies and exposed through the APIs. 

### An end-to-end (E2E) service orchestration framework 

An end-to-end (E2E) service orchestration framework is designed to manage and automate the entire lifecycle of services across multiple domains and technologies. For delivering, especially, Network as a Service (NaaS) a comprehensive system is needed that automates and manages the entire lifecycle of network services, from provisioning to monitoring and decommissioning, while ensuring seamless integration, operation, and delivery of services from the initial request to the final delivery, spanning all involved components and layers. Such E2E frameworks enable users to consume network services on-demand, similar to how cloud computing services are consumed. Some key components and features of such frameworks are:

- Service Catalogs including predefined Network Services based on service templates for common network services like 5G core functions, 5G slices, VPNs, SD-WAN, firewalls, load balancers, etc. as well as custom Network services with Options for users to define their own network configurations.
- User Interface (UI) and APIs exposure, offering both a Self-Service Portal that allows users to request, configure, and manage network services as well as APIs for enabling programmatic access to network services for integration with other systems and automation scripts.
- Service Design and Creation through service templates based on predefined models for creating services.
- Automation and Workflow Management via Orchestration Engines, supporting  Process Automation for automating repetitive tasks and processes,  workflow management and orchestration for automating the provisioning, configuration, and management of network services while coordinating multiple workflows to ensure services are delivered efficiently, ensuring that services comply with predefined policies and standards.
- Standardized API exposure for seamless integration with different systems and services and APIs transformation support for converting data formats and protocols to ensure compatibility and information exchange between systems during workflows orchestration
- Service and Resource management and Orchestration while including the capability of multi-domain coordination in managing services/resources across different domains like cloud, 5G core, radios, transport network, and edge including dynamic allocation with adjusting resources based on demand and service requirements. To accomplish the above advanced technologies need to be exploited like, Containerized workloads,  Network Function Virtualization (NFV) which uses virtualized network functions to provide services like routing, switching, and security and Software-Defined Networking (SDN) which Controls the network programmatically to dynamically manage traffic and resources.
- Monitoring and Analytics including  Service Monitoring while continuously tracking the performance and health of services with capabilities to analyse data to optimize service delivery and predict issues. Real-Time Monitoring is also needed for tracking the performance and health of network services enabling analytics that provide insights for optimization and troubleshooting.
- Security and Access Control for ensuring only authorized users and systems can access network services. while implementing rules and policies to comply with regulatory requirements.

### An E2E service orchestration workflow

In general an E2E service orchestration workflow includes the following phases:

- Service Request: Users or systems request a network service through the self-service portal or API. The request can specify details such as bandwidth, security features, geographic coverage, and duration.
- Service Orchestration: The orchestration engine evaluates the request, determines the necessary resources, and initiates the automated workflows.It interacts with the underlying components (e.g. 5G Core, Radios, Containerized controllers, NFV, SDN controllers ) to provision and configure the required network functions and connectivity.
- Provisioning and Configuration: Services, network resources and network functions (VNFs) are instantiated and configured according to the service request during Service Orchestration through the orchestration engine. Other controllers manage their own domains, for example SDN controllers, manage the flow of data through the network to ensure optimal performance and adherence to policies, RAN controllers manage the RAN resources, Containerized controllers manage their workload, etc
- Service Delivery: The E2E network service is activated and made available to the user. Continuous monitoring ensures the service operates as expected, with automatic adjustments made as necessary.
- Lifecycle Management: The orchestration framework handles updates, scaling, and any necessary modifications throughout the service lifecycle.
- At the end of the service period, resources are decommissioned and reclaimed.


### OpenSlice for Service Providers

OpenSlice is used by Service Providers to design Network Services, expose them in Service Catalogues and make them available for Service Orders. OpenSlice then can perform the E2E service orchestration workflow.

There are various portals offering UI friendly access to users acting as Service Providers:

* The Services portal allows Service Providers to design and expose services.
* The Resource portal allows users to access resource specifications and running resources in resource inventory.
* The NFV portal allows users to manage NFV artifacts and onboard them to a target MANO/NFV Orchestrator.
* The Testing portal allows Service Providers to manage test artifacts
* The Products portal allows Service Providers to expose services as products

### OpenSlice for Service Consumers

OpenSlice allows Service Consumers to browse the available offered service specifications in a self-service manner. It also supports TMFORUM Northbound APIs  regarding Service Catalog Management, Ordering, Resource, etc.
There are various portals offering UI friendly access to users acting as Service Consumers:

* The Services portal allows Service Consumers to select and order predefined services.
* The Resource portal allows users to access running resources in resource inventory.
* The NFV portal allows users to self-manage NFV artifacts and onboard them to a target MANO/NFV Orchestrator.
* The Testing portal allows Service Consumers to manage test artifacts
* The Products portal allows Service Consumers to expose services as products

3rd party applications can use OpenSlice through TMForum Open APIs.



## Live Demo

Check a live demo of OpenSlice in the following pages:

* OpenSlice demo: <http://portal.openslice.eu/>
* OpenSlice Service Catalogs and ordering: <http://portal.openslice.eu/services/>
* OpenSlice NFV Services onboarding: <http://portal.openslice.eu/nfvportal>

Login credentials:

* username=admin, password=openslice 
* username=admin, password=changeme

# Probe further

* Installing OpenSlice. See the [Deployment](deployment.md) of OpenSlice
* Learn more on [how OpenSlice supports Network as a Service(NaaS)](./naas/introduction)
* Who is implementing OpenSlice? See [OSL ETSI SDG](https://osl.etsi.org/)
* How OpenSlice works? See the [Architecture](./architecture/architecture.md) of OpenSlice
