# Examples of Rules


The following images provide some examples of rules.

### Define variables according to cases

In the following example we :

* define a String variable. 
* Then according to the Area of Service selected from the Service Order of the Service Specification we need to define it properly.
* We output the value to the OSOM Log
* Define dynamically the value of another parameter (This is fictional) and then do some other condition check

The strAreaCodes could be passed then e.g. to NFVO for instantiation of services to these cells.


![lcmrules](./images/lcm/lcmfig9.png)




### Define Rules to create a resource for a Kubernetes Operator

* Modify the _CR_SPEC characteristic
* Add an "Input with variables block"
* Add a multiline Text block
* Mark with %s, %d, etc the parameters to modify with some action
* Add a list with the variables and their values

in the example we modify a YAML spec with parama, paramb, action values from the characteristics spec.parama, spec.paramb, spec.action

![lcmrules](./images/lcm/lcmfig15.png)


### Define complex OSM configs for DAY 0

The following displays some complex examples for defining the parameters to pass to the NFV. In this case is OSM.

* NOTE: The OSM_CONFIG characteristic of a service is the one that it is used in orchestration to instantiate NS from OSM

* check the variable strTargetsParam. It is passed to the variable strOsmConfig3 which is executed if the Number of Cameras is more than 100. 
* if the Video quality requested is 3, then the Maximum Namber of camers will be 8. Check the OSM detailed configuration block and its syntax.
* if the Video quality requested is 2, we use a simpler OSM Config block to configure the parameter OSM_CONFIG. We just injected a json text ( watch the Escape of the string for the Quotes!)
* if the Video quality requested is 1, again we use a simpler OSM Config block to configure the parameter OSM_CONFIG. We use as injected json text a variable constructed later


![lcmrules](./images/lcm/lcmfig10.png)


### Define and instantiate different services according to Service Order request

In the following example we would like to offer a service either as Platinum, Gold or Silver. Depending on the selection we need to instantiate different services.

There are different ways to accomplish this:

* create dynamically New Service Orders of RFSs with equivalent quality of Services
* change for example the VIMs that you deploy the NS
* change the NSD (that is use different VNFs)

The following image displays for example the latter case.

![lcmrules](./images/lcm/lcmfig11.png)


### Call an external RESTful service

This is useful in cases for example of alarms , external logging, calling other services e.g. email or even a complex algorithm written in other language e.g. call an external service and get a result. (service e.g. a Python service)


![lcmrules](./images/lcm/lcmfig12.png)

![lcmrules](./images/lcm/lcmfig13.png)

### Create New Service Orders

The following example calls to Order a New Service Specification with specific Parameter Values

![lcmrules](./images/lcm/lcmfig14.png)