# Catalogs and Templates

The OpenSlice Service Catalogue (accessible through the API or Services portal) contains the representation of Service Specifications, either created from the provider defining service attributes, or by supporting the GSMA Generic Slice Templates (GST) as well as the VINNI Service Blueprint. The following scenarios are supported by the OpenSlice Service Catalogue.


## Create/Design a Service Specification

 
### Create/Design a Customer Facing Service Specification (CFSS)

Customer Facing Service Specification are the services offered to customers. You can create a new Service Specification from the menu. The services created through the UI are Customer Facing Services Specifications (CFSSs). 

While CFSSs can describe an overall offered service, it must also contain the related realization (how this service is going to be offered). Usually you create a CFSS as a bundle and then you include Service Specification Relationships with Resource Facing Service Specifications (RFSSs) or/and other CFSSs. A CFSS can include multiple RFSS or/and CFSs.

For example you can create a CFS spec called "A 5G Service" which is a bundle of two other services (include them in Service Specification Relationships) such as 5G eMBB Slice and a Customer VPN. So when the user orders "A 5G Service", a 5G eMBB Slice and a Customer VPN will be created during the order.

### Assign Resources as Resource Facing Service Specifications (RFSSs)

The Resource Facing Service Specifation (RFSS) is the realization of the designed services. It utilizes specific resources to offer the described service.

For instance, OpenSlice can utilize Kubernetes and NFV resource to deploy the respective services through the corresponding stack, as seen in [Probe further section](#probe-further).



### Generic Slice Templates (GST) 
(Offered only as a design for now. THere is no direct implementation to NFV)
On October 16th 2019 GSMA published NG.116  Version 2.0 which defines the Generic Network Slice Template (GST). GST is a set of attributes that can characterise a type of network slice/service. GST is generic and is not tied to any specific network deployment. Here is a list of the various attributes of the template:

-	Availability
-	Area of Service
-	Delay tolerance
-	Deterministic communication
-	Downlink throughput per network slice
-	Downlink throughput per UE
-	Energy efficiency
-	Group communication support
-	Isolation level
-	Location based message delivery
-	Maximum supported packet size
-	Mission critical support
-	MMTel support
-	NB-IoT support
-	Network Slice Customer network functions
-	Number of connections
-	Number of terminals
-	Performance monitoring
-	Performance prediction
-	Positioning support
-	Radio spectrum
-	Reliability
-	Root cause investigation
-	Session and Service Continuity support 
-	Simultaneous use of the network slice
-	Slice quality of service parameters
-	Support for non-IP traffic 
-	Supported access technologies 
-	Supported device velocity 
-	Synchronicity
-	Terminal density 
-	Uplink throughput per network slice 
-	Uplink throughput per UE
-	User management openness
-	User data access 
-	V2X communication mode

OpenSlice offers the GST in a format that is machine readable and aligned with the TMF SID model. Here is a tentative approach in JSON : <https://labs.etsi.org/rep/osl/code/org.etsi.osl.tmf.api/-/blob/main/src/main/resources/gst.json>

Providers can clone a GST as e NEST directly in OpenSlice Web portal and the adjust the default attributes to their Service Specification.


## Manage a Service Specification

You may manage Service Specifications though the respective Web UI.


## Assign a Service Specification to Service Categories and Publish 

You may create Service Categories and from the menu provided to group Specifications under the same context, and then from the Service Category management UI you may assign Specifications to it.

You cannot publish a Service Specification directly, but you may include the created Service Category into a public Service Catalog, which is exposed through the Service Marketplace. Doing so, all the assigned Service Specification to the Category are exposed and available for ordering, as well.


## Retire/Remove a Service Specification

Delete it from the assigned Service Category. This action does not delete the actual Service Specification, which can be done from the respective list.


## Consume and expose Service Specifications from other Service Catalogues 

See more on [Consuming Services From External Partner Organizations]( ../getting_started/configuration/consuming_services_from_external_partners.md).

## Probe further

[Design Kubernetes-based Service Specifications](./kubernetes/exposing_kubernetes_resources.md/)

[Design NFV/OSM-based Service Specifications](./nfv/design_nfv_services.md)
